/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ToggleKeyMapping;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.IKeyMappingExtension;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyMappingLookup;
import net.neoforged.neoforge.client.settings.KeyModifier;

@OnlyIn(value=Dist.CLIENT)
public class KeyMapping
implements Comparable<KeyMapping>,
IKeyMappingExtension {
    private static final Map<String, KeyMapping> ALL = Maps.newConcurrentMap();
    private static final KeyMappingLookup MAP = new KeyMappingLookup();
    private static final Set<String> CATEGORIES = Sets.newConcurrentHashSet();
    public static final String CATEGORY_MOVEMENT = "key.categories.movement";
    public static final String CATEGORY_MISC = "key.categories.misc";
    public static final String CATEGORY_MULTIPLAYER = "key.categories.multiplayer";
    public static final String CATEGORY_GAMEPLAY = "key.categories.gameplay";
    public static final String CATEGORY_INVENTORY = "key.categories.inventory";
    public static final String CATEGORY_INTERFACE = "key.categories.ui";
    public static final String CATEGORY_CREATIVE = "key.categories.creative";
    private static final Map<String, Integer> CATEGORY_SORT_ORDER = Util.make(Maps.newHashMap(), p_90845_ -> {
        p_90845_.put(CATEGORY_MOVEMENT, 1);
        p_90845_.put(CATEGORY_GAMEPLAY, 2);
        p_90845_.put(CATEGORY_INVENTORY, 3);
        p_90845_.put(CATEGORY_CREATIVE, 4);
        p_90845_.put(CATEGORY_MULTIPLAYER, 5);
        p_90845_.put(CATEGORY_INTERFACE, 6);
        p_90845_.put(CATEGORY_MISC, 7);
    });
    private final String name;
    private final InputConstants.Key defaultKey;
    private final String category;
    private InputConstants.Key key;
    boolean isDown;
    private int clickCount;
    private KeyModifier keyModifierDefault = KeyModifier.NONE;
    private KeyModifier keyModifier = KeyModifier.NONE;
    private IKeyConflictContext keyConflictContext = KeyConflictContext.UNIVERSAL;

    public static void click(InputConstants.Key p_90836_) {
        for (KeyMapping keymapping : MAP.getAll(p_90836_)) {
            if (keymapping == null) continue;
            ++keymapping.clickCount;
        }
    }

    public static void set(InputConstants.Key p_90838_, boolean p_90839_) {
        for (KeyMapping keymapping : MAP.getAll(p_90838_, !p_90839_)) {
            if (keymapping == null) continue;
            keymapping.setDown(p_90839_);
        }
    }

    public static void setAll() {
        for (KeyMapping keymapping : ALL.values()) {
            if (keymapping.key.getType() != InputConstants.Type.KEYSYM || keymapping.key.getValue() == InputConstants.UNKNOWN.getValue()) continue;
            keymapping.setDown(InputConstants.isKeyDown(Minecraft.getInstance().getWindow().getWindow(), keymapping.key.getValue()));
        }
    }

    public static void releaseAll() {
        for (KeyMapping keymapping : ALL.values()) {
            keymapping.release();
        }
    }

    public static void resetToggleKeys() {
        for (KeyMapping keymapping : ALL.values()) {
            if (!(keymapping instanceof ToggleKeyMapping)) continue;
            ToggleKeyMapping togglekeymapping = (ToggleKeyMapping)keymapping;
            togglekeymapping.reset();
        }
    }

    public static void resetMapping() {
        MAP.clear();
        for (KeyMapping keymapping : ALL.values()) {
            MAP.put(keymapping.key, keymapping);
        }
    }

    public KeyMapping(String p_90821_, int p_90822_, String p_90823_) {
        this(p_90821_, InputConstants.Type.KEYSYM, p_90822_, p_90823_);
    }

    public KeyMapping(String p_90825_, InputConstants.Type p_90826_, int p_90827_, String p_90828_) {
        this.name = p_90825_;
        this.defaultKey = this.key = p_90826_.getOrCreate(p_90827_);
        this.category = p_90828_;
        ALL.put(p_90825_, this);
        MAP.put(this.key, this);
        CATEGORIES.add(p_90828_);
    }

    public boolean isDown() {
        return this.isDown && this.isConflictContextAndModifierActive();
    }

    public String getCategory() {
        return this.category;
    }

    public boolean consumeClick() {
        if (this.clickCount == 0) {
            return false;
        }
        --this.clickCount;
        return true;
    }

    private void release() {
        this.clickCount = 0;
        this.setDown(false);
    }

    public String getName() {
        return this.name;
    }

    public InputConstants.Key getDefaultKey() {
        return this.defaultKey;
    }

    public void setKey(InputConstants.Key p_90849_) {
        this.key = p_90849_;
    }

    @Override
    public int compareTo(KeyMapping p_90841_) {
        if (this.category.equals(p_90841_.category)) {
            return I18n.get(this.name, new Object[0]).compareTo(I18n.get(p_90841_.name, new Object[0]));
        }
        Integer tCat = CATEGORY_SORT_ORDER.get(this.category);
        Integer oCat = CATEGORY_SORT_ORDER.get(p_90841_.category);
        if (tCat == null && oCat != null) {
            return 1;
        }
        if (tCat != null && oCat == null) {
            return -1;
        }
        if (tCat == null && oCat == null) {
            return I18n.get(this.category, new Object[0]).compareTo(I18n.get(p_90841_.category, new Object[0]));
        }
        return tCat.compareTo(oCat);
    }

    public static Supplier<Component> createNameSupplier(String p_90843_) {
        KeyMapping keymapping = ALL.get(p_90843_);
        return keymapping == null ? () -> Component.translatable(p_90843_) : keymapping::getTranslatedKeyMessage;
    }

    public boolean same(KeyMapping p_90851_) {
        if (this.getKeyConflictContext().conflicts(p_90851_.getKeyConflictContext()) || p_90851_.getKeyConflictContext().conflicts(this.getKeyConflictContext())) {
            KeyModifier keyModifier = this.getKeyModifier();
            KeyModifier otherKeyModifier = p_90851_.getKeyModifier();
            if (keyModifier.matches(p_90851_.getKey()) || otherKeyModifier.matches(this.getKey())) {
                return true;
            }
            if (this.getKey().equals(p_90851_.getKey())) {
                return keyModifier == otherKeyModifier || this.getKeyConflictContext().conflicts((IKeyConflictContext)KeyConflictContext.IN_GAME) && (keyModifier == KeyModifier.NONE || otherKeyModifier == KeyModifier.NONE);
            }
        }
        return this.key.equals(p_90851_.key);
    }

    public boolean isUnbound() {
        return this.key.equals(InputConstants.UNKNOWN);
    }

    public boolean matches(int p_90833_, int p_90834_) {
        return p_90833_ == InputConstants.UNKNOWN.getValue() ? this.key.getType() == InputConstants.Type.SCANCODE && this.key.getValue() == p_90834_ : this.key.getType() == InputConstants.Type.KEYSYM && this.key.getValue() == p_90833_;
    }

    public boolean matchesMouse(int p_90831_) {
        return this.key.getType() == InputConstants.Type.MOUSE && this.key.getValue() == p_90831_;
    }

    public Component getTranslatedKeyMessage() {
        return this.getKeyModifier().getCombinedName(this.key, () -> this.key.getDisplayName());
    }

    public boolean isDefault() {
        return this.key.equals(this.defaultKey) && this.getKeyModifier() == this.getDefaultKeyModifier();
    }

    public String saveString() {
        return this.key.getName();
    }

    public void setDown(boolean p_90846_) {
        this.isDown = p_90846_;
    }

    @Nullable
    public static KeyMapping get(String p_389468_) {
        return ALL.get(p_389468_);
    }

    public KeyMapping(String description, IKeyConflictContext keyConflictContext, InputConstants.Type inputType, int keyCode, String category) {
        this(description, keyConflictContext, inputType.getOrCreate(keyCode), category);
    }

    public KeyMapping(String description, IKeyConflictContext keyConflictContext, InputConstants.Key keyCode, String category) {
        this(description, keyConflictContext, KeyModifier.NONE, keyCode, category);
    }

    public KeyMapping(String description, IKeyConflictContext keyConflictContext, KeyModifier keyModifier, InputConstants.Type inputType, int keyCode, String category) {
        this(description, keyConflictContext, keyModifier, inputType.getOrCreate(keyCode), category);
    }

    public KeyMapping(String description, IKeyConflictContext keyConflictContext, KeyModifier keyModifier, InputConstants.Key keyCode, String category) {
        this.name = description;
        this.key = keyCode;
        this.defaultKey = keyCode;
        this.category = category;
        this.keyConflictContext = keyConflictContext;
        this.keyModifier = keyModifier;
        this.keyModifierDefault = keyModifier;
        if (this.keyModifier.matches(keyCode)) {
            this.keyModifier = KeyModifier.NONE;
        }
        ALL.put(description, this);
        MAP.put(keyCode, this);
        CATEGORIES.add(category);
    }

    public InputConstants.Key getKey() {
        return this.key;
    }

    public void setKeyConflictContext(IKeyConflictContext keyConflictContext) {
        this.keyConflictContext = keyConflictContext;
    }

    public IKeyConflictContext getKeyConflictContext() {
        return this.keyConflictContext;
    }

    public KeyModifier getDefaultKeyModifier() {
        return this.keyModifierDefault;
    }

    public KeyModifier getKeyModifier() {
        return this.keyModifier;
    }

    public void setKeyModifierAndCode(KeyModifier keyModifier, InputConstants.Key keyCode) {
        this.key = keyCode;
        if (keyModifier.matches(keyCode)) {
            keyModifier = KeyModifier.NONE;
        }
        MAP.remove(this);
        this.keyModifier = keyModifier;
        MAP.put(keyCode, this);
    }
}

