/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;

public record WrappedMinMaxBounds(@Nullable Float min, @Nullable Float max) {
    public static final WrappedMinMaxBounds ANY = new WrappedMinMaxBounds(null, null);
    public static final SimpleCommandExceptionType ERROR_INTS_ONLY = new SimpleCommandExceptionType((Message)Component.translatable("argument.range.ints"));

    public static WrappedMinMaxBounds exactly(float p_164403_) {
        return new WrappedMinMaxBounds(Float.valueOf(p_164403_), Float.valueOf(p_164403_));
    }

    public static WrappedMinMaxBounds between(float p_164405_, float p_164406_) {
        return new WrappedMinMaxBounds(Float.valueOf(p_164405_), Float.valueOf(p_164406_));
    }

    public static WrappedMinMaxBounds atLeast(float p_164415_) {
        return new WrappedMinMaxBounds(Float.valueOf(p_164415_), null);
    }

    public static WrappedMinMaxBounds atMost(float p_164418_) {
        return new WrappedMinMaxBounds(null, Float.valueOf(p_164418_));
    }

    public boolean matches(float p_164420_) {
        if (this.min != null && this.max != null && this.min.floatValue() > this.max.floatValue() && this.min.floatValue() > p_164420_ && this.max.floatValue() < p_164420_) {
            return false;
        }
        return this.min != null && this.min.floatValue() > p_164420_ ? false : this.max == null || !(this.max.floatValue() < p_164420_);
    }

    public boolean matchesSqr(double p_164401_) {
        if (this.min != null && this.max != null && this.min.floatValue() > this.max.floatValue() && (double)(this.min.floatValue() * this.min.floatValue()) > p_164401_ && (double)(this.max.floatValue() * this.max.floatValue()) < p_164401_) {
            return false;
        }
        return this.min != null && (double)(this.min.floatValue() * this.min.floatValue()) > p_164401_ ? false : this.max == null || !((double)(this.max.floatValue() * this.max.floatValue()) < p_164401_);
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        if (this.min != null && this.max != null && this.min.equals(this.max)) {
            return new JsonPrimitive((Number)this.min);
        }
        JsonObject jsonobject = new JsonObject();
        if (this.min != null) {
            jsonobject.addProperty("min", (Number)this.min);
        }
        if (this.max != null) {
            jsonobject.addProperty("max", (Number)this.min);
        }
        return jsonobject;
    }

    public static WrappedMinMaxBounds fromJson(@Nullable JsonElement p_164408_) {
        if (p_164408_ == null || p_164408_.isJsonNull()) {
            return ANY;
        }
        if (GsonHelper.isNumberValue(p_164408_)) {
            float f2 = GsonHelper.convertToFloat(p_164408_, "value");
            return new WrappedMinMaxBounds(Float.valueOf(f2), Float.valueOf(f2));
        }
        JsonObject jsonobject = GsonHelper.convertToJsonObject(p_164408_, "value");
        Float f = jsonobject.has("min") ? Float.valueOf(GsonHelper.getAsFloat(jsonobject, "min")) : null;
        Float f1 = jsonobject.has("max") ? Float.valueOf(GsonHelper.getAsFloat(jsonobject, "max")) : null;
        return new WrappedMinMaxBounds(f, f1);
    }

    public static WrappedMinMaxBounds fromReader(StringReader p_164410_, boolean p_164411_) throws CommandSyntaxException {
        return WrappedMinMaxBounds.fromReader(p_164410_, p_164411_, p_164413_ -> p_164413_);
    }

    public static WrappedMinMaxBounds fromReader(StringReader p_75360_, boolean p_75361_, Function<Float, Float> p_75362_) throws CommandSyntaxException {
        Float f1;
        if (!p_75360_.canRead()) {
            throw MinMaxBounds.ERROR_EMPTY.createWithContext((ImmutableStringReader)p_75360_);
        }
        int i = p_75360_.getCursor();
        Float f = WrappedMinMaxBounds.optionallyFormat(WrappedMinMaxBounds.readNumber(p_75360_, p_75361_), p_75362_);
        if (p_75360_.canRead(2) && p_75360_.peek() == '.' && p_75360_.peek(1) == '.') {
            p_75360_.skip();
            p_75360_.skip();
            f1 = WrappedMinMaxBounds.optionallyFormat(WrappedMinMaxBounds.readNumber(p_75360_, p_75361_), p_75362_);
            if (f == null && f1 == null) {
                p_75360_.setCursor(i);
                throw MinMaxBounds.ERROR_EMPTY.createWithContext((ImmutableStringReader)p_75360_);
            }
        } else {
            if (!p_75361_ && p_75360_.canRead() && p_75360_.peek() == '.') {
                p_75360_.setCursor(i);
                throw ERROR_INTS_ONLY.createWithContext((ImmutableStringReader)p_75360_);
            }
            f1 = f;
        }
        if (f == null && f1 == null) {
            p_75360_.setCursor(i);
            throw MinMaxBounds.ERROR_EMPTY.createWithContext((ImmutableStringReader)p_75360_);
        }
        return new WrappedMinMaxBounds(f, f1);
    }

    @Nullable
    private static Float readNumber(StringReader p_75368_, boolean p_75369_) throws CommandSyntaxException {
        int i = p_75368_.getCursor();
        while (p_75368_.canRead() && WrappedMinMaxBounds.isAllowedNumber(p_75368_, p_75369_)) {
            p_75368_.skip();
        }
        String s = p_75368_.getString().substring(i, p_75368_.getCursor());
        if (s.isEmpty()) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(s));
        }
        catch (NumberFormatException numberformatexception) {
            if (p_75369_) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidDouble().createWithContext((ImmutableStringReader)p_75368_, (Object)s);
            }
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt().createWithContext((ImmutableStringReader)p_75368_, (Object)s);
        }
    }

    private static boolean isAllowedNumber(StringReader p_75371_, boolean p_75372_) {
        char c0 = p_75371_.peek();
        if ((c0 < '0' || c0 > '9') && c0 != '-') {
            return p_75372_ && c0 == '.' ? !p_75371_.canRead(2) || p_75371_.peek(1) != '.' : false;
        }
        return true;
    }

    @Nullable
    private static Float optionallyFormat(@Nullable Float p_75364_, Function<Float, Float> p_75365_) {
        return p_75364_ == null ? null : p_75365_.apply(p_75364_);
    }
}

