/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class SlideDownBlockTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @Override
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer p_66979_, BlockState p_66980_) {
        this.trigger(p_66979_, (T p_66986_) -> p_66986_.matches(p_66980_));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<Holder<Block>> block, Optional<StatePropertiesPredicate> state) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(p_359057_ -> p_359057_.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)BuiltInRegistries.BLOCK.holderByNameCodec().optionalFieldOf("block").forGetter(TriggerInstance::block), (App)StatePropertiesPredicate.CODEC.optionalFieldOf("state").forGetter(TriggerInstance::state)).apply((Applicative)p_359057_, TriggerInstance::new)).validate(TriggerInstance::validate);

        private static DataResult<TriggerInstance> validate(TriggerInstance p_312038_) {
            return p_312038_.block.flatMap(p_311441_ -> p_312038_.state.flatMap(p_311443_ -> p_311443_.checkState(((Block)p_311441_.value()).getStateDefinition())).map(p_311445_ -> DataResult.error(() -> "Block" + String.valueOf(p_311441_) + " has no property " + p_311445_))).orElseGet(() -> DataResult.success((Object)p_312038_));
        }

        public static Criterion<TriggerInstance> slidesDownBlock(Block p_67007_) {
            return CriteriaTriggers.HONEY_BLOCK_SLIDE.createCriterion(new TriggerInstance(Optional.empty(), Optional.of(p_67007_.builtInRegistryHolder()), Optional.empty()));
        }

        public boolean matches(BlockState p_67009_) {
            return this.block.isPresent() && !p_67009_.is(this.block.get()) ? false : !this.state.isPresent() || this.state.get().matches(p_67009_);
        }
    }
}

