/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.HolderGetter;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootContext;

public class KilledByArrowTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @Override
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer p_373039_, Collection<Entity> p_373041_, @Nullable ItemStack p_373082_) {
        ArrayList list = Lists.newArrayList();
        HashSet set = Sets.newHashSet();
        for (Entity entity : p_373041_) {
            set.add(entity.getType());
            list.add(EntityPredicate.createContext(p_373039_, entity));
        }
        this.trigger(p_373039_, p_372912_ -> p_372912_.matches(list, set.size(), p_373082_));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, List<ContextAwarePredicate> victims, MinMaxBounds.Ints uniqueEntityTypes, Optional<ItemPredicate> firedFromWeapon) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(p_373084_ -> p_373084_.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EntityPredicate.ADVANCEMENT_CODEC.listOf().optionalFieldOf("victims", List.of()).forGetter(TriggerInstance::victims), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("unique_entity_types", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::uniqueEntityTypes), (App)ItemPredicate.CODEC.optionalFieldOf("fired_from_weapon").forGetter(TriggerInstance::firedFromWeapon)).apply((Applicative)p_373084_, TriggerInstance::new));

        public static Criterion<TriggerInstance> crossbowKilled(HolderGetter<Item> p_373005_, EntityPredicate.Builder ... p_373068_) {
            return CriteriaTriggers.KILLED_BY_ARROW.createCriterion(new TriggerInstance(Optional.empty(), EntityPredicate.wrap(p_373068_), MinMaxBounds.Ints.ANY, Optional.of(ItemPredicate.Builder.item().of(p_373005_, Items.CROSSBOW).build())));
        }

        public static Criterion<TriggerInstance> crossbowKilled(HolderGetter<Item> p_373076_, MinMaxBounds.Ints p_372922_) {
            return CriteriaTriggers.KILLED_BY_ARROW.createCriterion(new TriggerInstance(Optional.empty(), List.of(), p_372922_, Optional.of(ItemPredicate.Builder.item().of(p_373076_, Items.CROSSBOW).build())));
        }

        public boolean matches(Collection<LootContext> p_372887_, int p_372892_, @Nullable ItemStack p_372931_) {
            if (!this.firedFromWeapon.isPresent() || p_372931_ != null && this.firedFromWeapon.get().test(p_372931_)) {
                if (!this.victims.isEmpty()) {
                    ArrayList list = Lists.newArrayList(p_372887_);
                    for (ContextAwarePredicate contextawarepredicate : this.victims) {
                        boolean flag = false;
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            LootContext lootcontext = (LootContext)iterator.next();
                            if (!contextawarepredicate.matches(lootcontext)) continue;
                            iterator.remove();
                            flag = true;
                            break;
                        }
                        if (flag) continue;
                        return false;
                    }
                }
                return this.uniqueEntityTypes.matches(p_372892_);
            }
            return false;
        }

        @Override
        public void validate(CriterionValidator p_373032_) {
            SimpleCriterionTrigger.SimpleInstance.super.validate(p_373032_);
            p_373032_.validateEntities(this.victims, "victims");
        }
    }
}

