/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public record FluidPredicate(Optional<HolderSet<Fluid>> fluids, Optional<StatePropertiesPredicate> properties) {
    public static final Codec<FluidPredicate> CODEC = RecordCodecBuilder.create(p_337366_ -> p_337366_.group((App)RegistryCodecs.homogeneousList(Registries.FLUID).optionalFieldOf("fluids").forGetter(FluidPredicate::fluids), (App)StatePropertiesPredicate.CODEC.optionalFieldOf("state").forGetter(FluidPredicate::properties)).apply((Applicative)p_337366_, FluidPredicate::new));

    public boolean matches(ServerLevel p_41105_, BlockPos p_41106_) {
        if (!p_41105_.isLoaded(p_41106_)) {
            return false;
        }
        FluidState fluidstate = p_41105_.getFluidState(p_41106_);
        return this.fluids.isPresent() && !fluidstate.is(this.fluids.get()) ? false : !this.properties.isPresent() || this.properties.get().matches(fluidstate);
    }

    public static class Builder {
        private Optional<HolderSet<Fluid>> fluids = Optional.empty();
        private Optional<StatePropertiesPredicate> properties = Optional.empty();

        private Builder() {
        }

        public static Builder fluid() {
            return new Builder();
        }

        public Builder of(Fluid p_151172_) {
            this.fluids = Optional.of(HolderSet.direct(p_151172_.builtInRegistryHolder()));
            return this;
        }

        public Builder of(HolderSet<Fluid> p_330492_) {
            this.fluids = Optional.of(p_330492_);
            return this;
        }

        public Builder setProperties(StatePropertiesPredicate p_151170_) {
            this.properties = Optional.of(p_151170_);
            return this;
        }

        public FluidPredicate build() {
            return new FluidPredicate(this.fluids, this.properties);
        }
    }
}

