/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public interface CollectionContentsPredicate<T, P extends Predicate<T>>
extends Predicate<Iterable<T>> {
    public List<P> unpack();

    public static <T, P extends Predicate<T>> Codec<CollectionContentsPredicate<T, P>> codec(Codec<P> p_341117_) {
        return p_341117_.listOf().xmap(CollectionContentsPredicate::of, CollectionContentsPredicate::unpack);
    }

    @SafeVarargs
    public static <T, P extends Predicate<T>> CollectionContentsPredicate<T, P> of(P ... p_341163_) {
        return CollectionContentsPredicate.of(List.of(p_341163_));
    }

    public static <T, P extends Predicate<T>> CollectionContentsPredicate<T, P> of(List<P> p_341230_) {
        return switch (p_341230_.size()) {
            case 0 -> new Zero();
            case 1 -> new Single((Predicate)p_341230_.getFirst());
            default -> new Multiple(p_341230_);
        };
    }

    public static class Zero<T, P extends Predicate<T>>
    implements CollectionContentsPredicate<T, P> {
        @Override
        public boolean test(Iterable<T> p_341091_) {
            return true;
        }

        @Override
        public List<P> unpack() {
            return List.of();
        }
    }

    public record Single<T, P extends Predicate<T>>(P test) implements CollectionContentsPredicate<T, P>
    {
        @Override
        public boolean test(Iterable<T> p_340831_) {
            for (T t : p_340831_) {
                if (!this.test.test(t)) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<P> unpack() {
            return List.of(this.test);
        }
    }

    public record Multiple<T, P extends Predicate<T>>(List<P> tests) implements CollectionContentsPredicate<T, P>
    {
        @Override
        public boolean test(Iterable<T> p_340977_) {
            ArrayList<P> list = new ArrayList<P>(this.tests);
            for (Object t : p_340977_) {
                list.removeIf(p_341085_ -> p_341085_.test(t));
                if (!list.isEmpty()) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<P> unpack() {
            return this.tests;
        }
    }
}

