/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public record BlockPredicate(Optional<HolderSet<Block>> blocks, Optional<StatePropertiesPredicate> properties, Optional<NbtPredicate> nbt, DataComponentMatchers components) {
    public static final Codec<BlockPredicate> CODEC = RecordCodecBuilder.create(p_411010_ -> p_411010_.group((App)RegistryCodecs.homogeneousList(Registries.BLOCK).optionalFieldOf("blocks").forGetter(BlockPredicate::blocks), (App)StatePropertiesPredicate.CODEC.optionalFieldOf("state").forGetter(BlockPredicate::properties), (App)NbtPredicate.CODEC.optionalFieldOf("nbt").forGetter(BlockPredicate::nbt), (App)DataComponentMatchers.CODEC.forGetter(BlockPredicate::components)).apply((Applicative)p_411010_, BlockPredicate::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockPredicate> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.optional(ByteBufCodecs.holderSet(Registries.BLOCK)), BlockPredicate::blocks, ByteBufCodecs.optional(StatePropertiesPredicate.STREAM_CODEC), BlockPredicate::properties, ByteBufCodecs.optional(NbtPredicate.STREAM_CODEC), BlockPredicate::nbt, DataComponentMatchers.STREAM_CODEC, BlockPredicate::components, BlockPredicate::new);

    public boolean matches(ServerLevel p_17915_, BlockPos p_17916_) {
        if (!p_17915_.isLoaded(p_17916_)) {
            return false;
        }
        if (!this.matchesState(p_17915_.getBlockState(p_17916_))) {
            return false;
        }
        if (this.nbt.isPresent() || !this.components.isEmpty()) {
            BlockEntity blockentity = p_17915_.getBlockEntity(p_17916_);
            if (this.nbt.isPresent() && !BlockPredicate.matchesBlockEntity(p_17915_, blockentity, this.nbt.get())) {
                return false;
            }
            if (!this.components.isEmpty() && !BlockPredicate.matchesComponents(blockentity, this.components)) {
                return false;
            }
        }
        return true;
    }

    public boolean matches(BlockInWorld p_330448_) {
        return !this.matchesState(p_330448_.getState()) ? false : !this.nbt.isPresent() || BlockPredicate.matchesBlockEntity(p_330448_.getLevel(), p_330448_.getEntity(), this.nbt.get());
    }

    private boolean matchesState(BlockState p_330349_) {
        return this.blocks.isPresent() && !p_330349_.is(this.blocks.get()) ? false : !this.properties.isPresent() || this.properties.get().matches(p_330349_);
    }

    private static boolean matchesBlockEntity(LevelReader p_330457_, @Nullable BlockEntity p_332206_, NbtPredicate p_330422_) {
        return p_332206_ != null && p_330422_.matches(p_332206_.saveWithFullMetadata(p_330457_.registryAccess()));
    }

    private static boolean matchesComponents(@Nullable BlockEntity p_411090_, DataComponentMatchers p_411045_) {
        return p_411090_ != null && p_411045_.test(p_411090_.collectComponents());
    }

    public boolean requiresNbt() {
        return this.nbt.isPresent();
    }

    public static class Builder {
        private Optional<HolderSet<Block>> blocks = Optional.empty();
        private Optional<StatePropertiesPredicate> properties = Optional.empty();
        private Optional<NbtPredicate> nbt = Optional.empty();
        private DataComponentMatchers components = DataComponentMatchers.ANY;

        private Builder() {
        }

        public static Builder block() {
            return new Builder();
        }

        public Builder of(HolderGetter<Block> p_364338_, Block ... p_361195_) {
            return this.of(p_364338_, Arrays.asList(p_361195_));
        }

        public Builder of(HolderGetter<Block> p_360508_, Collection<Block> p_298407_) {
            this.blocks = Optional.of(HolderSet.direct(Block::builtInRegistryHolder, p_298407_));
            return this;
        }

        public Builder of(HolderGetter<Block> p_365447_, TagKey<Block> p_364218_) {
            this.blocks = Optional.of(p_365447_.getOrThrow(p_364218_));
            return this;
        }

        public Builder hasNbt(CompoundTag p_146725_) {
            this.nbt = Optional.of(new NbtPredicate(p_146725_));
            return this;
        }

        public Builder setProperties(StatePropertiesPredicate.Builder p_298989_) {
            this.properties = p_298989_.build();
            return this;
        }

        public Builder components(DataComponentMatchers p_411103_) {
            this.components = p_411103_;
            return this;
        }

        public BlockPredicate build() {
            return new BlockPredicate(this.blocks, this.properties, this.nbt, this.components);
        }
    }
}

