/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ExtraCodecs;

public class AdvancementProgress
implements Comparable<AdvancementProgress> {
    private static final DateTimeFormatter OBTAINED_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT);
    private static final Codec<Instant> OBTAINED_TIME_CODEC = ExtraCodecs.temporalCodec(OBTAINED_TIME_FORMAT).xmap(Instant::from, p_300659_ -> p_300659_.atZone(ZoneId.systemDefault()));
    private static final Codec<Map<String, CriterionProgress>> CRITERIA_CODEC = Codec.unboundedMap((Codec)Codec.STRING, OBTAINED_TIME_CODEC).xmap(p_392483_ -> Util.mapValues(p_392483_, CriterionProgress::new), p_300663_ -> p_300663_.entrySet().stream().filter(p_300656_ -> ((CriterionProgress)p_300656_.getValue()).isDone()).collect(Collectors.toMap(Map.Entry::getKey, p_300655_ -> Objects.requireNonNull(((CriterionProgress)p_300655_.getValue()).getObtained()))));
    public static final Codec<AdvancementProgress> CODEC = RecordCodecBuilder.create(p_337335_ -> p_337335_.group((App)CRITERIA_CODEC.optionalFieldOf("criteria", Map.of()).forGetter(p_300662_ -> p_300662_.criteria), (App)Codec.BOOL.fieldOf("done").orElse((Object)true).forGetter(AdvancementProgress::isDone)).apply((Applicative)p_337335_, (p_300657_, p_300658_) -> new AdvancementProgress(new HashMap<String, CriterionProgress>((Map<String, CriterionProgress>)p_300657_))));
    private final Map<String, CriterionProgress> criteria;
    private AdvancementRequirements requirements = AdvancementRequirements.EMPTY;

    private AdvancementProgress(Map<String, CriterionProgress> p_144358_) {
        this.criteria = p_144358_;
    }

    public AdvancementProgress() {
        this.criteria = Maps.newHashMap();
    }

    public void update(AdvancementRequirements p_301278_) {
        Set<String> set = p_301278_.names();
        this.criteria.entrySet().removeIf(p_8203_ -> !set.contains(p_8203_.getKey()));
        for (String s : set) {
            this.criteria.putIfAbsent(s, new CriterionProgress());
        }
        this.requirements = p_301278_;
    }

    public boolean isDone() {
        return this.requirements.test(this::isCriterionDone);
    }

    public boolean hasProgress() {
        for (CriterionProgress criterionprogress : this.criteria.values()) {
            if (!criterionprogress.isDone()) continue;
            return true;
        }
        return false;
    }

    public boolean grantProgress(String p_8197_) {
        CriterionProgress criterionprogress = this.criteria.get(p_8197_);
        if (criterionprogress != null && !criterionprogress.isDone()) {
            criterionprogress.grant();
            return true;
        }
        return false;
    }

    public boolean revokeProgress(String p_8210_) {
        CriterionProgress criterionprogress = this.criteria.get(p_8210_);
        if (criterionprogress != null && criterionprogress.isDone()) {
            criterionprogress.revoke();
            return true;
        }
        return false;
    }

    public String toString() {
        return "AdvancementProgress{criteria=" + String.valueOf(this.criteria) + ", requirements=" + String.valueOf(this.requirements) + "}";
    }

    public void serializeToNetwork(FriendlyByteBuf p_8205_) {
        p_8205_.writeMap(this.criteria, FriendlyByteBuf::writeUtf, (p_144360_, p_144361_) -> p_144361_.serializeToNetwork((FriendlyByteBuf)((Object)p_144360_)));
    }

    public static AdvancementProgress fromNetwork(FriendlyByteBuf p_8212_) {
        Map<String, CriterionProgress> map = p_8212_.readMap(FriendlyByteBuf::readUtf, CriterionProgress::fromNetwork);
        return new AdvancementProgress(map);
    }

    @Nullable
    public CriterionProgress getCriterion(String p_8215_) {
        return this.criteria.get(p_8215_);
    }

    private boolean isCriterionDone(String p_300915_) {
        CriterionProgress criterionprogress = this.getCriterion(p_300915_);
        return criterionprogress != null && criterionprogress.isDone();
    }

    public float getPercent() {
        if (this.criteria.isEmpty()) {
            return 0.0f;
        }
        float f = this.requirements.size();
        float f1 = this.countCompletedRequirements();
        return f1 / f;
    }

    @Nullable
    public Component getProgressText() {
        if (this.criteria.isEmpty()) {
            return null;
        }
        int i = this.requirements.size();
        if (i <= 1) {
            return null;
        }
        int j = this.countCompletedRequirements();
        return Component.translatable("advancements.progress", j, i);
    }

    private int countCompletedRequirements() {
        return this.requirements.count(this::isCriterionDone);
    }

    public Iterable<String> getRemainingCriteria() {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<String, CriterionProgress> entry : this.criteria.entrySet()) {
            if (entry.getValue().isDone()) continue;
            list.add(entry.getKey());
        }
        return list;
    }

    public Iterable<String> getCompletedCriteria() {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<String, CriterionProgress> entry : this.criteria.entrySet()) {
            if (!entry.getValue().isDone()) continue;
            list.add(entry.getKey());
        }
        return list;
    }

    @Nullable
    public Instant getFirstProgressDate() {
        return this.criteria.values().stream().map(CriterionProgress::getObtained).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(null);
    }

    @Override
    public int compareTo(AdvancementProgress p_8195_) {
        Instant instant = this.getFirstProgressDate();
        Instant instant1 = p_8195_.getFirstProgressDate();
        if (instant == null && instant1 != null) {
            return 1;
        }
        if (instant != null && instant1 == null) {
            return -1;
        }
        return instant == null && instant1 == null ? 0 : instant.compareTo(instant1);
    }
}

