/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;

public class AdvancementNode {
    private final AdvancementHolder holder;
    @Nullable
    private final AdvancementNode parent;
    private final Set<AdvancementNode> children = new ReferenceOpenHashSet();

    @VisibleForTesting
    public AdvancementNode(AdvancementHolder p_301037_, @Nullable AdvancementNode p_301236_) {
        this.holder = p_301037_;
        this.parent = p_301236_;
    }

    public Advancement advancement() {
        return this.holder.value();
    }

    public AdvancementHolder holder() {
        return this.holder;
    }

    @Nullable
    public AdvancementNode parent() {
        return this.parent;
    }

    public AdvancementNode root() {
        return AdvancementNode.getRoot(this);
    }

    public static AdvancementNode getRoot(AdvancementNode p_300869_) {
        AdvancementNode advancementnode = p_300869_;
        AdvancementNode advancementnode1;
        while ((advancementnode1 = advancementnode.parent()) != null) {
            advancementnode = advancementnode1;
        }
        return advancementnode;
    }

    public Iterable<AdvancementNode> children() {
        return this.children;
    }

    @VisibleForTesting
    public void addChild(AdvancementNode p_301119_) {
        this.children.add(p_301119_);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object p_300876_) {
        if (this == p_300876_) {
            return true;
        }
        if (!(p_300876_ instanceof AdvancementNode)) return false;
        AdvancementNode advancementnode = (AdvancementNode)p_300876_;
        if (!this.holder.equals(advancementnode.holder)) return false;
        return true;
    }

    public int hashCode() {
        return this.holder.hashCode();
    }

    public String toString() {
        return this.holder.id().toString();
    }
}

