/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.UUID;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.DataVersion;
import org.slf4j.Logger;

public class DetectedVersion {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final WorldVersion BUILT_IN = DetectedVersion.createFromConstants();

    private static WorldVersion createFromConstants() {
        return new WorldVersion.Simple(UUID.randomUUID().toString().replaceAll("-", ""), "1.21.8", new DataVersion(4440, "main"), SharedConstants.getProtocolVersion(), 64, 81, new Date(), true);
    }

    private static WorldVersion createFromJson(JsonObject p_415640_) {
        JsonObject jsonobject = GsonHelper.getAsJsonObject(p_415640_, "pack_version");
        return new WorldVersion.Simple(GsonHelper.getAsString(p_415640_, "id"), GsonHelper.getAsString(p_415640_, "name"), new DataVersion(GsonHelper.getAsInt(p_415640_, "world_version"), GsonHelper.getAsString(p_415640_, "series_id", "main")), GsonHelper.getAsInt(p_415640_, "protocol_version"), GsonHelper.getAsInt(jsonobject, "resource"), GsonHelper.getAsInt(jsonobject, "data"), Date.from(ZonedDateTime.parse(GsonHelper.getAsString(p_415640_, "build_time")).toInstant()), GsonHelper.getAsBoolean(p_415640_, "stable"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WorldVersion tryDetectVersion() {
        try (InputStream inputstream = DetectedVersion.class.getResourceAsStream("/version.json");){
            if (inputstream == null) {
                LOGGER.warn("Missing version information!");
                WorldVersion worldVersion = BUILT_IN;
                return worldVersion;
            }
            try (InputStreamReader inputstreamreader = new InputStreamReader(inputstream);){
                WorldVersion worldversion = DetectedVersion.createFromJson(GsonHelper.parse(inputstreamreader));
                return worldversion;
            }
        }
        catch (JsonParseException | IOException ioexception) {
            throw new IllegalStateException("Game version information is corrupt", ioexception);
        }
    }
}

