/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockUtil {
    public static FoundRectangle getLargestRectangleAround(BlockPos p_124335_, Direction.Axis p_124336_, int p_124337_, Direction.Axis p_124338_, int p_124339_, Predicate<BlockPos> p_124340_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_124335_.mutable();
        Direction direction = Direction.get(Direction.AxisDirection.NEGATIVE, p_124336_);
        Direction direction1 = direction.getOpposite();
        Direction direction2 = Direction.get(Direction.AxisDirection.NEGATIVE, p_124338_);
        Direction direction3 = direction2.getOpposite();
        int i = BlockUtil.getLimit(p_124340_, blockpos$mutableblockpos.set(p_124335_), direction, p_124337_);
        int j = BlockUtil.getLimit(p_124340_, blockpos$mutableblockpos.set(p_124335_), direction1, p_124337_);
        int k = i;
        IntBounds[] ablockutil$intbounds = new IntBounds[i + 1 + j];
        ablockutil$intbounds[i] = new IntBounds(BlockUtil.getLimit(p_124340_, blockpos$mutableblockpos.set(p_124335_), direction2, p_124339_), BlockUtil.getLimit(p_124340_, blockpos$mutableblockpos.set(p_124335_), direction3, p_124339_));
        int l = ablockutil$intbounds[i].min;
        for (int i1 = 1; i1 <= i; ++i1) {
            IntBounds blockutil$intbounds = ablockutil$intbounds[k - (i1 - 1)];
            ablockutil$intbounds[k - i1] = new IntBounds(BlockUtil.getLimit(p_124340_, blockpos$mutableblockpos.set(p_124335_).move(direction, i1), direction2, blockutil$intbounds.min), BlockUtil.getLimit(p_124340_, blockpos$mutableblockpos.set(p_124335_).move(direction, i1), direction3, blockutil$intbounds.max));
        }
        for (int l2 = 1; l2 <= j; ++l2) {
            IntBounds blockutil$intbounds2 = ablockutil$intbounds[k + l2 - 1];
            ablockutil$intbounds[k + l2] = new IntBounds(BlockUtil.getLimit(p_124340_, blockpos$mutableblockpos.set(p_124335_).move(direction1, l2), direction2, blockutil$intbounds2.min), BlockUtil.getLimit(p_124340_, blockpos$mutableblockpos.set(p_124335_).move(direction1, l2), direction3, blockutil$intbounds2.max));
        }
        int i3 = 0;
        int j3 = 0;
        int j1 = 0;
        int k1 = 0;
        int[] aint = new int[ablockutil$intbounds.length];
        for (int l1 = l; l1 >= 0; --l1) {
            for (int i2 = 0; i2 < ablockutil$intbounds.length; ++i2) {
                IntBounds blockutil$intbounds1 = ablockutil$intbounds[i2];
                int j2 = l - blockutil$intbounds1.min;
                int k2 = l + blockutil$intbounds1.max;
                aint[i2] = l1 >= j2 && l1 <= k2 ? k2 + 1 - l1 : 0;
            }
            Pair<IntBounds, Integer> pair = BlockUtil.getMaxRectangleLocation(aint);
            IntBounds blockutil$intbounds3 = (IntBounds)pair.getFirst();
            int k3 = 1 + blockutil$intbounds3.max - blockutil$intbounds3.min;
            int l3 = (Integer)pair.getSecond();
            if (k3 * l3 <= j1 * k1) continue;
            i3 = blockutil$intbounds3.min;
            j3 = l1;
            j1 = k3;
            k1 = l3;
        }
        return new FoundRectangle(p_124335_.relative(p_124336_, i3 - k).relative(p_124338_, j3 - l), j1, k1);
    }

    private static int getLimit(Predicate<BlockPos> p_124342_, BlockPos.MutableBlockPos p_124343_, Direction p_124344_, int p_124345_) {
        int i;
        for (i = 0; i < p_124345_ && p_124342_.test(p_124343_.move(p_124344_)); ++i) {
        }
        return i;
    }

    @VisibleForTesting
    static Pair<IntBounds, Integer> getMaxRectangleLocation(int[] p_124347_) {
        int i = 0;
        int j = 0;
        int k = 0;
        IntArrayList intstack = new IntArrayList();
        intstack.push(0);
        for (int l = 1; l <= p_124347_.length; ++l) {
            int i1;
            int n = i1 = l == p_124347_.length ? 0 : p_124347_[l];
            while (!intstack.isEmpty()) {
                int j1 = p_124347_[intstack.topInt()];
                if (i1 >= j1) {
                    intstack.push(l);
                    break;
                }
                intstack.popInt();
                int k1 = intstack.isEmpty() ? 0 : intstack.topInt() + 1;
                if (j1 * (l - k1) <= k * (j - i)) continue;
                j = l;
                i = k1;
                k = j1;
            }
            if (!intstack.isEmpty()) continue;
            intstack.push(l);
        }
        return new Pair((Object)new IntBounds(i, j - 1), (Object)k);
    }

    public static Optional<BlockPos> getTopConnectedBlock(BlockGetter p_177846_, BlockPos p_177847_, Block p_177848_, Direction p_177849_, Block p_177850_) {
        BlockState blockstate;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_177847_.mutable();
        do {
            blockpos$mutableblockpos.move(p_177849_);
        } while ((blockstate = p_177846_.getBlockState(blockpos$mutableblockpos)).is(p_177848_));
        return blockstate.is(p_177850_) ? Optional.of(blockpos$mutableblockpos) : Optional.empty();
    }

    public static class IntBounds {
        public final int min;
        public final int max;

        public IntBounds(int p_124358_, int p_124359_) {
            this.min = p_124358_;
            this.max = p_124359_;
        }

        public String toString() {
            return "IntBounds{min=" + this.min + ", max=" + this.max + "}";
        }
    }

    public static class FoundRectangle {
        public final BlockPos minCorner;
        public final int axis1Size;
        public final int axis2Size;

        public FoundRectangle(BlockPos p_124352_, int p_124353_, int p_124354_) {
            this.minCorner = p_124352_;
            this.axis1Size = p_124353_;
            this.axis2Size = p_124354_;
        }
    }
}

