/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.util;

import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.exception.RealmsServiceException;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class RealmsUtil {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Component RIGHT_NOW = Component.translatable("mco.util.time.now");
    private static final int MINUTES = 60;
    private static final int HOURS = 3600;
    private static final int DAYS = 86400;

    public static Component convertToAgePresentation(long p_287679_) {
        if (p_287679_ < 0L) {
            return RIGHT_NOW;
        }
        long i = p_287679_ / 1000L;
        if (i < 60L) {
            return Component.translatable("mco.time.secondsAgo", i);
        }
        if (i < 3600L) {
            long l = i / 60L;
            return Component.translatable("mco.time.minutesAgo", l);
        }
        if (i < 86400L) {
            long k = i / 3600L;
            return Component.translatable("mco.time.hoursAgo", k);
        }
        long j = i / 86400L;
        return Component.translatable("mco.time.daysAgo", j);
    }

    public static Component convertToAgePresentationFromInstant(Date p_287698_) {
        return RealmsUtil.convertToAgePresentation(System.currentTimeMillis() - p_287698_.getTime());
    }

    public static void renderPlayerFace(GuiGraphics p_281255_, int p_281818_, int p_281791_, int p_282088_, UUID p_294599_) {
        Minecraft minecraft = Minecraft.getInstance();
        ProfileResult profileresult = minecraft.getMinecraftSessionService().fetchProfile(p_294599_, false);
        PlayerSkin playerskin = profileresult != null ? minecraft.getSkinManager().getInsecureSkin(profileresult.profile()) : DefaultPlayerSkin.get(p_294599_);
        PlayerFaceRenderer.draw(p_281255_, playerskin, p_281818_, p_281791_, p_282088_);
    }

    public static <T> CompletableFuture<T> supplyAsync(RealmsIoFunction<T> p_428701_, @Nullable Consumer<RealmsServiceException> p_428719_) {
        return CompletableFuture.supplyAsync(() -> {
            RealmsClient realmsclient = RealmsClient.getOrCreate();
            try {
                return p_428701_.apply(realmsclient);
            }
            catch (Throwable throwable) {
                if (throwable instanceof RealmsServiceException) {
                    RealmsServiceException realmsserviceexception = (RealmsServiceException)throwable;
                    if (p_428719_ != null) {
                        p_428719_.accept(realmsserviceexception);
                    }
                } else {
                    LOGGER.error("Unhandled exception", throwable);
                }
                throw new RuntimeException(throwable);
            }
        }, Util.nonCriticalIoPool());
    }

    public static CompletableFuture<Void> runAsync(RealmsIoConsumer p_428705_, @Nullable Consumer<RealmsServiceException> p_428685_) {
        return RealmsUtil.supplyAsync(p_428705_, p_428685_);
    }

    public static Consumer<RealmsServiceException> openScreenOnFailure(Function<RealmsServiceException, Screen> p_428692_) {
        Minecraft minecraft = Minecraft.getInstance();
        return p_428731_ -> minecraft.execute(() -> minecraft.setScreen((Screen)p_428692_.apply((RealmsServiceException)p_428731_)));
    }

    public static Consumer<RealmsServiceException> openScreenAndLogOnFailure(Function<RealmsServiceException, Screen> p_428683_, String p_428704_) {
        return RealmsUtil.openScreenOnFailure(p_428683_).andThen(p_428690_ -> LOGGER.error(p_428704_, (Throwable)p_428690_));
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface RealmsIoFunction<T> {
        public T apply(RealmsClient var1) throws RealmsServiceException;
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface RealmsIoConsumer
    extends RealmsIoFunction<Void> {
        public void accept(RealmsClient var1) throws RealmsServiceException;

        @Override
        default public Void apply(RealmsClient p_428718_) throws RealmsServiceException {
            this.accept(p_428718_);
            return null;
        }
    }
}

