/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.util;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class RealmsTextureManager {
    private static final Map<String, RealmsTexture> TEXTURES = Maps.newHashMap();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation TEMPLATE_ICON_LOCATION = ResourceLocation.withDefaultNamespace("textures/gui/presets/isles.png");

    public static ResourceLocation worldTemplate(String p_270945_, @Nullable String p_270612_) {
        return p_270612_ == null ? TEMPLATE_ICON_LOCATION : RealmsTextureManager.getTexture(p_270945_, p_270612_);
    }

    private static ResourceLocation getTexture(String p_90197_, String p_90198_) {
        RealmsTexture realmstexturemanager$realmstexture = TEXTURES.get(p_90197_);
        if (realmstexturemanager$realmstexture != null && realmstexturemanager$realmstexture.image().equals(p_90198_)) {
            return realmstexturemanager$realmstexture.textureId;
        }
        NativeImage nativeimage = RealmsTextureManager.loadImage(p_90198_);
        if (nativeimage == null) {
            ResourceLocation resourcelocation1 = MissingTextureAtlasSprite.getLocation();
            TEXTURES.put(p_90197_, new RealmsTexture(p_90198_, resourcelocation1));
            return resourcelocation1;
        }
        ResourceLocation resourcelocation = ResourceLocation.fromNamespaceAndPath("realms", "dynamic/" + p_90197_);
        Minecraft.getInstance().getTextureManager().register(resourcelocation, new DynamicTexture(resourcelocation::toString, nativeimage));
        TEXTURES.put(p_90197_, new RealmsTexture(p_90198_, resourcelocation));
        return resourcelocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static NativeImage loadImage(String p_270725_) {
        byte[] abyte = Base64.getDecoder().decode(p_270725_);
        ByteBuffer bytebuffer = MemoryUtil.memAlloc((int)abyte.length);
        try {
            NativeImage nativeImage = NativeImage.read(bytebuffer.put(abyte).flip());
            return nativeImage;
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to load world image: {}", (Object)p_270725_, (Object)ioexception);
        }
        finally {
            MemoryUtil.memFree((Buffer)bytebuffer);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public record RealmsTexture(String image, ResourceLocation textureId) {
    }
}

