/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens.configuration;

import com.google.common.collect.Lists;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.WorldTemplate;
import com.mojang.realmsclient.gui.RealmsWorldSlotButton;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.gui.screens.RealmsPopups;
import com.mojang.realmsclient.gui.screens.RealmsResetWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsSelectWorldTemplateScreen;
import com.mojang.realmsclient.gui.screens.configuration.RealmsBackupScreen;
import com.mojang.realmsclient.gui.screens.configuration.RealmsConfigurationTab;
import com.mojang.realmsclient.gui.screens.configuration.RealmsConfigureWorldScreen;
import com.mojang.realmsclient.gui.screens.configuration.RealmsSlotOptionsScreen;
import com.mojang.realmsclient.util.task.SwitchMinigameTask;
import com.mojang.realmsclient.util.task.SwitchSlotTask;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.tabs.GridLayoutTab;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
class RealmsWorldsTab
extends GridLayoutTab
implements RealmsConfigurationTab {
    static final Component TITLE = Component.translatable("mco.configure.worlds.title");
    private final RealmsConfigureWorldScreen configurationScreen;
    private final Minecraft minecraft;
    private RealmsServer serverData;
    private final Button optionsButton;
    private final Button backupButton;
    private final Button resetWorldButton;
    private final List<RealmsWorldSlotButton> slotButtonList = Lists.newArrayList();

    RealmsWorldsTab(RealmsConfigureWorldScreen p_419690_, Minecraft p_419536_, RealmsServer p_419476_) {
        super(TITLE);
        this.configurationScreen = p_419690_;
        this.minecraft = p_419536_;
        this.serverData = p_419476_;
        GridLayout.RowHelper gridlayout$rowhelper = this.layout.spacing(20).createRowHelper(1);
        GridLayout.RowHelper gridlayout$rowhelper1 = new GridLayout().spacing(16).createRowHelper(4);
        this.slotButtonList.clear();
        for (int i = 1; i < 5; ++i) {
            this.slotButtonList.add(gridlayout$rowhelper1.addChild(this.createSlotButton(i), LayoutSettings.defaults().alignVerticallyBottom()));
        }
        gridlayout$rowhelper.addChild(gridlayout$rowhelper1.getGrid());
        GridLayout.RowHelper gridlayout$rowhelper2 = new GridLayout().spacing(8).createRowHelper(1);
        this.optionsButton = gridlayout$rowhelper2.addChild(Button.builder(Component.translatable("mco.configure.world.buttons.options"), p_420075_ -> p_419536_.setScreen(new RealmsSlotOptionsScreen(p_419690_, p_419476_.slots.get(p_419476_.activeSlot).clone(), p_419476_.worldType, p_419476_.activeSlot))).bounds(0, 0, 150, 20).build());
        this.backupButton = gridlayout$rowhelper2.addChild(Button.builder(Component.translatable("mco.configure.world.backup"), p_419786_ -> p_419536_.setScreen(new RealmsBackupScreen(p_419690_, p_419476_.clone(), p_419476_.activeSlot))).bounds(0, 0, 150, 20).build());
        this.resetWorldButton = gridlayout$rowhelper2.addChild(Button.builder(Component.empty(), p_419578_ -> this.resetButtonPressed()).bounds(0, 0, 150, 20).build());
        gridlayout$rowhelper.addChild(gridlayout$rowhelper2.getGrid(), LayoutSettings.defaults().alignHorizontallyCenter());
        this.backupButton.active = true;
        this.updateData(p_419476_);
    }

    private void resetButtonPressed() {
        if (this.isMinigame()) {
            this.minecraft.setScreen(new RealmsSelectWorldTemplateScreen(Component.translatable("mco.template.title.minigame"), this::templateSelectionCallback, RealmsServer.WorldType.MINIGAME));
        } else {
            this.minecraft.setScreen(RealmsResetWorldScreen.forResetSlot(this.configurationScreen, this.serverData.clone(), () -> this.minecraft.execute(() -> this.minecraft.setScreen(this.configurationScreen.getNewScreen()))));
        }
    }

    private void templateSelectionCallback(@Nullable WorldTemplate p_419847_) {
        if (p_419847_ != null && WorldTemplate.WorldTemplateType.MINIGAME == p_419847_.type) {
            this.configurationScreen.stateChanged();
            RealmsConfigureWorldScreen realmsconfigureworldscreen = this.configurationScreen.getNewScreen();
            this.minecraft.setScreen(new RealmsLongRunningMcoTaskScreen(realmsconfigureworldscreen, new SwitchMinigameTask(this.serverData.id, p_419847_, realmsconfigureworldscreen)));
        } else {
            this.minecraft.setScreen(this.configurationScreen);
        }
    }

    private boolean isMinigame() {
        return this.serverData.isMinigameActive();
    }

    @Override
    public void onSelected(RealmsServer p_420061_) {
        this.updateData(p_420061_);
    }

    @Override
    public void updateData(RealmsServer p_419949_) {
        this.serverData = p_419949_;
        this.optionsButton.active = !p_419949_.expired && !this.isMinigame();
        boolean bl = this.resetWorldButton.active = !p_419949_.expired;
        if (this.isMinigame()) {
            this.resetWorldButton.setMessage(Component.translatable("mco.configure.world.buttons.switchminigame"));
        } else {
            boolean flag;
            boolean bl2 = flag = p_419949_.slots.containsKey(p_419949_.activeSlot) && p_419949_.slots.get((Object)Integer.valueOf((int)p_419949_.activeSlot)).options.empty;
            if (flag) {
                this.resetWorldButton.setMessage(Component.translatable("mco.configure.world.buttons.newworld"));
            } else {
                this.resetWorldButton.setMessage(Component.translatable("mco.configure.world.buttons.resetworld"));
            }
        }
        this.backupButton.active = !this.isMinigame();
        for (RealmsWorldSlotButton realmsworldslotbutton : this.slotButtonList) {
            RealmsWorldSlotButton.State realmsworldslotbutton$state = realmsworldslotbutton.setServerData(p_419949_);
            if (realmsworldslotbutton$state.activeSlot) {
                realmsworldslotbutton.setSize(80, 80);
                continue;
            }
            realmsworldslotbutton.setSize(50, 50);
        }
    }

    private RealmsWorldSlotButton createSlotButton(int p_419555_) {
        return new RealmsWorldSlotButton(0, 0, 80, 80, p_419555_, this.serverData, arg_0 -> this.lambda$createSlotButton$5(p_419555_, arg_0));
    }

    private void switchToMinigame() {
        RealmsSelectWorldTemplateScreen realmsselectworldtemplatescreen = new RealmsSelectWorldTemplateScreen(Component.translatable("mco.template.title.minigame"), this::templateSelectionCallback, RealmsServer.WorldType.MINIGAME);
        realmsselectworldtemplatescreen.setWarning(Component.translatable("mco.minigame.world.info.line1"), Component.translatable("mco.minigame.world.info.line2"));
        this.minecraft.setScreen(realmsselectworldtemplatescreen);
    }

    private void switchToFullSlot(int p_420013_, RealmsServer p_419511_) {
        this.minecraft.setScreen(RealmsPopups.infoPopupScreen(this.configurationScreen, Component.translatable("mco.configure.world.slot.switch.question.line1"), p_428669_ -> {
            RealmsConfigureWorldScreen realmsconfigureworldscreen = this.configurationScreen.getNewScreen();
            this.configurationScreen.stateChanged();
            this.minecraft.setScreen(new RealmsLongRunningMcoTaskScreen(realmsconfigureworldscreen, new SwitchSlotTask(p_419511_.id, p_420013_, () -> this.minecraft.execute(() -> this.minecraft.setScreen(realmsconfigureworldscreen)))));
        }));
    }

    private void switchToEmptySlot(int p_419735_, RealmsServer p_419505_) {
        this.minecraft.setScreen(RealmsPopups.infoPopupScreen(this.configurationScreen, Component.translatable("mco.configure.world.slot.switch.question.line1"), p_419876_ -> {
            this.configurationScreen.stateChanged();
            RealmsResetWorldScreen realmsresetworldscreen = RealmsResetWorldScreen.forEmptySlot(this.configurationScreen, p_419735_, p_419505_, () -> this.minecraft.execute(() -> this.minecraft.setScreen(this.configurationScreen.getNewScreen())));
            this.minecraft.setScreen(realmsresetworldscreen);
        }));
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$createSlotButton$5(int p_419555_, Button p_419905_) {
        realmsworldslotbutton$state = ((RealmsWorldSlotButton)p_419905_).getState();
        switch (1.$SwitchMap$com$mojang$realmsclient$gui$RealmsWorldSlotButton$Action[realmsworldslotbutton$state.action.ordinal()]) {
            case 1: {
                if (!realmsworldslotbutton$state.minigame) ** GOTO lbl7
                this.switchToMinigame();
                ** GOTO lbl11
lbl7:
                // 1 sources

                if (realmsworldslotbutton$state.empty) {
                    this.switchToEmptySlot(p_419555_, this.serverData);
                } else {
                    this.switchToFullSlot(p_419555_, this.serverData);
                }
            }
lbl11:
            // 4 sources

            case 2: {
                return;
            }
        }
        throw new IllegalStateException("Unknown action " + String.valueOf((Object)realmsworldslotbutton$state.action));
    }
}

