/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens.configuration;

import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.Subscription;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.screens.RealmsPopups;
import com.mojang.realmsclient.gui.screens.configuration.RealmsConfigurationTab;
import com.mojang.realmsclient.gui.screens.configuration.RealmsConfigureWorldScreen;
import com.mojang.realmsclient.util.RealmsUtil;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.FocusableTextWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.tabs.GridLayoutTab;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.CommonLinks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
class RealmsSubscriptionTab
extends GridLayoutTab
implements RealmsConfigurationTab {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int DEFAULT_COMPONENT_WIDTH = 200;
    private static final int EXTRA_SPACING = 2;
    private static final int DEFAULT_SPACING = 6;
    static final Component TITLE = Component.translatable("mco.configure.world.subscription.tab");
    private static final Component SUBSCRIPTION_START_LABEL = Component.translatable("mco.configure.world.subscription.start");
    private static final Component TIME_LEFT_LABEL = Component.translatable("mco.configure.world.subscription.timeleft");
    private static final Component DAYS_LEFT_LABEL = Component.translatable("mco.configure.world.subscription.recurring.daysleft");
    private static final Component SUBSCRIPTION_EXPIRED_TEXT = Component.translatable("mco.configure.world.subscription.expired").withStyle(ChatFormatting.GRAY);
    private static final Component SUBSCRIPTION_LESS_THAN_A_DAY_TEXT = Component.translatable("mco.configure.world.subscription.less_than_a_day").withStyle(ChatFormatting.GRAY);
    private static final Component UNKNOWN = Component.translatable("mco.configure.world.subscription.unknown");
    private static final Component RECURRING_INFO = Component.translatable("mco.configure.world.subscription.recurring.info");
    private final RealmsConfigureWorldScreen configurationScreen;
    private final Minecraft minecraft;
    private final Button deleteButton;
    private final FocusableTextWidget subscriptionInfo;
    private final StringWidget startDateWidget;
    private final StringWidget daysLeftLabelWidget;
    private final StringWidget daysLeftWidget;
    private RealmsServer serverData;
    private Component daysLeft = UNKNOWN;
    private Component startDate = UNKNOWN;
    @Nullable
    private Subscription.SubscriptionType type;

    RealmsSubscriptionTab(RealmsConfigureWorldScreen p_419628_, Minecraft p_419766_, RealmsServer p_419700_) {
        super(TITLE);
        this.configurationScreen = p_419628_;
        this.minecraft = p_419766_;
        this.serverData = p_419700_;
        GridLayout.RowHelper gridlayout$rowhelper = this.layout.rowSpacing(6).createRowHelper(1);
        Font font = p_419628_.getFont();
        gridlayout$rowhelper.addChild(new StringWidget(200, 9, SUBSCRIPTION_START_LABEL, font).alignLeft());
        this.startDateWidget = gridlayout$rowhelper.addChild(new StringWidget(200, 9, this.startDate, font).alignLeft());
        gridlayout$rowhelper.addChild(SpacerElement.height(2));
        this.daysLeftLabelWidget = gridlayout$rowhelper.addChild(new StringWidget(200, 9, TIME_LEFT_LABEL, font).alignLeft());
        this.daysLeftWidget = gridlayout$rowhelper.addChild(new StringWidget(200, 9, this.daysLeft, font).alignLeft());
        gridlayout$rowhelper.addChild(SpacerElement.height(2));
        gridlayout$rowhelper.addChild(Button.builder(Component.translatable("mco.configure.world.subscription.extend"), p_419781_ -> ConfirmLinkScreen.confirmLinkNow((Screen)p_419628_, CommonLinks.extendRealms(p_419700_.remoteSubscriptionId, p_419766_.getUser().getProfileId()))).bounds(0, 0, 200, 20).build());
        gridlayout$rowhelper.addChild(SpacerElement.height(2));
        this.deleteButton = gridlayout$rowhelper.addChild(Button.builder(Component.translatable("mco.configure.world.delete.button"), p_420051_ -> p_419766_.setScreen(RealmsPopups.warningPopupScreen(p_419628_, Component.translatable("mco.configure.world.delete.question.line1"), p_419742_ -> this.deleteRealm()))).bounds(0, 0, 200, 20).build());
        gridlayout$rowhelper.addChild(SpacerElement.height(2));
        this.subscriptionInfo = gridlayout$rowhelper.addChild(new FocusableTextWidget(200, Component.empty(), font, true, true, 4), LayoutSettings.defaults().alignHorizontallyCenter());
        this.subscriptionInfo.setMaxWidth(200);
        this.subscriptionInfo.setCentered(false);
        this.updateData(p_419700_);
    }

    private void deleteRealm() {
        RealmsUtil.runAsync(p_428664_ -> p_428664_.deleteRealm(this.serverData.id), RealmsUtil.openScreenAndLogOnFailure(this.configurationScreen::createErrorScreen, "Couldn't delete world")).thenRunAsync(() -> this.minecraft.setScreen(this.configurationScreen.getLastScreen()), this.minecraft);
        this.minecraft.setScreen(this.configurationScreen);
    }

    private void getSubscription(long p_419619_) {
        RealmsClient realmsclient = RealmsClient.getOrCreate();
        try {
            Subscription subscription = realmsclient.subscriptionFor(p_419619_);
            this.daysLeft = this.daysLeftPresentation(subscription.daysLeft);
            this.startDate = RealmsSubscriptionTab.localPresentation(subscription.startDate);
            this.type = subscription.type;
        }
        catch (RealmsServiceException realmsserviceexception) {
            LOGGER.error("Couldn't get subscription", (Throwable)realmsserviceexception);
            this.minecraft.setScreen(this.configurationScreen.createErrorScreen(realmsserviceexception));
        }
    }

    private static Component localPresentation(long p_419661_) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault());
        calendar.setTimeInMillis(p_419661_);
        return Component.literal(DateFormat.getDateTimeInstance().format(calendar.getTime())).withStyle(ChatFormatting.GRAY);
    }

    private Component daysLeftPresentation(int p_419931_) {
        boolean flag1;
        if (p_419931_ < 0 && this.serverData.expired) {
            return SUBSCRIPTION_EXPIRED_TEXT;
        }
        if (p_419931_ <= 1) {
            return SUBSCRIPTION_LESS_THAN_A_DAY_TEXT;
        }
        int i = p_419931_ / 30;
        int j = p_419931_ % 30;
        boolean flag = i > 0;
        boolean bl = flag1 = j > 0;
        if (flag && flag1) {
            return Component.translatable("mco.configure.world.subscription.remaining.months.days", i, j).withStyle(ChatFormatting.GRAY);
        }
        if (flag) {
            return Component.translatable("mco.configure.world.subscription.remaining.months", i).withStyle(ChatFormatting.GRAY);
        }
        return flag1 ? Component.translatable("mco.configure.world.subscription.remaining.days", j).withStyle(ChatFormatting.GRAY) : Component.empty();
    }

    @Override
    public void updateData(RealmsServer p_419752_) {
        this.serverData = p_419752_;
        this.getSubscription(p_419752_.id);
        this.startDateWidget.setMessage(this.startDate);
        if (this.type == Subscription.SubscriptionType.NORMAL) {
            this.daysLeftLabelWidget.setMessage(TIME_LEFT_LABEL);
        } else if (this.type == Subscription.SubscriptionType.RECURRING) {
            this.daysLeftLabelWidget.setMessage(DAYS_LEFT_LABEL);
        }
        this.daysLeftWidget.setMessage(this.daysLeft);
        boolean flag = RealmsMainScreen.isSnapshot() && p_419752_.parentWorldName != null;
        this.deleteButton.active = p_419752_.expired;
        if (flag) {
            this.subscriptionInfo.setMessage(Component.translatable("mco.snapshot.subscription.info", p_419752_.parentWorldName));
        } else {
            this.subscriptionInfo.setMessage(RECURRING_INFO);
        }
        this.layout.arrangeElements();
    }

    @Override
    public Component getTabExtraNarration() {
        return CommonComponents.joinLines(TITLE, SUBSCRIPTION_START_LABEL, this.startDate, TIME_LEFT_LABEL, this.daysLeft);
    }
}

