/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens.configuration;

import com.google.common.collect.ImmutableList;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.RealmsSlot;
import com.mojang.realmsclient.dto.RealmsWorldOptions;
import com.mojang.realmsclient.gui.screens.RealmsPopups;
import com.mojang.realmsclient.gui.screens.configuration.RealmsConfigureWorldScreen;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.realms.RealmsLabel;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RealmsSlotOptionsScreen
extends RealmsScreen {
    private static final int DEFAULT_DIFFICULTY = 2;
    public static final List<Difficulty> DIFFICULTIES = ImmutableList.of((Object)Difficulty.PEACEFUL, (Object)Difficulty.EASY, (Object)Difficulty.NORMAL, (Object)Difficulty.HARD);
    private static final int DEFAULT_GAME_MODE = 0;
    public static final List<GameType> GAME_MODES = ImmutableList.of((Object)GameType.SURVIVAL, (Object)GameType.CREATIVE, (Object)GameType.ADVENTURE);
    private static final Component NAME_LABEL = Component.translatable("mco.configure.world.edit.slot.name");
    static final Component SPAWN_PROTECTION_TEXT = Component.translatable("mco.configure.world.spawnProtection");
    private EditBox nameEdit;
    protected final RealmsConfigureWorldScreen parentScreen;
    private int column1X;
    private int columnWidth;
    private final RealmsSlot slot;
    private final RealmsServer.WorldType worldType;
    private Difficulty difficulty;
    private GameType gameMode;
    private final String defaultSlotName;
    private String worldName;
    private boolean pvp;
    private boolean spawnMonsters;
    int spawnProtection;
    private boolean commandBlocks;
    private boolean forceGameMode;
    SettingsSlider spawnProtectionButton;

    public RealmsSlotOptionsScreen(RealmsConfigureWorldScreen p_419736_, RealmsSlot p_419951_, RealmsServer.WorldType p_419756_, int p_419669_) {
        super(Component.translatable("mco.configure.world.buttons.options"));
        this.parentScreen = p_419736_;
        this.slot = p_419951_;
        this.worldType = p_419756_;
        this.difficulty = RealmsSlotOptionsScreen.findByIndex(DIFFICULTIES, p_419951_.options.difficulty, 2);
        this.gameMode = RealmsSlotOptionsScreen.findByIndex(GAME_MODES, p_419951_.options.gameMode, 0);
        this.defaultSlotName = p_419951_.options.getDefaultSlotName(p_419669_);
        this.setWorldName(p_419951_.options.getSlotName(p_419669_));
        if (p_419756_ == RealmsServer.WorldType.NORMAL) {
            this.pvp = p_419951_.options.pvp;
            this.spawnProtection = p_419951_.options.spawnProtection;
            this.forceGameMode = p_419951_.options.forceGameMode;
            this.spawnMonsters = p_419951_.options.spawnMonsters;
            this.commandBlocks = p_419951_.options.commandBlocks;
        } else {
            this.pvp = true;
            this.spawnProtection = 0;
            this.forceGameMode = false;
            this.spawnMonsters = true;
            this.commandBlocks = true;
        }
    }

    @Override
    public void onClose() {
        this.minecraft.setScreen(this.parentScreen);
    }

    private static <T> T findByIndex(List<T> p_419636_, int p_419460_, int p_419568_) {
        try {
            return p_419636_.get(p_419460_);
        }
        catch (IndexOutOfBoundsException indexoutofboundsexception) {
            return p_419636_.get(p_419568_);
        }
    }

    private static <T> int findIndex(List<T> p_419633_, T p_420003_, int p_419563_) {
        int i = p_419633_.indexOf(p_420003_);
        return i == -1 ? p_419563_ : i;
    }

    @Override
    public void init() {
        this.columnWidth = 170;
        this.column1X = this.width / 2 - this.columnWidth;
        int i = this.width / 2 + 10;
        if (this.worldType != RealmsServer.WorldType.NORMAL) {
            MutableComponent component = this.worldType == RealmsServer.WorldType.ADVENTUREMAP ? Component.translatable("mco.configure.world.edit.subscreen.adventuremap") : (this.worldType == RealmsServer.WorldType.INSPIRATION ? Component.translatable("mco.configure.world.edit.subscreen.inspiration") : Component.translatable("mco.configure.world.edit.subscreen.experience"));
            this.addLabel(new RealmsLabel(component, this.width / 2, 26, -65536));
        }
        this.nameEdit = this.addWidget(new EditBox(this.minecraft.font, this.column1X, RealmsSlotOptionsScreen.row(1), this.columnWidth, 20, null, Component.translatable("mco.configure.world.edit.slot.name")));
        this.nameEdit.setValue(this.worldName);
        this.nameEdit.setResponder(this::setWorldName);
        CycleButton<Boolean> cyclebutton5 = this.addRenderableWidget(CycleButton.onOffBuilder(this.pvp).create(i, RealmsSlotOptionsScreen.row(1), this.columnWidth, 20, Component.translatable("mco.configure.world.pvp"), (p_419631_, p_419573_) -> {
            this.pvp = p_419573_;
        }));
        CycleButton<GameType> cyclebutton = this.addRenderableWidget(CycleButton.builder(GameType::getShortDisplayName).withValues((Collection<GameType>)GAME_MODES).withInitialValue(this.gameMode).create(this.column1X, RealmsSlotOptionsScreen.row(3), this.columnWidth, 20, Component.translatable("selectWorld.gameMode"), (p_419688_, p_419516_) -> {
            this.gameMode = p_419516_;
        }));
        this.spawnProtectionButton = this.addRenderableWidget(new SettingsSlider(i, RealmsSlotOptionsScreen.row(3), this.columnWidth, this.spawnProtection, 0.0f, 16.0f));
        MutableComponent component1 = Component.translatable("mco.configure.world.spawn_toggle.message");
        CycleButton<Boolean> cyclebutton1 = CycleButton.onOffBuilder(this.difficulty != Difficulty.PEACEFUL && this.spawnMonsters).create(i, RealmsSlotOptionsScreen.row(5), this.columnWidth, 20, Component.translatable("mco.configure.world.spawnMonsters"), this.confirmDangerousOption(component1, p_419831_ -> {
            this.spawnMonsters = p_419831_;
        }));
        CycleButton<Difficulty> cyclebutton2 = this.addRenderableWidget(CycleButton.builder(Difficulty::getDisplayName).withValues((Collection<Difficulty>)DIFFICULTIES).withInitialValue(this.difficulty).create(this.column1X, RealmsSlotOptionsScreen.row(5), this.columnWidth, 20, Component.translatable("options.difficulty"), (p_419864_, p_419496_) -> {
            this.difficulty = p_419496_;
            if (this.worldType == RealmsServer.WorldType.NORMAL) {
                boolean flag;
                cyclebutton1.active = flag = this.difficulty != Difficulty.PEACEFUL;
                cyclebutton1.setValue(flag && this.spawnMonsters);
            }
        }));
        this.addRenderableWidget(cyclebutton1);
        CycleButton<Boolean> cyclebutton3 = this.addRenderableWidget(CycleButton.onOffBuilder(this.forceGameMode).create(this.column1X, RealmsSlotOptionsScreen.row(7), this.columnWidth, 20, Component.translatable("mco.configure.world.forceGameMode"), (p_419549_, p_419556_) -> {
            this.forceGameMode = p_419556_;
        }));
        CycleButton<Boolean> cyclebutton4 = this.addRenderableWidget(CycleButton.onOffBuilder(this.commandBlocks).create(i, RealmsSlotOptionsScreen.row(7), this.columnWidth, 20, Component.translatable("mco.configure.world.commandBlocks"), (p_419698_, p_419812_) -> {
            this.commandBlocks = p_419812_;
        }));
        if (this.worldType != RealmsServer.WorldType.NORMAL) {
            cyclebutton5.active = false;
            cyclebutton1.active = false;
            this.spawnProtectionButton.active = false;
            cyclebutton3.active = false;
        }
        if (this.difficulty == Difficulty.PEACEFUL) {
            cyclebutton1.active = false;
        }
        if (this.slot.isHardcore()) {
            cyclebutton4.active = false;
            cyclebutton2.active = false;
            cyclebutton.active = false;
            cyclebutton1.active = false;
            cyclebutton3.active = false;
        }
        this.addRenderableWidget(Button.builder(Component.translatable("mco.configure.world.buttons.done"), p_419696_ -> this.saveSettings()).bounds(this.column1X, RealmsSlotOptionsScreen.row(13), this.columnWidth, 20).build());
        this.addRenderableWidget(Button.builder(CommonComponents.GUI_CANCEL, p_420045_ -> this.onClose()).bounds(i, RealmsSlotOptionsScreen.row(13), this.columnWidth, 20).build());
    }

    private CycleButton.OnValueChange<Boolean> confirmDangerousOption(Component p_419458_, Consumer<Boolean> p_419888_) {
        return (p_419961_, p_419623_) -> {
            if (p_419623_.booleanValue()) {
                p_419888_.accept(true);
            } else {
                this.minecraft.setScreen(RealmsPopups.warningPopupScreen(this, p_419458_, p_419504_ -> {
                    p_419888_.accept(false);
                    p_419504_.onClose();
                }));
            }
        };
    }

    @Override
    public Component getNarrationMessage() {
        return CommonComponents.joinForNarration(this.getTitle(), this.createLabelNarration());
    }

    @Override
    public void render(GuiGraphics p_419989_, int p_419940_, int p_419891_, float p_419545_) {
        super.render(p_419989_, p_419940_, p_419891_, p_419545_);
        p_419989_.drawCenteredString(this.font, this.title, this.width / 2, 17, -1);
        p_419989_.drawString(this.font, NAME_LABEL, this.column1X + this.columnWidth / 2 - this.font.width(NAME_LABEL) / 2, RealmsSlotOptionsScreen.row(0) - 5, -1);
        this.nameEdit.render(p_419989_, p_419940_, p_419891_, p_419545_);
    }

    private void setWorldName(String p_419649_) {
        this.worldName = p_419649_.equals(this.defaultSlotName) ? "" : p_419649_;
    }

    private void saveSettings() {
        int i = RealmsSlotOptionsScreen.findIndex(DIFFICULTIES, this.difficulty, 2);
        int j = RealmsSlotOptionsScreen.findIndex(GAME_MODES, this.gameMode, 0);
        if (this.worldType != RealmsServer.WorldType.ADVENTUREMAP && this.worldType != RealmsServer.WorldType.EXPERIENCE && this.worldType != RealmsServer.WorldType.INSPIRATION) {
            boolean flag = this.worldType == RealmsServer.WorldType.NORMAL && this.difficulty != Difficulty.PEACEFUL && this.spawnMonsters;
            this.parentScreen.saveSlotSettings(new RealmsSlot(this.slot.slotId, new RealmsWorldOptions(this.pvp, flag, this.spawnProtection, this.commandBlocks, i, j, this.forceGameMode, this.worldName, this.slot.options.version, this.slot.options.compatibility), this.slot.settings));
        } else {
            this.parentScreen.saveSlotSettings(new RealmsSlot(this.slot.slotId, new RealmsWorldOptions(this.slot.options.pvp, this.slot.options.spawnMonsters, this.slot.options.spawnProtection, this.slot.options.commandBlocks, i, j, this.slot.options.forceGameMode, this.worldName, this.slot.options.version, this.slot.options.compatibility), this.slot.settings));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class SettingsSlider
    extends AbstractSliderButton {
        private final double minValue;
        private final double maxValue;

        public SettingsSlider(int p_419958_, int p_419830_, int p_419706_, int p_419966_, float p_419779_, float p_420076_) {
            super(p_419958_, p_419830_, p_419706_, 20, CommonComponents.EMPTY, 0.0);
            this.minValue = p_419779_;
            this.maxValue = p_420076_;
            this.value = (Mth.clamp((float)p_419966_, p_419779_, p_420076_) - p_419779_) / (p_420076_ - p_419779_);
            this.updateMessage();
        }

        @Override
        public void applyValue() {
            if (RealmsSlotOptionsScreen.this.spawnProtectionButton.active) {
                RealmsSlotOptionsScreen.this.spawnProtection = (int)Mth.lerp(Mth.clamp(this.value, 0.0, 1.0), this.minValue, this.maxValue);
            }
        }

        @Override
        protected void updateMessage() {
            this.setMessage(CommonComponents.optionNameValue(SPAWN_PROTECTION_TEXT, RealmsSlotOptionsScreen.this.spawnProtection == 0 ? CommonComponents.OPTION_OFF : Component.literal(String.valueOf(RealmsSlotOptionsScreen.this.spawnProtection))));
        }
    }
}

