/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens.configuration;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.dto.Ops;
import com.mojang.realmsclient.dto.PlayerInfo;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.screens.RealmsConfirmScreen;
import com.mojang.realmsclient.gui.screens.configuration.RealmsConfigurationTab;
import com.mojang.realmsclient.gui.screens.configuration.RealmsConfigureWorldScreen;
import com.mojang.realmsclient.gui.screens.configuration.RealmsInviteScreen;
import com.mojang.realmsclient.util.RealmsUtil;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.GridLayoutTab;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
class RealmsPlayersTab
extends GridLayoutTab
implements RealmsConfigurationTab {
    static final Logger LOGGER = LogUtils.getLogger();
    static final Component TITLE = Component.translatable("mco.configure.world.players.title");
    static final Component QUESTION_TITLE = Component.translatable("mco.question");
    private static final int PADDING = 8;
    final RealmsConfigureWorldScreen configurationScreen;
    final Minecraft minecraft;
    RealmsServer serverData;
    private final InvitedObjectSelectionList invitedList;

    RealmsPlayersTab(RealmsConfigureWorldScreen p_420029_, Minecraft p_420009_, RealmsServer p_419501_) {
        super(TITLE);
        this.configurationScreen = p_420029_;
        this.minecraft = p_420009_;
        this.serverData = p_419501_;
        GridLayout.RowHelper gridlayout$rowhelper = this.layout.spacing(8).createRowHelper(1);
        this.invitedList = gridlayout$rowhelper.addChild(new InvitedObjectSelectionList(p_420029_.width, this.calculateListHeight()), LayoutSettings.defaults().alignVerticallyTop().alignHorizontallyCenter());
        gridlayout$rowhelper.addChild(Button.builder(Component.translatable("mco.configure.world.buttons.invite"), p_419740_ -> p_420009_.setScreen(new RealmsInviteScreen(p_420029_, p_419501_))).build(), LayoutSettings.defaults().alignVerticallyBottom().alignHorizontallyCenter());
        this.updateData(p_419501_);
    }

    public int calculateListHeight() {
        return this.configurationScreen.getContentHeight() - 20 - 16;
    }

    @Override
    public void doLayout(ScreenRectangle p_419767_) {
        this.invitedList.setSize(this.configurationScreen.width, this.calculateListHeight());
        super.doLayout(p_419767_);
    }

    @Override
    public void updateData(RealmsServer p_419463_) {
        this.serverData = p_419463_;
        this.invitedList.children().clear();
        for (PlayerInfo playerinfo : p_419463_.players) {
            this.invitedList.children().add(new Entry(playerinfo));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class InvitedObjectSelectionList
    extends ContainerObjectSelectionList<Entry> {
        private static final int ITEM_HEIGHT = 36;

        public InvitedObjectSelectionList(int p_420026_, int p_419521_) {
            super(Minecraft.getInstance(), p_420026_, p_419521_, RealmsPlayersTab.this.configurationScreen.getHeaderHeight(), 36, 13);
        }

        @Override
        protected void renderHeader(GuiGraphics p_419750_, int p_419702_, int p_419712_) {
            String s = RealmsPlayersTab.this.serverData.players != null ? Integer.toString(RealmsPlayersTab.this.serverData.players.size()) : "0";
            MutableComponent component = Component.translatable("mco.configure.world.invited.number", s).withStyle(ChatFormatting.UNDERLINE);
            p_419750_.drawString(RealmsPlayersTab.this.configurationScreen.getFont(), component, p_419702_ + this.getRowWidth() / 2 - RealmsPlayersTab.this.configurationScreen.getFont().width(component) / 2, p_419712_, -1);
        }

        @Override
        protected void renderListBackground(GuiGraphics p_419974_) {
        }

        @Override
        protected void renderListSeparators(GuiGraphics p_419993_) {
        }

        @Override
        public int getRowWidth() {
            return 300;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        protected static final int SKIN_FACE_SIZE = 32;
        private static final Component NORMAL_USER_TEXT = Component.translatable("mco.configure.world.invites.normal.tooltip");
        private static final Component OP_TEXT = Component.translatable("mco.configure.world.invites.ops.tooltip");
        private static final Component REMOVE_TEXT = Component.translatable("mco.configure.world.invites.remove.tooltip");
        private static final ResourceLocation MAKE_OP_SPRITE = ResourceLocation.withDefaultNamespace("player_list/make_operator");
        private static final ResourceLocation REMOVE_OP_SPRITE = ResourceLocation.withDefaultNamespace("player_list/remove_operator");
        private static final ResourceLocation REMOVE_PLAYER_SPRITE = ResourceLocation.withDefaultNamespace("player_list/remove_player");
        private static final int ICON_WIDTH = 8;
        private static final int ICON_HEIGHT = 7;
        private final PlayerInfo playerInfo;
        private final Button removeButton;
        private final Button makeOpButton;
        private final Button removeOpButton;

        public Entry(PlayerInfo p_419792_) {
            this.playerInfo = p_419792_;
            int i = RealmsPlayersTab.this.serverData.players.indexOf(this.playerInfo);
            this.makeOpButton = SpriteIconButton.builder(NORMAL_USER_TEXT, p_419596_ -> this.op(i), false).sprite(MAKE_OP_SPRITE, 8, 7).width(16 + RealmsPlayersTab.this.configurationScreen.getFont().width(NORMAL_USER_TEXT)).narration(p_420041_ -> CommonComponents.joinForNarration(Component.translatable("mco.invited.player.narration", p_419792_.getName()), (Component)p_420041_.get(), Component.translatable("narration.cycle_button.usage.focused", OP_TEXT))).build();
            this.removeOpButton = SpriteIconButton.builder(OP_TEXT, p_419838_ -> this.deop(i), false).sprite(REMOVE_OP_SPRITE, 8, 7).width(16 + RealmsPlayersTab.this.configurationScreen.getFont().width(OP_TEXT)).narration(p_419705_ -> CommonComponents.joinForNarration(Component.translatable("mco.invited.player.narration", p_419792_.getName()), (Component)p_419705_.get(), Component.translatable("narration.cycle_button.usage.focused", NORMAL_USER_TEXT))).build();
            this.removeButton = SpriteIconButton.builder(REMOVE_TEXT, p_419895_ -> this.uninvite(i), false).sprite(REMOVE_PLAYER_SPRITE, 8, 7).width(16 + RealmsPlayersTab.this.configurationScreen.getFont().width(REMOVE_TEXT)).narration(p_419760_ -> CommonComponents.joinForNarration(Component.translatable("mco.invited.player.narration", p_419792_.getName()), (Component)p_419760_.get())).build();
            this.updateOpButtons();
        }

        private void op(int p_419741_) {
            UUID uuid = RealmsPlayersTab.this.serverData.players.get(p_419741_).getUuid();
            RealmsUtil.supplyAsync(p_428663_ -> p_428663_.op(RealmsPlayersTab.this.serverData.id, uuid), p_428657_ -> LOGGER.error("Couldn't op the user", (Throwable)p_428657_)).thenAcceptAsync(p_428650_ -> {
                this.updateOps((Ops)p_428650_);
                this.updateOpButtons();
                this.setFocused(this.removeOpButton);
            }, (Executor)RealmsPlayersTab.this.minecraft);
        }

        private void deop(int p_419591_) {
            UUID uuid = RealmsPlayersTab.this.serverData.players.get(p_419591_).getUuid();
            RealmsUtil.supplyAsync(p_428659_ -> p_428659_.deop(RealmsPlayersTab.this.serverData.id, uuid), p_428661_ -> LOGGER.error("Couldn't deop the user", (Throwable)p_428661_)).thenAcceptAsync(p_428660_ -> {
                this.updateOps((Ops)p_428660_);
                this.updateOpButtons();
                this.setFocused(this.makeOpButton);
            }, (Executor)RealmsPlayersTab.this.minecraft);
        }

        private void uninvite(int p_420017_) {
            if (p_420017_ >= 0 && p_420017_ < RealmsPlayersTab.this.serverData.players.size()) {
                PlayerInfo playerinfo = RealmsPlayersTab.this.serverData.players.get(p_420017_);
                RealmsConfirmScreen realmsconfirmscreen = new RealmsConfirmScreen(p_428653_ -> {
                    if (p_428653_) {
                        RealmsUtil.runAsync(p_428656_ -> p_428656_.uninvite(RealmsPlayersTab.this.serverData.id, playerinfo.getUuid()), p_428654_ -> LOGGER.error("Couldn't uninvite user", (Throwable)p_428654_));
                        RealmsPlayersTab.this.serverData.players.remove(p_420017_);
                        RealmsPlayersTab.this.updateData(RealmsPlayersTab.this.serverData);
                    }
                    RealmsPlayersTab.this.minecraft.setScreen(RealmsPlayersTab.this.configurationScreen);
                }, QUESTION_TITLE, Component.translatable("mco.configure.world.uninvite.player", playerinfo.getName()));
                RealmsPlayersTab.this.minecraft.setScreen(realmsconfirmscreen);
            }
        }

        private void updateOps(Ops p_419986_) {
            for (PlayerInfo playerinfo : RealmsPlayersTab.this.serverData.players) {
                playerinfo.setOperator(p_419986_.ops.contains(playerinfo.getName()));
            }
        }

        private void updateOpButtons() {
            this.makeOpButton.visible = !this.playerInfo.isOperator();
            this.removeOpButton.visible = !this.makeOpButton.visible;
        }

        private Button activeOpButton() {
            return this.makeOpButton.visible ? this.makeOpButton : this.removeOpButton;
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.activeOpButton(), (Object)this.removeButton);
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.activeOpButton(), (Object)this.removeButton);
        }

        @Override
        public void render(GuiGraphics p_419900_, int p_419784_, int p_419710_, int p_419805_, int p_419646_, int p_419873_, int p_419592_, int p_419863_, boolean p_419468_, float p_419542_) {
            int i = !this.playerInfo.getAccepted() ? -6250336 : (this.playerInfo.getOnline() ? -16711936 : -1);
            int j = p_419710_ + p_419873_ / 2 - 16;
            RealmsUtil.renderPlayerFace(p_419900_, p_419805_, j, 32, this.playerInfo.getUuid());
            int k = p_419710_ + p_419873_ / 2 - 4;
            p_419900_.drawString(RealmsPlayersTab.this.configurationScreen.getFont(), this.playerInfo.getName(), p_419805_ + 8 + 32, k, i);
            int l = p_419710_ + p_419873_ / 2 - 10;
            int i1 = p_419805_ + p_419646_ - this.removeButton.getWidth();
            this.removeButton.setPosition(i1, l);
            this.removeButton.render(p_419900_, p_419592_, p_419863_, p_419542_);
            int j1 = i1 - this.activeOpButton().getWidth() - 8;
            this.makeOpButton.setPosition(j1, l);
            this.makeOpButton.render(p_419900_, p_419592_, p_419863_, p_419542_);
            this.removeOpButton.setPosition(j1, l);
            this.removeOpButton.render(p_419900_, p_419592_, p_419863_, p_419542_);
        }
    }
}

