/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens.configuration;

import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.Backup;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.gui.screens.RealmsPopups;
import com.mojang.realmsclient.gui.screens.configuration.RealmsBackupInfoScreen;
import com.mojang.realmsclient.gui.screens.configuration.RealmsConfigureWorldScreen;
import com.mojang.realmsclient.util.RealmsUtil;
import com.mojang.realmsclient.util.task.DownloadTask;
import com.mojang.realmsclient.util.task.RestoreTask;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.realms.RealmsScreen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class RealmsBackupScreen
extends RealmsScreen {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final Component TITLE = Component.translatable("mco.configure.world.backup");
    static final Component RESTORE_TOOLTIP = Component.translatable("mco.backup.button.restore");
    static final Component HAS_CHANGES_TOOLTIP = Component.translatable("mco.backup.changes.tooltip");
    private static final Component NO_BACKUPS_LABEL = Component.translatable("mco.backup.nobackups");
    private static final Component DOWNLOAD_LATEST = Component.translatable("mco.backup.button.download");
    private static final String UPLOADED_KEY = "uploaded";
    private static final int PADDING = 8;
    final RealmsConfigureWorldScreen lastScreen;
    List<Backup> backups = Collections.emptyList();
    @Nullable
    BackupObjectSelectionList backupList;
    final HeaderAndFooterLayout layout = new HeaderAndFooterLayout(this);
    private final int slotId;
    @Nullable
    Button downloadButton;
    final RealmsServer serverData;
    boolean noBackups = false;

    public RealmsBackupScreen(RealmsConfigureWorldScreen p_419964_, RealmsServer p_419952_, int p_419534_) {
        super(TITLE);
        this.lastScreen = p_419964_;
        this.serverData = p_419952_;
        this.slotId = p_419534_;
    }

    @Override
    public void init() {
        this.layout.addTitleHeader(TITLE, this.font);
        this.backupList = this.layout.addToContents(new BackupObjectSelectionList(this));
        LinearLayout linearlayout = this.layout.addToFooter(LinearLayout.horizontal().spacing(8));
        this.downloadButton = linearlayout.addChild(Button.builder(DOWNLOAD_LATEST, p_419575_ -> this.downloadClicked()).build());
        this.downloadButton.active = false;
        linearlayout.addChild(Button.builder(CommonComponents.GUI_BACK, p_419954_ -> this.onClose()).build());
        this.layout.visitWidgets(p_419733_ -> {
            AbstractWidget abstractwidget = this.addRenderableWidget(p_419733_);
        });
        this.repositionElements();
        this.fetchRealmsBackups();
    }

    @Override
    public void render(GuiGraphics p_420022_, int p_419562_, int p_420071_, float p_419820_) {
        super.render(p_420022_, p_419562_, p_420071_, p_419820_);
        if (this.noBackups && this.backupList != null) {
            p_420022_.drawString(this.font, NO_BACKUPS_LABEL, this.width / 2 - this.font.width(NO_BACKUPS_LABEL) / 2, this.backupList.getY() + this.backupList.getHeight() / 2 - 4, -1);
        }
    }

    @Override
    protected void repositionElements() {
        this.layout.arrangeElements();
        if (this.backupList != null) {
            this.backupList.updateSize(this.width, this.layout);
        }
    }

    private void fetchRealmsBackups() {
        new Thread("Realms-fetch-backups"){

            @Override
            public void run() {
                RealmsClient realmsclient = RealmsClient.getOrCreate();
                try {
                    List<Backup> list = realmsclient.backupsFor((long)RealmsBackupScreen.this.serverData.id).backups;
                    RealmsBackupScreen.this.minecraft.execute(() -> {
                        RealmsBackupScreen.this.backups = list;
                        RealmsBackupScreen.this.noBackups = RealmsBackupScreen.this.backups.isEmpty();
                        if (!RealmsBackupScreen.this.noBackups && RealmsBackupScreen.this.downloadButton != null) {
                            RealmsBackupScreen.this.downloadButton.active = true;
                        }
                        if (RealmsBackupScreen.this.backupList != null) {
                            RealmsBackupScreen.this.backupList.replaceEntries(RealmsBackupScreen.this.backups.stream().map(p_419757_ -> {
                                RealmsBackupScreen realmsBackupScreen = RealmsBackupScreen.this;
                                Objects.requireNonNull(realmsBackupScreen);
                                return realmsBackupScreen.new Entry((Backup)p_419757_);
                            }).toList());
                        }
                    });
                }
                catch (RealmsServiceException realmsserviceexception) {
                    LOGGER.error("Couldn't request backups", (Throwable)realmsserviceexception);
                }
            }
        }.start();
    }

    @Override
    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    private void downloadClicked() {
        this.minecraft.setScreen(RealmsPopups.infoPopupScreen(this, Component.translatable("mco.configure.world.restore.download.question.line1"), p_419482_ -> this.minecraft.setScreen(new RealmsLongRunningMcoTaskScreen(this.lastScreen.getNewScreen(), new DownloadTask(this.serverData.id, this.slotId, Objects.requireNonNullElse(this.serverData.name, "") + " (" + this.serverData.slots.get((Object)Integer.valueOf((int)this.serverData.activeSlot)).options.getSlotName(this.serverData.activeSlot) + ")", this)))));
    }

    @OnlyIn(value=Dist.CLIENT)
    class BackupObjectSelectionList
    extends ContainerObjectSelectionList<Entry> {
        private static final int ITEM_HEIGHT = 36;

        public BackupObjectSelectionList(RealmsBackupScreen this$0) {
            super(Minecraft.getInstance(), this$0.width, this$0.layout.getContentHeight(), this$0.layout.getHeaderHeight(), 36);
        }

        @Override
        public int getRowWidth() {
            return 300;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        private static final int Y_PADDING = 2;
        private final Backup backup;
        @Nullable
        private Button restoreButton;
        @Nullable
        private Button changesButton;
        private final List<AbstractWidget> children = new ArrayList<AbstractWidget>();

        public Entry(Backup p_419474_) {
            this.backup = p_419474_;
            this.populateChangeList(p_419474_);
            if (!p_419474_.changeList.isEmpty()) {
                this.changesButton = Button.builder(HAS_CHANGES_TOOLTIP, p_419478_ -> RealmsBackupScreen.this.minecraft.setScreen(new RealmsBackupInfoScreen(RealmsBackupScreen.this, this.backup))).width(8 + RealmsBackupScreen.this.font.width(HAS_CHANGES_TOOLTIP)).createNarration(p_419597_ -> CommonComponents.joinForNarration(Component.translatable("mco.backup.narration", this.getShortBackupDate()), (Component)p_419597_.get())).build();
                this.children.add(this.changesButton);
            }
            if (!RealmsBackupScreen.this.serverData.expired) {
                this.restoreButton = Button.builder(RESTORE_TOOLTIP, p_419643_ -> this.restoreClicked()).width(8 + RealmsBackupScreen.this.font.width(HAS_CHANGES_TOOLTIP)).createNarration(p_419587_ -> CommonComponents.joinForNarration(Component.translatable("mco.backup.narration", this.getShortBackupDate()), (Component)p_419587_.get())).build();
                this.children.add(this.restoreButton);
            }
        }

        private void populateChangeList(Backup p_419699_) {
            int i = RealmsBackupScreen.this.backups.indexOf(p_419699_);
            if (i != RealmsBackupScreen.this.backups.size() - 1) {
                Backup backup = RealmsBackupScreen.this.backups.get(i + 1);
                for (String s : p_419699_.metadata.keySet()) {
                    if (!s.contains(RealmsBackupScreen.UPLOADED_KEY) && backup.metadata.containsKey(s)) {
                        if (p_419699_.metadata.get(s).equals(backup.metadata.get(s))) continue;
                        this.addToChangeList(s);
                        continue;
                    }
                    this.addToChangeList(s);
                }
            }
        }

        private void addToChangeList(String p_419607_) {
            if (p_419607_.contains(RealmsBackupScreen.UPLOADED_KEY)) {
                String s = DateFormat.getDateTimeInstance(3, 3).format(this.backup.lastModifiedDate);
                this.backup.changeList.put(p_419607_, s);
                this.backup.setUploadedVersion(true);
            } else {
                this.backup.changeList.put(p_419607_, this.backup.metadata.get(p_419607_));
            }
        }

        private String getShortBackupDate() {
            return DateFormat.getDateTimeInstance(3, 3).format(this.backup.lastModifiedDate);
        }

        private void restoreClicked() {
            Component component = RealmsUtil.convertToAgePresentationFromInstant(this.backup.lastModifiedDate);
            MutableComponent component1 = Component.translatable("mco.configure.world.restore.question.line1", this.getShortBackupDate(), component);
            RealmsBackupScreen.this.minecraft.setScreen(RealmsPopups.warningPopupScreen(RealmsBackupScreen.this, component1, p_428647_ -> {
                RealmsConfigureWorldScreen realmsconfigureworldscreen = RealmsBackupScreen.this.lastScreen.getNewScreen();
                RealmsBackupScreen.this.minecraft.setScreen(new RealmsLongRunningMcoTaskScreen(realmsconfigureworldscreen, new RestoreTask(this.backup, RealmsBackupScreen.this.serverData.id, realmsconfigureworldscreen)));
            }));
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return this.children;
        }

        @Override
        public void render(GuiGraphics p_419911_, int p_420010_, int p_419871_, int p_419810_, int p_419678_, int p_420074_, int p_419965_, int p_419770_, boolean p_419483_, float p_419717_) {
            int i = p_419871_ + p_420074_ / 2;
            int j = i - 9 - 2;
            int k = i + 2;
            int l = this.backup.isUploadedVersion() ? -8388737 : -1;
            p_419911_.drawString(RealmsBackupScreen.this.font, Component.translatable("mco.backup.entry", RealmsUtil.convertToAgePresentationFromInstant(this.backup.lastModifiedDate)), p_419810_, j, l);
            p_419911_.drawString(RealmsBackupScreen.this.font, this.getMediumDatePresentation(this.backup.lastModifiedDate), p_419810_, k, -11776948);
            int i1 = 0;
            int j1 = p_419871_ + p_420074_ / 2 - 10;
            if (this.restoreButton != null) {
                this.restoreButton.setX(p_419810_ + p_419678_ - (i1 += this.restoreButton.getWidth() + 8));
                this.restoreButton.setY(j1);
                this.restoreButton.render(p_419911_, p_419965_, p_419770_, p_419717_);
            }
            if (this.changesButton != null) {
                this.changesButton.setX(p_419810_ + p_419678_ - (i1 += this.changesButton.getWidth() + 8));
                this.changesButton.setY(j1);
                this.changesButton.render(p_419911_, p_419965_, p_419770_, p_419717_);
            }
        }

        private String getMediumDatePresentation(Date p_419618_) {
            return DateFormat.getDateTimeInstance(3, 3).format(p_419618_);
        }
    }
}

