/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui;

import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.RealmsSlot;
import com.mojang.realmsclient.util.RealmsTextureManager;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RealmsWorldSlotButton
extends Button {
    private static final ResourceLocation SLOT_FRAME_SPRITE = ResourceLocation.withDefaultNamespace("widget/slot_frame");
    public static final ResourceLocation EMPTY_SLOT_LOCATION = ResourceLocation.withDefaultNamespace("textures/gui/realms/empty_frame.png");
    public static final ResourceLocation DEFAULT_WORLD_SLOT_1 = ResourceLocation.withDefaultNamespace("textures/gui/title/background/panorama_0.png");
    public static final ResourceLocation DEFAULT_WORLD_SLOT_2 = ResourceLocation.withDefaultNamespace("textures/gui/title/background/panorama_2.png");
    public static final ResourceLocation DEFAULT_WORLD_SLOT_3 = ResourceLocation.withDefaultNamespace("textures/gui/title/background/panorama_3.png");
    private static final Component SWITCH_TO_MINIGAME_SLOT_TOOLTIP = Component.translatable("mco.configure.world.slot.tooltip.minigame");
    private static final Component SWITCH_TO_WORLD_SLOT_TOOLTIP = Component.translatable("mco.configure.world.slot.tooltip");
    static final Component MINIGAME = Component.translatable("mco.worldSlot.minigame");
    private static final int WORLD_NAME_MAX_WIDTH = 64;
    private static final String DOTS = "...";
    private final int slotIndex;
    private State state;

    public RealmsWorldSlotButton(int p_87929_, int p_87930_, int p_87931_, int p_87932_, int p_87935_, RealmsServer p_419981_, Button.OnPress p_87936_) {
        super(p_87929_, p_87930_, p_87931_, p_87932_, CommonComponents.EMPTY, p_87936_, DEFAULT_NARRATION);
        this.slotIndex = p_87935_;
        this.state = this.setServerData(p_419981_);
    }

    public State getState() {
        return this.state;
    }

    public State setServerData(RealmsServer p_307266_) {
        this.state = new State(p_307266_, this.slotIndex);
        this.setTooltipAndNarration(this.state, p_307266_.minigameName);
        return this.state;
    }

    private void setTooltipAndNarration(State p_307359_, @Nullable String p_307244_) {
        Component component;
        switch (p_307359_.action.ordinal()) {
            case 1: {
                Component component2;
                if (p_307359_.minigame) {
                    component2 = SWITCH_TO_MINIGAME_SLOT_TOOLTIP;
                    break;
                }
                component2 = SWITCH_TO_WORLD_SLOT_TOOLTIP;
                break;
            }
            default: {
                Component component2 = component = null;
            }
        }
        if (component != null) {
            this.setTooltip(Tooltip.create(component));
        }
        MutableComponent mutablecomponent = Component.literal(p_307359_.slotName);
        if (p_307359_.minigame && p_307244_ != null) {
            mutablecomponent = mutablecomponent.append(CommonComponents.SPACE).append(p_307244_);
        }
        this.setMessage(mutablecomponent);
    }

    static Action getAction(RealmsServer p_87960_, boolean p_87961_, boolean p_87962_) {
        return p_87962_ || p_87961_ && p_87960_.expired ? Action.NOTHING : Action.SWITCH_SLOT;
    }

    @Override
    public void renderWidget(GuiGraphics p_282947_, int p_87965_, int p_87966_, float p_87967_) {
        Object s;
        Font font;
        int i = this.getX();
        int j = this.getY();
        boolean flag = this.isHoveredOrFocused();
        ResourceLocation resourcelocation = this.state.minigame ? RealmsTextureManager.worldTemplate(String.valueOf(this.state.imageId), this.state.image) : (this.state.empty ? EMPTY_SLOT_LOCATION : (this.state.image != null && this.state.imageId != -1L ? RealmsTextureManager.worldTemplate(String.valueOf(this.state.imageId), this.state.image) : (this.slotIndex == 1 ? DEFAULT_WORLD_SLOT_1 : (this.slotIndex == 2 ? DEFAULT_WORLD_SLOT_2 : (this.slotIndex == 3 ? DEFAULT_WORLD_SLOT_3 : EMPTY_SLOT_LOCATION)))));
        int k = -1;
        if (!this.state.activeSlot) {
            k = ARGB.colorFromFloat(1.0f, 0.56f, 0.56f, 0.56f);
        }
        p_282947_.blit(RenderPipelines.GUI_TEXTURED, resourcelocation, i + 1, j + 1, 0.0f, 0.0f, this.width - 2, this.height - 2, 74, 74, 74, 74, k);
        if (flag && this.state.action != Action.NOTHING) {
            p_282947_.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_FRAME_SPRITE, i, j, this.width, this.height);
        } else if (this.state.activeSlot) {
            p_282947_.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_FRAME_SPRITE, i, j, this.width, this.height, ARGB.colorFromFloat(1.0f, 0.8f, 0.8f, 0.8f));
        } else {
            p_282947_.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_FRAME_SPRITE, i, j, this.width, this.height, ARGB.colorFromFloat(1.0f, 0.56f, 0.56f, 0.56f));
        }
        if (this.state.hardcore) {
            p_282947_.blitSprite(RenderPipelines.GUI_TEXTURED, RealmsMainScreen.HARDCORE_MODE_SPRITE, i + 3, j + 4, 9, 8);
        }
        if ((font = Minecraft.getInstance().font).width((String)(s = this.state.slotName)) > 64) {
            s = font.plainSubstrByWidth((String)s, 64 - font.width(DOTS)) + DOTS;
        }
        p_282947_.drawCenteredString(font, (String)s, i + this.width / 2, j + this.height - 14, -1);
        if (this.state.activeSlot) {
            p_282947_.drawCenteredString(font, RealmsMainScreen.getVersionComponent(this.state.slotVersion, this.state.compatibility.isCompatible()), i + this.width / 2, j + this.height + 2, -1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class State {
        final String slotName;
        final String slotVersion;
        final RealmsServer.Compatibility compatibility;
        final long imageId;
        @Nullable
        final String image;
        public final boolean empty;
        public final boolean minigame;
        public final Action action;
        public final boolean hardcore;
        public final boolean activeSlot;

        public State(RealmsServer p_307209_, int p_307377_) {
            boolean bl = this.minigame = p_307377_ == 4;
            if (this.minigame) {
                this.slotName = MINIGAME.getString();
                this.imageId = p_307209_.minigameId;
                this.image = p_307209_.minigameImage;
                this.empty = p_307209_.minigameId == -1;
                this.slotVersion = "";
                this.compatibility = RealmsServer.Compatibility.UNVERIFIABLE;
                this.hardcore = false;
                this.activeSlot = p_307209_.isMinigameActive();
            } else {
                RealmsSlot realmsslot = p_307209_.slots.get(p_307377_);
                this.slotName = realmsslot.options.getSlotName(p_307377_);
                this.imageId = realmsslot.options.templateId;
                this.image = realmsslot.options.templateImage;
                this.empty = realmsslot.options.empty;
                this.slotVersion = realmsslot.options.version;
                this.compatibility = realmsslot.options.compatibility;
                this.hardcore = realmsslot.isHardcore();
                this.activeSlot = p_307209_.activeSlot == p_307377_ && !p_307209_.isMinigameActive();
            }
            this.action = RealmsWorldSlotButton.getAction(p_307209_, this.minigame, this.activeSlot);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Action {
        NOTHING,
        SWITCH_SLOT;

    }
}

