/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.dto;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.dto.ValueObject;
import com.mojang.realmsclient.util.JsonUtils;
import net.minecraft.util.LenientJsonParser;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class Subscription
extends ValueObject {
    private static final Logger LOGGER = LogUtils.getLogger();
    public long startDate;
    public int daysLeft;
    public SubscriptionType type = SubscriptionType.NORMAL;

    public static Subscription parse(String p_87673_) {
        Subscription subscription = new Subscription();
        try {
            JsonObject jsonobject = LenientJsonParser.parse(p_87673_).getAsJsonObject();
            subscription.startDate = JsonUtils.getLongOr("startDate", jsonobject, 0L);
            subscription.daysLeft = JsonUtils.getIntOr("daysLeft", jsonobject, 0);
            subscription.type = Subscription.typeFrom(JsonUtils.getStringOr("subscriptionType", jsonobject, SubscriptionType.NORMAL.name()));
        }
        catch (Exception exception) {
            LOGGER.error("Could not parse Subscription: {}", (Object)exception.getMessage());
        }
        return subscription;
    }

    private static SubscriptionType typeFrom(String p_87675_) {
        try {
            return SubscriptionType.valueOf(p_87675_);
        }
        catch (Exception exception) {
            return SubscriptionType.NORMAL;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum SubscriptionType {
        NORMAL,
        RECURRING;

    }
}

