/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.dto;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.dto.ValueObject;
import com.mojang.realmsclient.util.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.LenientJsonParser;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class RealmsServerPlayerLists
extends ValueObject {
    private static final Logger LOGGER = LogUtils.getLogger();
    public Map<Long, List<ProfileResult>> servers = Map.of();

    public static RealmsServerPlayerLists parse(String p_87597_) {
        RealmsServerPlayerLists realmsserverplayerlists = new RealmsServerPlayerLists();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        try {
            JsonObject jsonobject = GsonHelper.parse(p_87597_);
            if (GsonHelper.isArrayNode(jsonobject, "lists")) {
                for (JsonElement jsonelement : jsonobject.getAsJsonArray("lists")) {
                    JsonElement jsonelement1;
                    JsonObject jsonobject1 = jsonelement.getAsJsonObject();
                    String s = JsonUtils.getStringOr("playerList", jsonobject1, null);
                    List<Object> list = s != null ? ((jsonelement1 = LenientJsonParser.parse(s)).isJsonArray() ? RealmsServerPlayerLists.parsePlayers(jsonelement1.getAsJsonArray()) : Lists.newArrayList()) : Lists.newArrayList();
                    builder.put((Object)JsonUtils.getLongOr("serverId", jsonobject1, -1L), (Object)list);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Could not parse RealmsServerPlayerLists: {}", (Object)exception.getMessage());
        }
        realmsserverplayerlists.servers = builder.build();
        return realmsserverplayerlists;
    }

    private static List<ProfileResult> parsePlayers(JsonArray p_350938_) {
        ArrayList<ProfileResult> list = new ArrayList<ProfileResult>(p_350938_.size());
        MinecraftSessionService minecraftsessionservice = Minecraft.getInstance().getMinecraftSessionService();
        for (JsonElement jsonelement : p_350938_) {
            UUID uuid;
            if (!jsonelement.isJsonObject() || (uuid = JsonUtils.getUuidOr("playerId", jsonelement.getAsJsonObject(), null)) == null || Minecraft.getInstance().isLocalPlayer(uuid)) continue;
            try {
                ProfileResult profileresult = minecraftsessionservice.fetchProfile(uuid, false);
                if (profileresult == null) continue;
                list.add(profileresult);
            }
            catch (Exception exception) {
                LOGGER.error("Could not get name for {}", (Object)uuid, (Object)exception);
            }
        }
        return list;
    }

    public List<ProfileResult> getProfileResultsFor(long p_350315_) {
        List<ProfileResult> list = this.servers.get(p_350315_);
        return list != null ? list : List.of();
    }
}

