/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.client.worldupload;

import com.mojang.realmsclient.client.worldupload.RealmsUploadCanceledException;
import com.mojang.realmsclient.client.worldupload.RealmsUploadTooLargeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.function.BooleanSupplier;
import java.util.zip.GZIPOutputStream;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

@OnlyIn(value=Dist.CLIENT)
public class RealmsUploadWorldPacker {
    private static final long SIZE_LIMIT = 0x140000000L;
    private static final String WORLD_FOLDER_NAME = "world";
    private final BooleanSupplier isCanceled;
    private final Path directoryToPack;

    public static File pack(Path p_374057_, BooleanSupplier p_374422_) throws IOException {
        return new RealmsUploadWorldPacker(p_374057_, p_374422_).tarGzipArchive();
    }

    private RealmsUploadWorldPacker(Path p_374425_, BooleanSupplier p_374350_) {
        this.isCanceled = p_374350_;
        this.directoryToPack = p_374425_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File tarGzipArchive() throws IOException {
        File file2;
        try (TarArchiveOutputStream tararchiveoutputstream = null;){
            File file1 = File.createTempFile("realms-upload-file", ".tar.gz");
            tararchiveoutputstream = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(file1)));
            tararchiveoutputstream.setLongFileMode(3);
            this.addFileToTarGz(tararchiveoutputstream, this.directoryToPack, WORLD_FOLDER_NAME, true);
            if (this.isCanceled.getAsBoolean()) {
                throw new RealmsUploadCanceledException();
            }
            tararchiveoutputstream.finish();
            this.verifyBelowSizeLimit(file1.length());
            file2 = file1;
        }
        return file2;
    }

    private void addFileToTarGz(TarArchiveOutputStream p_374061_, Path p_374216_, String p_374206_, boolean p_374384_) throws IOException {
        if (this.isCanceled.getAsBoolean()) {
            throw new RealmsUploadCanceledException();
        }
        this.verifyBelowSizeLimit(p_374061_.getBytesWritten());
        File file1 = p_374216_.toFile();
        String s = p_374384_ ? p_374206_ : p_374206_ + file1.getName();
        TarArchiveEntry tararchiveentry = new TarArchiveEntry(file1, s);
        p_374061_.putArchiveEntry(tararchiveentry);
        if (file1.isFile()) {
            try (FileInputStream inputstream = new FileInputStream(file1);){
                ((InputStream)inputstream).transferTo((OutputStream)p_374061_);
            }
            p_374061_.closeArchiveEntry();
        } else {
            p_374061_.closeArchiveEntry();
            File[] afile = file1.listFiles();
            if (afile != null) {
                for (File file2 : afile) {
                    this.addFileToTarGz(p_374061_, file2.toPath(), s + "/", false);
                }
            }
        }
    }

    private void verifyBelowSizeLimit(long p_374584_) {
        if (p_374584_ > 0x140000000L) {
            throw new RealmsUploadTooLargeException(0x140000000L);
        }
    }
}

