/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.client;

import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.exception.RealmsHttpException;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.LenientJsonParser;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public interface RealmsError {
    public static final Component NO_MESSAGE = Component.translatable("mco.errorMessage.noDetails");
    public static final Logger LOGGER = LogUtils.getLogger();

    public int errorCode();

    public Component errorMessage();

    public String logMessage();

    public static RealmsError parse(int p_294532_, String p_87304_) {
        if (p_294532_ == 429) {
            return CustomError.SERVICE_BUSY;
        }
        if (Strings.isNullOrEmpty((String)p_87304_)) {
            return CustomError.noPayload(p_294532_);
        }
        try {
            JsonObject jsonobject = LenientJsonParser.parse(p_87304_).getAsJsonObject();
            String s = GsonHelper.getAsString(jsonobject, "reason", null);
            String s1 = GsonHelper.getAsString(jsonobject, "errorMsg", null);
            int i = GsonHelper.getAsInt(jsonobject, "errorCode", -1);
            if (s1 != null || s != null || i != -1) {
                return new ErrorWithJsonPayload(p_294532_, i != -1 ? i : p_294532_, s, s1);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Could not parse RealmsError", (Throwable)exception);
        }
        return new ErrorWithRawPayload(p_294532_, p_87304_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public record CustomError(int httpCode, @Nullable Component payload) implements RealmsError
    {
        public static final CustomError SERVICE_BUSY = new CustomError(429, Component.translatable("mco.errorMessage.serviceBusy"));
        public static final Component RETRY_MESSAGE = Component.translatable("mco.errorMessage.retry");
        public static final String BODY_TAG = "<body>";
        public static final String CLOSING_BODY_TAG = "</body>";

        public static CustomError unknownCompatibilityResponse(String p_294662_) {
            return new CustomError(500, Component.translatable("mco.errorMessage.realmsService.unknownCompatibility", p_294662_));
        }

        public static CustomError configurationError() {
            return new CustomError(500, Component.translatable("mco.errorMessage.realmsService.configurationError"));
        }

        public static CustomError connectivityError(RealmsHttpException p_294863_) {
            return new CustomError(500, Component.translatable("mco.errorMessage.realmsService.connectivity", p_294863_.getMessage()));
        }

        public static CustomError retry(int p_295020_) {
            return new CustomError(p_295020_, RETRY_MESSAGE);
        }

        public static CustomError noPayload(int p_295243_) {
            return new CustomError(p_295243_, null);
        }

        public static CustomError htmlPayload(int p_425823_, String p_425707_) {
            int i = p_425707_.indexOf(BODY_TAG);
            int j = p_425707_.indexOf(CLOSING_BODY_TAG);
            if (i >= 0 && j > i) {
                return new CustomError(p_425823_, Component.literal(p_425707_.substring(i + BODY_TAG.length(), j).trim()));
            }
            LOGGER.error("Got an error with an unreadable html body {}", (Object)p_425707_);
            return new CustomError(p_425823_, null);
        }

        @Override
        public int errorCode() {
            return this.httpCode;
        }

        @Override
        public Component errorMessage() {
            return this.payload != null ? this.payload : NO_MESSAGE;
        }

        @Override
        public String logMessage() {
            return this.payload != null ? String.format(Locale.ROOT, "Realms service error (%d) with message '%s'", this.httpCode, this.payload.getString()) : String.format(Locale.ROOT, "Realms service error (%d) with no payload", this.httpCode);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record ErrorWithJsonPayload(int httpCode, int code, @Nullable String reason, @Nullable String message) implements RealmsError
    {
        @Override
        public int errorCode() {
            return this.code;
        }

        @Override
        public Component errorMessage() {
            String s1;
            String s = "mco.errorMessage." + this.code;
            if (I18n.exists(s)) {
                return Component.translatable(s);
            }
            if (this.reason != null && I18n.exists(s1 = "mco.errorReason." + this.reason)) {
                return Component.translatable(s1);
            }
            return this.message != null ? Component.literal(this.message) : NO_MESSAGE;
        }

        @Override
        public String logMessage() {
            return String.format(Locale.ROOT, "Realms service error (%d/%d/%s) with message '%s'", this.httpCode, this.code, this.reason, this.message);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record ErrorWithRawPayload(int httpCode, String payload) implements RealmsError
    {
        @Override
        public int errorCode() {
            return this.httpCode;
        }

        @Override
        public Component errorMessage() {
            return Component.literal(this.payload);
        }

        @Override
        public String logMessage() {
            return String.format(Locale.ROOT, "Realms service error (%d) with raw payload '%s'", this.httpCode, this.payload);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record AuthenticationError(String message) implements RealmsError
    {
        public static final int ERROR_CODE = 401;

        @Override
        public int errorCode() {
            return 401;
        }

        @Override
        public Component errorMessage() {
            return Component.literal(this.message);
        }

        @Override
        public String logMessage() {
            return String.format(Locale.ROOT, "Realms authentication error with message '%s'", this.message);
        }
    }
}

