/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient;

import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.screens.RealmsClientOutdatedScreen;
import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import com.mojang.realmsclient.gui.screens.RealmsParentalConsentScreen;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class RealmsAvailability {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private static CompletableFuture<Result> future;

    public static CompletableFuture<Result> get() {
        if (future == null || RealmsAvailability.shouldRefresh(future)) {
            future = RealmsAvailability.check();
        }
        return future;
    }

    private static boolean shouldRefresh(CompletableFuture<Result> p_295124_) {
        Result realmsavailability$result = p_295124_.getNow(null);
        return realmsavailability$result != null && realmsavailability$result.exception() != null;
    }

    private static CompletableFuture<Result> check() {
        User user = Minecraft.getInstance().getUser();
        return user.getType() != User.Type.MSA ? CompletableFuture.completedFuture(new Result(Type.AUTHENTICATION_ERROR)) : CompletableFuture.supplyAsync(() -> {
            RealmsClient realmsclient = RealmsClient.getOrCreate();
            try {
                if (realmsclient.clientCompatible() != RealmsClient.CompatibleVersionResponse.COMPATIBLE) {
                    return new Result(Type.INCOMPATIBLE_CLIENT);
                }
                return !realmsclient.hasParentalConsent() ? new Result(Type.NEEDS_PARENTAL_CONSENT) : new Result(Type.SUCCESS);
            }
            catch (RealmsServiceException realmsserviceexception) {
                LOGGER.error("Couldn't connect to realms", (Throwable)realmsserviceexception);
                return realmsserviceexception.realmsError.errorCode() == 401 ? new Result(Type.AUTHENTICATION_ERROR) : new Result(realmsserviceexception);
            }
        }, Util.ioPool());
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Result(Type type, @Nullable RealmsServiceException exception) {
        public Result(Type p_294456_) {
            this(p_294456_, null);
        }

        public Result(RealmsServiceException p_294364_) {
            this(Type.UNEXPECTED_ERROR, p_294364_);
        }

        @Nullable
        public Screen createErrorScreen(Screen p_296406_) {
            return switch (this.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> null;
                case 1 -> new RealmsClientOutdatedScreen(p_296406_);
                case 2 -> new RealmsParentalConsentScreen(p_296406_);
                case 3 -> new RealmsGenericErrorScreen(Component.translatable("mco.error.invalid.session.title"), Component.translatable("mco.error.invalid.session.message"), p_296406_);
                case 4 -> new RealmsGenericErrorScreen(Objects.requireNonNull(this.exception), p_296406_);
            };
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Type {
        SUCCESS,
        INCOMPATIBLE_CLIENT,
        NEEDS_PARENTAL_CONSENT,
        AUTHENTICATION_ERROR,
        UNEXPECTED_ERROR;

    }
}

