/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.google.common.primitives.Floats;
import it.unimi.dsi.fastutil.ints.IntArrays;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public interface VertexSorting {
    public static final VertexSorting DISTANCE_TO_ORIGIN = VertexSorting.byDistance(0.0f, 0.0f, 0.0f);
    public static final VertexSorting ORTHOGRAPHIC_Z = VertexSorting.byDistance((Vector3f p_277433_) -> -p_277433_.z());

    public static VertexSorting byDistance(float p_277642_, float p_277654_, float p_278092_) {
        return VertexSorting.byDistance(new Vector3f(p_277642_, p_277654_, p_278092_));
    }

    public static VertexSorting byDistance(Vector3f p_277725_) {
        return VertexSorting.byDistance(arg_0 -> ((Vector3f)p_277725_).distanceSquared(arg_0));
    }

    public static VertexSorting byDistance(DistanceFunction p_277530_) {
        return p_278083_ -> {
            float[] afloat = new float[p_278083_.length];
            int[] aint = new int[p_278083_.length];
            int i = 0;
            while (i < p_278083_.length) {
                afloat[i] = p_277530_.apply(p_278083_[i]);
                aint[i] = i++;
            }
            IntArrays.mergeSort((int[])aint, (p_277443_, p_277864_) -> Floats.compare((float)afloat[p_277864_], (float)afloat[p_277443_]));
            return aint;
        };
    }

    public int[] sort(Vector3f[] var1);

    @OnlyIn(value=Dist.CLIENT)
    public static interface DistanceFunction {
        public float apply(Vector3f var1);
    }
}

