/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.mojang.blaze3d.DontObfuscate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@DontObfuscate
public record VertexFormatElement(int id, int index, Type type, Usage usage, int count) {
    public static final int MAX_COUNT = 32;
    private static final VertexFormatElement[] BY_ID = new VertexFormatElement[32];
    private static final List<VertexFormatElement> ELEMENTS = new ArrayList<VertexFormatElement>(32);
    public static final VertexFormatElement POSITION = VertexFormatElement.register(0, 0, Type.FLOAT, Usage.POSITION, 3);
    public static final VertexFormatElement COLOR = VertexFormatElement.register(1, 0, Type.UBYTE, Usage.COLOR, 4);
    public static final VertexFormatElement UV0;
    public static final VertexFormatElement UV;
    public static final VertexFormatElement UV1;
    public static final VertexFormatElement UV2;
    public static final VertexFormatElement NORMAL;

    public VertexFormatElement(int id, int index, Type type, Usage usage, int count) {
        if (id < 0 || id >= BY_ID.length) {
            throw new IllegalArgumentException("Element ID must be in range [0; " + BY_ID.length + ")");
        }
        if (!this.supportsUsage(index, usage)) {
            throw new IllegalStateException("Multiple vertex elements of the same type other than UVs are not supported");
        }
        this.id = id;
        this.index = index;
        this.type = type;
        this.usage = usage;
        this.count = count;
    }

    public static VertexFormatElement register(int p_350751_, int p_350658_, Type p_350861_, Usage p_350763_, int p_350519_) {
        VertexFormatElement vertexformatelement = new VertexFormatElement(p_350751_, p_350658_, p_350861_, p_350763_, p_350519_);
        if (BY_ID[p_350751_] != null) {
            throw new IllegalArgumentException("Duplicate element registration for: " + p_350751_);
        }
        VertexFormatElement.BY_ID[p_350751_] = vertexformatelement;
        ELEMENTS.add(vertexformatelement);
        return vertexformatelement;
    }

    private boolean supportsUsage(int p_86043_, Usage p_86044_) {
        return p_86043_ == 0 || p_86044_ == Usage.UV;
    }

    @Override
    public String toString() {
        return this.count + "," + String.valueOf((Object)this.usage) + "," + String.valueOf((Object)this.type) + " (" + this.id + ")";
    }

    public int mask() {
        return 1 << this.id;
    }

    public int byteSize() {
        return this.type.size() * this.count;
    }

    @Nullable
    public static VertexFormatElement byId(int p_350894_) {
        return BY_ID[p_350894_];
    }

    public static Stream<VertexFormatElement> elementsFromMask(int p_350349_) {
        return ELEMENTS.stream().filter(p_350573_ -> p_350573_ != null && (p_350349_ & p_350573_.mask()) != 0);
    }

    public static int findNextId() {
        for (int i = 0; i < BY_ID.length; ++i) {
            if (BY_ID[i] != null) continue;
            return i;
        }
        throw new IllegalStateException("VertexFormatElement count limit exceeded");
    }

    static {
        UV = UV0 = VertexFormatElement.register(2, 0, Type.FLOAT, Usage.UV, 2);
        UV1 = VertexFormatElement.register(3, 1, Type.SHORT, Usage.UV, 2);
        UV2 = VertexFormatElement.register(4, 2, Type.SHORT, Usage.UV, 2);
        NORMAL = VertexFormatElement.register(5, 0, Type.BYTE, Usage.NORMAL, 3);
    }

    @OnlyIn(value=Dist.CLIENT)
    @DontObfuscate
    public static enum Usage {
        POSITION("Position"),
        NORMAL("Normal"),
        COLOR("Vertex Color"),
        UV("UV"),
        GENERIC("Generic");

        private final String name;

        private Usage(String p_166975_) {
            this.name = p_166975_;
        }

        public String toString() {
            return this.name;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @DontObfuscate
    public static enum Type {
        FLOAT(4, "Float"),
        UBYTE(1, "Unsigned Byte"),
        BYTE(1, "Byte"),
        USHORT(2, "Unsigned Short"),
        SHORT(2, "Short"),
        UINT(4, "Unsigned Int"),
        INT(4, "Int");

        private final int size;
        private final String name;

        private Type(int p_86071_, String p_86072_) {
            this.size = p_86071_;
            this.name = p_86072_;
        }

        public int size() {
            return this.size;
        }

        public String toString() {
            return this.name;
        }
    }
}

