/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.ARGB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.IVertexConsumerExtension;
import org.joml.Matrix3x2f;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryStack;

@OnlyIn(value=Dist.CLIENT)
public interface VertexConsumer
extends IVertexConsumerExtension {
    public VertexConsumer addVertex(float var1, float var2, float var3);

    public VertexConsumer setColor(int var1, int var2, int var3, int var4);

    public VertexConsumer setUv(float var1, float var2);

    public VertexConsumer setUv1(int var1, int var2);

    public VertexConsumer setUv2(int var1, int var2);

    public VertexConsumer setNormal(float var1, float var2, float var3);

    default public void addVertex(float p_351049_, float p_350528_, float p_351018_, int p_350427_, float p_350508_, float p_350864_, int p_350846_, int p_350731_, float p_350784_, float p_351051_, float p_350759_) {
        this.addVertex(p_351049_, p_350528_, p_351018_);
        this.setColor(p_350427_);
        this.setUv(p_350508_, p_350864_);
        this.setOverlay(p_350846_);
        this.setLight(p_350731_);
        this.setNormal(p_350784_, p_351051_, p_350759_);
    }

    default public VertexConsumer setColor(float p_350350_, float p_350356_, float p_350623_, float p_350312_) {
        return this.setColor((int)(p_350350_ * 255.0f), (int)(p_350356_ * 255.0f), (int)(p_350623_ * 255.0f), (int)(p_350312_ * 255.0f));
    }

    default public VertexConsumer setColor(int p_350809_) {
        return this.setColor(ARGB.red(p_350809_), ARGB.green(p_350809_), ARGB.blue(p_350809_), ARGB.alpha(p_350809_));
    }

    default public VertexConsumer setWhiteAlpha(int p_350979_) {
        return this.setColor(ARGB.color(p_350979_, -1));
    }

    default public VertexConsumer setLight(int p_350855_) {
        return this.setUv2(p_350855_ & 0xFFFF, p_350855_ >> 16 & 0xFFFF);
    }

    default public VertexConsumer setOverlay(int p_350697_) {
        return this.setUv1(p_350697_ & 0xFFFF, p_350697_ >> 16 & 0xFFFF);
    }

    default public void putBulkData(PoseStack.Pose p_85996_, BakedQuad p_85997_, float p_85999_, float p_86000_, float p_86001_, float p_331520_, int p_86003_, int p_331548_) {
        this.putBulkData(p_85996_, p_85997_, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, p_85999_, p_86000_, p_86001_, p_331520_, new int[]{p_86003_, p_86003_, p_86003_, p_86003_}, p_331548_, false);
    }

    default public void putBulkData(PoseStack.Pose p_85988_, BakedQuad p_85989_, float[] p_331397_, float p_85990_, float p_85991_, float p_85992_, float p_331416_, int[] p_331378_, int p_85993_, boolean p_331268_) {
        int[] aint = p_85989_.vertices();
        Vector3fc vector3fc = p_85989_.direction().getUnitVec3f();
        Matrix4f matrix4f = p_85988_.pose();
        Vector3f vector3f = p_85988_.transformNormal(vector3fc, new Vector3f());
        int i = 8;
        int j = aint.length / 8;
        int k = (int)(p_331416_ * 255.0f);
        int l = p_85989_.lightEmission();
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormat.BLOCK.getVertexSize());
            IntBuffer intbuffer = bytebuffer.asIntBuffer();
            for (int i1 = 0; i1 < j; ++i1) {
                float f5;
                float f4;
                float f3;
                intbuffer.clear();
                intbuffer.put(aint, i1 * 8, 8);
                float f = bytebuffer.getFloat(0);
                float f1 = bytebuffer.getFloat(4);
                float f2 = bytebuffer.getFloat(8);
                if (p_331268_) {
                    float f6 = bytebuffer.get(12) & 0xFF;
                    float f7 = bytebuffer.get(13) & 0xFF;
                    float f8 = bytebuffer.get(14) & 0xFF;
                    f3 = f6 * p_331397_[i1] * p_85990_;
                    f4 = f7 * p_331397_[i1] * p_85991_;
                    f5 = f8 * p_331397_[i1] * p_85992_;
                } else {
                    f3 = p_331397_[i1] * p_85990_ * 255.0f;
                    f4 = p_331397_[i1] * p_85991_ * 255.0f;
                    f5 = p_331397_[i1] * p_85992_ * 255.0f;
                }
                int vertexAlpha = p_331268_ ? (int)(p_331416_ * (float)(bytebuffer.get(15) & 0xFF) / 255.0f * 255.0f) : k;
                int j1 = ARGB.color(vertexAlpha, (int)f3, (int)f4, (int)f5);
                int k1 = this.applyBakedLighting(LightTexture.lightCoordsWithEmission(p_331378_[i1], l), bytebuffer);
                float f10 = bytebuffer.getFloat(16);
                float f9 = bytebuffer.getFloat(20);
                Vector3f vector3f1 = matrix4f.transformPosition(f, f1, f2, new Vector3f());
                this.applyBakedNormals(vector3f, bytebuffer, p_85988_.normal());
                this.addVertex(vector3f1.x(), vector3f1.y(), vector3f1.z(), j1, f10, f9, p_85993_, k1, vector3f.x(), vector3f.y(), vector3f.z());
            }
        }
    }

    default public VertexConsumer addVertex(Vector3f p_350685_) {
        return this.addVertex(p_350685_.x(), p_350685_.y(), p_350685_.z());
    }

    default public VertexConsumer addVertex(PoseStack.Pose p_352288_, Vector3f p_352298_) {
        return this.addVertex(p_352288_, p_352298_.x(), p_352298_.y(), p_352298_.z());
    }

    default public VertexConsumer addVertex(PoseStack.Pose p_350506_, float p_350934_, float p_350873_, float p_350981_) {
        return this.addVertex(p_350506_.pose(), p_350934_, p_350873_, p_350981_);
    }

    default public VertexConsumer addVertex(Matrix4f p_350929_, float p_350884_, float p_350885_, float p_350942_) {
        Vector3f vector3f = p_350929_.transformPosition(p_350884_, p_350885_, p_350942_, new Vector3f());
        return this.addVertex(vector3f.x(), vector3f.y(), vector3f.z());
    }

    default public VertexConsumer addVertexWith2DPose(Matrix3x2f p_415624_, float p_415815_, float p_416074_, float p_415881_) {
        Vector2f vector2f = p_415624_.transformPosition(p_415815_, p_416074_, new Vector2f());
        return this.addVertex(vector2f.x(), vector2f.y(), p_415881_);
    }

    default public VertexConsumer setNormal(PoseStack.Pose p_350592_, float p_350534_, float p_350411_, float p_350441_) {
        Vector3f vector3f = p_350592_.transformNormal(p_350534_, p_350411_, p_350441_, new Vector3f());
        return this.setNormal(vector3f.x(), vector3f.y(), vector3f.z());
    }

    default public VertexConsumer setNormal(PoseStack.Pose p_362749_, Vector3f p_365318_) {
        return this.setNormal(p_362749_, p_365318_.x(), p_365318_.y(), p_365318_.z());
    }
}

