/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.mojang.blaze3d.DontObfuscate;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
@DontObfuscate
public class TextureUtil {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int MIN_MIPMAP_LEVEL = 0;
    private static final int DEFAULT_IMAGE_BUFFER_SIZE = 8192;

    public static ByteBuffer readResource(InputStream p_85304_) throws IOException {
        ByteBuffer byteBuffer;
        ReadableByteChannel readablebytechannel = Channels.newChannel(p_85304_);
        if (readablebytechannel instanceof SeekableByteChannel) {
            SeekableByteChannel seekablebytechannel = (SeekableByteChannel)readablebytechannel;
            byteBuffer = TextureUtil.readResource(readablebytechannel, (int)seekablebytechannel.size() + 1);
        } else {
            byteBuffer = TextureUtil.readResource(readablebytechannel, 8192);
        }
        return byteBuffer;
    }

    private static ByteBuffer readResource(ReadableByteChannel p_273208_, int p_273297_) throws IOException {
        ByteBuffer bytebuffer = MemoryUtil.memAlloc((int)p_273297_);
        try {
            while (p_273208_.read(bytebuffer) != -1) {
                if (bytebuffer.hasRemaining()) continue;
                bytebuffer = MemoryUtil.memRealloc((ByteBuffer)bytebuffer, (int)(bytebuffer.capacity() * 2));
            }
            return bytebuffer;
        }
        catch (IOException ioexception) {
            MemoryUtil.memFree((Buffer)bytebuffer);
            throw ioexception;
        }
    }

    public static void writeAsPNG(Path p_285286_, String p_285408_, GpuTexture p_406229_, int p_285400_, IntUnaryOperator p_284988_) {
        RenderSystem.assertOnRenderThread();
        int i = 0;
        for (int j = 0; j <= p_285400_; ++j) {
            i += p_406229_.getFormat().pixelSize() * p_406229_.getWidth(j) * p_406229_.getHeight(j);
        }
        GpuBuffer gpubuffer = RenderSystem.getDevice().createBuffer(() -> "Texture output buffer", 9, i);
        CommandEncoder commandencoder = RenderSystem.getDevice().createCommandEncoder();
        Runnable runnable = () -> {
            try (GpuBuffer.MappedView gpubuffer$mappedview = commandencoder.mapBuffer(gpubuffer, true, false);){
                int i1 = 0;
                for (int j1 = 0; j1 <= p_285400_; ++j1) {
                    int k1 = p_406229_.getWidth(j1);
                    int l1 = p_406229_.getHeight(j1);
                    try (NativeImage nativeimage = new NativeImage(k1, l1, false);){
                        for (int i2 = 0; i2 < l1; ++i2) {
                            for (int j2 = 0; j2 < k1; ++j2) {
                                int k2 = gpubuffer$mappedview.data().getInt(i1 + (j2 + i2 * k1) * p_406229_.getFormat().pixelSize());
                                nativeimage.setPixelABGR(j2, i2, p_284988_.applyAsInt(k2));
                            }
                        }
                        Path path = p_285286_.resolve(p_285408_ + "_" + j1 + ".png");
                        nativeimage.writeToFile(path);
                        LOGGER.debug("Exported png to: {}", (Object)path.toAbsolutePath());
                    }
                    catch (IOException ioexception) {
                        LOGGER.debug("Unable to write: ", (Throwable)ioexception);
                    }
                    i1 += p_406229_.getFormat().pixelSize() * k1 * l1;
                }
            }
            gpubuffer.close();
        };
        AtomicInteger atomicinteger = new AtomicInteger();
        int k = 0;
        for (int l = 0; l <= p_285400_; ++l) {
            commandencoder.copyTextureToBuffer(p_406229_, gpubuffer, k, () -> {
                if (atomicinteger.getAndIncrement() == p_285400_) {
                    runnable.run();
                }
            }, l);
            k += p_406229_.getFormat().pixelSize() * p_406229_.getWidth(l) * p_406229_.getHeight(l);
        }
    }

    public static Path getDebugTexturePath(Path p_262015_) {
        return p_262015_.resolve("screenshots").resolve("debug");
    }

    public static Path getDebugTexturePath() {
        return TextureUtil.getDebugTexturePath(Path.of(".", new String[0]));
    }
}

