/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.buffers.Std140SizeCalculator;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryStack;

@OnlyIn(value=Dist.CLIENT)
public class Lighting
implements AutoCloseable {
    private static final Vector3f DIFFUSE_LIGHT_0 = new Vector3f(0.2f, 1.0f, -0.7f).normalize();
    private static final Vector3f DIFFUSE_LIGHT_1 = new Vector3f(-0.2f, 1.0f, 0.7f).normalize();
    private static final Vector3f NETHER_DIFFUSE_LIGHT_0 = new Vector3f(0.2f, 1.0f, -0.7f).normalize();
    private static final Vector3f NETHER_DIFFUSE_LIGHT_1 = new Vector3f(-0.2f, -1.0f, 0.7f).normalize();
    private static final Vector3f INVENTORY_DIFFUSE_LIGHT_0 = new Vector3f(0.2f, -1.0f, 1.0f).normalize();
    private static final Vector3f INVENTORY_DIFFUSE_LIGHT_1 = new Vector3f(-0.2f, -1.0f, 0.0f).normalize();
    public static final int UBO_SIZE = new Std140SizeCalculator().putVec3().putVec3().get();
    private final GpuBuffer buffer;
    private final int paddedSize;

    public Lighting() {
        GpuDevice gpudevice = RenderSystem.getDevice();
        this.paddedSize = Mth.roundToward(UBO_SIZE, gpudevice.getUniformOffsetAlignment());
        this.buffer = gpudevice.createBuffer(() -> "Lighting UBO", 136, this.paddedSize * Entry.values().length);
        Matrix4f matrix4f = new Matrix4f().rotationY(-0.3926991f).rotateX(2.3561945f);
        this.updateBuffer(Entry.ITEMS_FLAT, matrix4f.transformDirection((Vector3fc)DIFFUSE_LIGHT_0, new Vector3f()), matrix4f.transformDirection((Vector3fc)DIFFUSE_LIGHT_1, new Vector3f()));
        Matrix4f matrix4f1 = new Matrix4f().scaling(1.0f, -1.0f, 1.0f).rotateYXZ(1.0821041f, 3.2375858f, 0.0f).rotateYXZ(-0.3926991f, 2.3561945f, 0.0f);
        this.updateBuffer(Entry.ITEMS_3D, matrix4f1.transformDirection((Vector3fc)DIFFUSE_LIGHT_0, new Vector3f()), matrix4f1.transformDirection((Vector3fc)DIFFUSE_LIGHT_1, new Vector3f()));
        this.updateBuffer(Entry.ENTITY_IN_UI, INVENTORY_DIFFUSE_LIGHT_0, INVENTORY_DIFFUSE_LIGHT_1);
        Matrix4f matrix4f2 = new Matrix4f();
        this.updateBuffer(Entry.PLAYER_SKIN, matrix4f2.transformDirection((Vector3fc)INVENTORY_DIFFUSE_LIGHT_0, new Vector3f()), matrix4f2.transformDirection((Vector3fc)INVENTORY_DIFFUSE_LIGHT_1, new Vector3f()));
    }

    public void updateLevel(boolean p_418395_) {
        if (p_418395_) {
            this.updateBuffer(Entry.LEVEL, NETHER_DIFFUSE_LIGHT_0, NETHER_DIFFUSE_LIGHT_1);
        } else {
            this.updateBuffer(Entry.LEVEL, DIFFUSE_LIGHT_0, DIFFUSE_LIGHT_1);
        }
    }

    private void updateBuffer(Entry p_418264_, Vector3f p_418385_, Vector3f p_418228_) {
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = Std140Builder.onStack(memorystack, UBO_SIZE).putVec3((Vector3fc)p_418385_).putVec3((Vector3fc)p_418228_).get();
            RenderSystem.getDevice().createCommandEncoder().writeToBuffer(this.buffer.slice(p_418264_.ordinal() * this.paddedSize, this.paddedSize), bytebuffer);
        }
    }

    public void setupFor(Entry p_418275_) {
        RenderSystem.setShaderLights(this.buffer.slice(p_418275_.ordinal() * this.paddedSize, UBO_SIZE));
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Entry {
        LEVEL,
        ITEMS_FLAT,
        ITEMS_3D,
        ENTITY_IN_UI,
        PLAYER_SKIN;

    }
}

