/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.opengl;

import com.google.common.base.Charsets;
import com.mojang.blaze3d.DontObfuscate;
import com.mojang.blaze3d.platform.MacosUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.jtracy.Plot;
import com.mojang.jtracy.TracyClient;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL32;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@OnlyIn(value=Dist.CLIENT)
@DontObfuscate
public class GlStateManager {
    private static final boolean ON_LINUX = Util.getPlatform() == Util.OS.LINUX;
    private static final Plot PLOT_TEXTURES = TracyClient.createPlot((String)"GPU Textures");
    private static int numTextures = 0;
    private static final Plot PLOT_BUFFERS = TracyClient.createPlot((String)"GPU Buffers");
    private static int numBuffers = 0;
    private static final BlendState BLEND = new BlendState();
    private static final DepthState DEPTH = new DepthState();
    private static final CullState CULL = new CullState();
    private static final PolygonOffsetState POLY_OFFSET = new PolygonOffsetState();
    private static final ColorLogicState COLOR_LOGIC = new ColorLogicState();
    private static final StencilState STENCIL = new StencilState();
    private static final ScissorState SCISSOR = new ScissorState();
    private static int activeTexture;
    private static final TextureState[] TEXTURES;
    private static final ColorMask COLOR_MASK;
    private static int readFbo;
    private static int writeFbo;

    public static void _disableScissorTest() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.SCISSOR.mode.disable();
    }

    public static void _enableScissorTest() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.SCISSOR.mode.enable();
    }

    public static void _scissorBox(int p_412544_, int p_412671_, int p_412434_, int p_412223_) {
        RenderSystem.assertOnRenderThread();
        GL20.glScissor((int)p_412544_, (int)p_412671_, (int)p_412434_, (int)p_412223_);
    }

    public static void _disableDepthTest() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.DEPTH.mode.disable();
    }

    public static void _enableDepthTest() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.DEPTH.mode.enable();
    }

    public static void _depthFunc(int p_412390_) {
        RenderSystem.assertOnRenderThread();
        if (p_412390_ != GlStateManager.DEPTH.func) {
            GlStateManager.DEPTH.func = p_412390_;
            GL11.glDepthFunc((int)p_412390_);
        }
    }

    public static void _depthMask(boolean p_412682_) {
        RenderSystem.assertOnRenderThread();
        if (p_412682_ != GlStateManager.DEPTH.mask) {
            GlStateManager.DEPTH.mask = p_412682_;
            GL11.glDepthMask((boolean)p_412682_);
        }
    }

    public static void _disableBlend() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.BLEND.mode.disable();
    }

    public static void _enableBlend() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.BLEND.mode.enable();
    }

    public static void _blendFuncSeparate(int p_412261_, int p_412664_, int p_412076_, int p_412367_) {
        RenderSystem.assertOnRenderThread();
        if (p_412261_ != GlStateManager.BLEND.srcRgb || p_412664_ != GlStateManager.BLEND.dstRgb || p_412076_ != GlStateManager.BLEND.srcAlpha || p_412367_ != GlStateManager.BLEND.dstAlpha) {
            GlStateManager.BLEND.srcRgb = p_412261_;
            GlStateManager.BLEND.dstRgb = p_412664_;
            GlStateManager.BLEND.srcAlpha = p_412076_;
            GlStateManager.BLEND.dstAlpha = p_412367_;
            GlStateManager.glBlendFuncSeparate(p_412261_, p_412664_, p_412076_, p_412367_);
        }
    }

    public static int glGetProgrami(int p_412785_, int p_412182_) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetProgrami((int)p_412785_, (int)p_412182_);
    }

    public static void glAttachShader(int p_412381_, int p_412166_) {
        RenderSystem.assertOnRenderThread();
        GL20.glAttachShader((int)p_412381_, (int)p_412166_);
    }

    public static void glDeleteShader(int p_412373_) {
        RenderSystem.assertOnRenderThread();
        GL20.glDeleteShader((int)p_412373_);
    }

    public static int glCreateShader(int p_412529_) {
        RenderSystem.assertOnRenderThread();
        return GL20.glCreateShader((int)p_412529_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSource(int p_412070_, String p_412719_) {
        RenderSystem.assertOnRenderThread();
        byte[] abyte = p_412719_.getBytes(Charsets.UTF_8);
        ByteBuffer bytebuffer = MemoryUtil.memAlloc((int)(abyte.length + 1));
        bytebuffer.put(abyte);
        bytebuffer.put((byte)0);
        bytebuffer.flip();
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            PointerBuffer pointerbuffer = memorystack.mallocPointer(1);
            pointerbuffer.put(bytebuffer);
            GL20C.nglShaderSource((int)p_412070_, (int)1, (long)pointerbuffer.address0(), (long)0L);
        }
        finally {
            MemoryUtil.memFree((Buffer)bytebuffer);
        }
    }

    public static void glCompileShader(int p_412483_) {
        RenderSystem.assertOnRenderThread();
        GL20.glCompileShader((int)p_412483_);
    }

    public static int glGetShaderi(int p_412274_, int p_412320_) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetShaderi((int)p_412274_, (int)p_412320_);
    }

    public static void _glUseProgram(int p_412686_) {
        RenderSystem.assertOnRenderThread();
        GL20.glUseProgram((int)p_412686_);
    }

    public static int glCreateProgram() {
        RenderSystem.assertOnRenderThread();
        return GL20.glCreateProgram();
    }

    public static void glDeleteProgram(int p_412461_) {
        RenderSystem.assertOnRenderThread();
        GL20.glDeleteProgram((int)p_412461_);
    }

    public static void glLinkProgram(int p_412342_) {
        RenderSystem.assertOnRenderThread();
        GL20.glLinkProgram((int)p_412342_);
    }

    public static int _glGetUniformLocation(int p_412693_, CharSequence p_412767_) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetUniformLocation((int)p_412693_, (CharSequence)p_412767_);
    }

    public static void _glUniform1(int p_412745_, IntBuffer p_412781_) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform1iv((int)p_412745_, (IntBuffer)p_412781_);
    }

    public static void _glUniform1i(int p_412109_, int p_412740_) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform1i((int)p_412109_, (int)p_412740_);
    }

    public static void _glUniform1(int p_412157_, FloatBuffer p_412479_) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform1fv((int)p_412157_, (FloatBuffer)p_412479_);
    }

    public static void _glUniform2(int p_412186_, FloatBuffer p_412695_) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform2fv((int)p_412186_, (FloatBuffer)p_412695_);
    }

    public static void _glUniform3(int p_412302_, IntBuffer p_412623_) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform3iv((int)p_412302_, (IntBuffer)p_412623_);
    }

    public static void _glUniform3(int p_412156_, FloatBuffer p_412202_) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform3fv((int)p_412156_, (FloatBuffer)p_412202_);
    }

    public static void _glUniform4(int p_412399_, FloatBuffer p_412778_) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform4fv((int)p_412399_, (FloatBuffer)p_412778_);
    }

    public static void _glUniformMatrix4(int p_412478_, FloatBuffer p_412526_) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniformMatrix4fv((int)p_412478_, (boolean)false, (FloatBuffer)p_412526_);
    }

    public static void _glBindAttribLocation(int p_412646_, int p_412124_, CharSequence p_412306_) {
        RenderSystem.assertOnRenderThread();
        GL20.glBindAttribLocation((int)p_412646_, (int)p_412124_, (CharSequence)p_412306_);
    }

    public static int _glGenBuffers() {
        RenderSystem.assertOnRenderThread();
        PLOT_BUFFERS.setValue((double)(++numBuffers));
        return GL15.glGenBuffers();
    }

    public static int _glGenVertexArrays() {
        RenderSystem.assertOnRenderThread();
        return GL30.glGenVertexArrays();
    }

    public static void _glBindBuffer(int p_412674_, int p_412428_) {
        RenderSystem.assertOnRenderThread();
        GL15.glBindBuffer((int)p_412674_, (int)p_412428_);
    }

    public static void _glBindVertexArray(int p_412659_) {
        RenderSystem.assertOnRenderThread();
        GL30.glBindVertexArray((int)p_412659_);
    }

    public static void _glBufferData(int p_412508_, ByteBuffer p_412262_, int p_412282_) {
        RenderSystem.assertOnRenderThread();
        GL15.glBufferData((int)p_412508_, (ByteBuffer)p_412262_, (int)p_412282_);
    }

    public static void _glBufferSubData(int p_412190_, int p_412618_, ByteBuffer p_412299_) {
        RenderSystem.assertOnRenderThread();
        GL15.glBufferSubData((int)p_412190_, (long)p_412618_, (ByteBuffer)p_412299_);
    }

    public static void _glBufferData(int p_412471_, long p_412328_, int p_412602_) {
        RenderSystem.assertOnRenderThread();
        GL15.glBufferData((int)p_412471_, (long)p_412328_, (int)p_412602_);
    }

    @Nullable
    public static ByteBuffer _glMapBufferRange(int p_412389_, int p_412504_, int p_412509_, int p_412275_) {
        RenderSystem.assertOnRenderThread();
        return GL30.glMapBufferRange((int)p_412389_, (long)p_412504_, (long)p_412509_, (int)p_412275_);
    }

    public static void _glUnmapBuffer(int p_412042_) {
        RenderSystem.assertOnRenderThread();
        GL15.glUnmapBuffer((int)p_412042_);
    }

    public static void _glDeleteBuffers(int p_412311_) {
        RenderSystem.assertOnRenderThread();
        PLOT_BUFFERS.setValue((double)(--numBuffers));
        GL15.glDeleteBuffers((int)p_412311_);
    }

    public static void _glBindFramebuffer(int p_412624_, int p_412635_) {
        if ((p_412624_ == 36008 || p_412624_ == 36160) && readFbo != p_412635_) {
            GL30.glBindFramebuffer((int)36008, (int)p_412635_);
            readFbo = p_412635_;
        }
        if ((p_412624_ == 36009 || p_412624_ == 36160) && writeFbo != p_412635_) {
            GL30.glBindFramebuffer((int)36009, (int)p_412635_);
            writeFbo = p_412635_;
        }
    }

    public static int getFrameBuffer(int p_412720_) {
        if (p_412720_ == 36008) {
            return readFbo;
        }
        return p_412720_ == 36009 ? writeFbo : 0;
    }

    public static void _glBlitFrameBuffer(int p_412319_, int p_412052_, int p_412080_, int p_412580_, int p_412560_, int p_412565_, int p_412724_, int p_412575_, int p_412505_, int p_412309_) {
        RenderSystem.assertOnRenderThread();
        GL30.glBlitFramebuffer((int)p_412319_, (int)p_412052_, (int)p_412080_, (int)p_412580_, (int)p_412560_, (int)p_412565_, (int)p_412724_, (int)p_412575_, (int)p_412505_, (int)p_412309_);
    }

    public static void _glDeleteFramebuffers(int p_412563_) {
        RenderSystem.assertOnRenderThread();
        GL30.glDeleteFramebuffers((int)p_412563_);
    }

    public static int glGenFramebuffers() {
        RenderSystem.assertOnRenderThread();
        return GL30.glGenFramebuffers();
    }

    public static void _glFramebufferTexture2D(int p_412121_, int p_412761_, int p_412688_, int p_412161_, int p_412731_) {
        RenderSystem.assertOnRenderThread();
        GL30.glFramebufferTexture2D((int)p_412121_, (int)p_412761_, (int)p_412688_, (int)p_412161_, (int)p_412731_);
    }

    public static void glActiveTexture(int p_412764_) {
        RenderSystem.assertOnRenderThread();
        GL13.glActiveTexture((int)p_412764_);
    }

    public static void glBlendFuncSeparate(int p_412333_, int p_412425_, int p_412352_, int p_412353_) {
        RenderSystem.assertOnRenderThread();
        GL14.glBlendFuncSeparate((int)p_412333_, (int)p_412425_, (int)p_412352_, (int)p_412353_);
    }

    public static String glGetShaderInfoLog(int p_412120_, int p_412078_) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetShaderInfoLog((int)p_412120_, (int)p_412078_);
    }

    public static String glGetProgramInfoLog(int p_412598_, int p_412472_) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetProgramInfoLog((int)p_412598_, (int)p_412472_);
    }

    public static void _enableCull() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.CULL.enable.enable();
    }

    public static void _disableCull() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.CULL.enable.disable();
    }

    public static void _polygonMode(int p_412155_, int p_412317_) {
        RenderSystem.assertOnRenderThread();
        GL11.glPolygonMode((int)p_412155_, (int)p_412317_);
    }

    public static void _enablePolygonOffset() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.POLY_OFFSET.fill.enable();
    }

    public static void _disablePolygonOffset() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.POLY_OFFSET.fill.disable();
    }

    public static void _polygonOffset(float p_412343_, float p_412604_) {
        RenderSystem.assertOnRenderThread();
        if (p_412343_ != GlStateManager.POLY_OFFSET.factor || p_412604_ != GlStateManager.POLY_OFFSET.units) {
            GlStateManager.POLY_OFFSET.factor = p_412343_;
            GlStateManager.POLY_OFFSET.units = p_412604_;
            GL11.glPolygonOffset((float)p_412343_, (float)p_412604_);
        }
    }

    public static void _enableColorLogicOp() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.COLOR_LOGIC.enable.enable();
    }

    public static void _disableColorLogicOp() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.COLOR_LOGIC.enable.disable();
    }

    public static void _logicOp(int p_412555_) {
        RenderSystem.assertOnRenderThread();
        if (p_412555_ != GlStateManager.COLOR_LOGIC.op) {
            GlStateManager.COLOR_LOGIC.op = p_412555_;
            GL11.glLogicOp((int)p_412555_);
        }
    }

    public static void _activeTexture(int p_412206_) {
        RenderSystem.assertOnRenderThread();
        if (activeTexture != p_412206_ - 33984) {
            activeTexture = p_412206_ - 33984;
            GlStateManager.glActiveTexture(p_412206_);
        }
    }

    public static void _texParameter(int p_412413_, int p_412226_, int p_412243_) {
        RenderSystem.assertOnRenderThread();
        GL11.glTexParameteri((int)p_412413_, (int)p_412226_, (int)p_412243_);
    }

    public static int _getTexLevelParameter(int p_412349_, int p_412379_, int p_412747_) {
        return GL11.glGetTexLevelParameteri((int)p_412349_, (int)p_412379_, (int)p_412747_);
    }

    public static int _genTexture() {
        RenderSystem.assertOnRenderThread();
        PLOT_TEXTURES.setValue((double)(++numTextures));
        return GL11.glGenTextures();
    }

    public static void _deleteTexture(int p_412766_) {
        RenderSystem.assertOnRenderThread();
        GL11.glDeleteTextures((int)p_412766_);
        for (TextureState glstatemanager$texturestate : TEXTURES) {
            if (glstatemanager$texturestate.binding != p_412766_) continue;
            glstatemanager$texturestate.binding = -1;
        }
        PLOT_TEXTURES.setValue((double)(--numTextures));
    }

    public static void _bindTexture(int p_412384_) {
        RenderSystem.assertOnRenderThread();
        if (p_412384_ != GlStateManager.TEXTURES[GlStateManager.activeTexture].binding) {
            GlStateManager.TEXTURES[GlStateManager.activeTexture].binding = p_412384_;
            GL11.glBindTexture((int)3553, (int)p_412384_);
        }
    }

    public static int _getActiveTexture() {
        return activeTexture + 33984;
    }

    public static void _texImage2D(int p_412310_, int p_412419_, int p_412630_, int p_412350_, int p_412242_, int p_412290_, int p_412363_, int p_412035_, @Nullable IntBuffer p_412583_) {
        RenderSystem.assertOnRenderThread();
        GL11.glTexImage2D((int)p_412310_, (int)p_412419_, (int)p_412630_, (int)p_412350_, (int)p_412242_, (int)p_412290_, (int)p_412363_, (int)p_412035_, (IntBuffer)p_412583_);
    }

    public static void _texSubImage2D(int p_412334_, int p_412330_, int p_412661_, int p_412280_, int p_412301_, int p_412313_, int p_412612_, int p_412158_, long p_412094_) {
        RenderSystem.assertOnRenderThread();
        GL11.glTexSubImage2D((int)p_412334_, (int)p_412330_, (int)p_412661_, (int)p_412280_, (int)p_412301_, (int)p_412313_, (int)p_412612_, (int)p_412158_, (long)p_412094_);
    }

    public static void _texSubImage2D(int p_412117_, int p_412548_, int p_412368_, int p_412679_, int p_412432_, int p_412239_, int p_412198_, int p_412304_, IntBuffer p_412510_) {
        RenderSystem.assertOnRenderThread();
        GL11.glTexSubImage2D((int)p_412117_, (int)p_412548_, (int)p_412368_, (int)p_412679_, (int)p_412432_, (int)p_412239_, (int)p_412198_, (int)p_412304_, (IntBuffer)p_412510_);
    }

    public static void _viewport(int p_412768_, int p_412268_, int p_412374_, int p_412660_) {
        GL11.glViewport((int)p_412768_, (int)p_412268_, (int)p_412374_, (int)p_412660_);
    }

    public static void _colorMask(boolean p_412534_, boolean p_412706_, boolean p_412187_, boolean p_412294_) {
        RenderSystem.assertOnRenderThread();
        if (p_412534_ != GlStateManager.COLOR_MASK.red || p_412706_ != GlStateManager.COLOR_MASK.green || p_412187_ != GlStateManager.COLOR_MASK.blue || p_412294_ != GlStateManager.COLOR_MASK.alpha) {
            GlStateManager.COLOR_MASK.red = p_412534_;
            GlStateManager.COLOR_MASK.green = p_412706_;
            GlStateManager.COLOR_MASK.blue = p_412187_;
            GlStateManager.COLOR_MASK.alpha = p_412294_;
            GL11.glColorMask((boolean)p_412534_, (boolean)p_412706_, (boolean)p_412187_, (boolean)p_412294_);
        }
    }

    public static void _clear(int p_412293_) {
        RenderSystem.assertOnRenderThread();
        GL11.glClear((int)p_412293_);
        if (MacosUtil.IS_MACOS) {
            GlStateManager._getError();
        }
    }

    public static void _vertexAttribPointer(int p_412619_, int p_412089_, int p_412208_, boolean p_412687_, int p_412716_, long p_412347_) {
        RenderSystem.assertOnRenderThread();
        GL20.glVertexAttribPointer((int)p_412619_, (int)p_412089_, (int)p_412208_, (boolean)p_412687_, (int)p_412716_, (long)p_412347_);
    }

    public static void _vertexAttribIPointer(int p_412449_, int p_412145_, int p_412344_, int p_412169_, long p_412325_) {
        RenderSystem.assertOnRenderThread();
        GL30.glVertexAttribIPointer((int)p_412449_, (int)p_412145_, (int)p_412344_, (int)p_412169_, (long)p_412325_);
    }

    public static void _enableVertexAttribArray(int p_412609_) {
        RenderSystem.assertOnRenderThread();
        GL20.glEnableVertexAttribArray((int)p_412609_);
    }

    public static void _drawElements(int p_412772_, int p_412151_, int p_412245_, long p_412484_) {
        RenderSystem.assertOnRenderThread();
        GL11.glDrawElements((int)p_412772_, (int)p_412151_, (int)p_412245_, (long)p_412484_);
    }

    public static void _drawArrays(int p_412383_, int p_412165_, int p_412633_) {
        RenderSystem.assertOnRenderThread();
        GL11.glDrawArrays((int)p_412383_, (int)p_412165_, (int)p_412633_);
    }

    public static void _pixelStore(int p_412183_, int p_412338_) {
        RenderSystem.assertOnRenderThread();
        GL11.glPixelStorei((int)p_412183_, (int)p_412338_);
    }

    public static void _readPixels(int p_412385_, int p_412288_, int p_412300_, int p_412743_, int p_412722_, int p_412758_, long p_412203_) {
        RenderSystem.assertOnRenderThread();
        GL11.glReadPixels((int)p_412385_, (int)p_412288_, (int)p_412300_, (int)p_412743_, (int)p_412722_, (int)p_412758_, (long)p_412203_);
    }

    public static int _getError() {
        RenderSystem.assertOnRenderThread();
        return GL11.glGetError();
    }

    public static void clearGlErrors() {
        RenderSystem.assertOnRenderThread();
        while (GL11.glGetError() != 0) {
        }
    }

    public static String _getString(int p_412524_) {
        RenderSystem.assertOnRenderThread();
        return GL11.glGetString((int)p_412524_);
    }

    public static int _getInteger(int p_412627_) {
        RenderSystem.assertOnRenderThread();
        return GL11.glGetInteger((int)p_412627_);
    }

    public static long _glFenceSync(int p_412755_, int p_412391_) {
        RenderSystem.assertOnRenderThread();
        return GL32.glFenceSync((int)p_412755_, (int)p_412391_);
    }

    public static int _glClientWaitSync(long p_412773_, int p_412625_, long p_412397_) {
        RenderSystem.assertOnRenderThread();
        return GL32.glClientWaitSync((long)p_412773_, (int)p_412625_, (long)p_412397_);
    }

    public static void _glDeleteSync(long p_412289_) {
        RenderSystem.assertOnRenderThread();
        GL32.glDeleteSync((long)p_412289_);
    }

    public static void _disableStencilTest() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.STENCIL.mode.disable();
    }

    public static void _enableStencilTest() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.STENCIL.mode.enable();
    }

    public static void _stencilFunc(int func, int ref, int readMask) {
        RenderSystem.assertOnRenderThread();
        if (func != GlStateManager.STENCIL.frontFunc || ref != GlStateManager.STENCIL.frontRef || readMask != GlStateManager.STENCIL.frontReadMask || func != GlStateManager.STENCIL.backFunc || ref != GlStateManager.STENCIL.backRef || readMask != GlStateManager.STENCIL.backReadMask) {
            GlStateManager.STENCIL.frontFunc = func;
            GlStateManager.STENCIL.frontRef = ref;
            GlStateManager.STENCIL.frontReadMask = readMask;
            GlStateManager.STENCIL.backFunc = func;
            GlStateManager.STENCIL.backRef = ref;
            GlStateManager.STENCIL.backReadMask = readMask;
            GL32.glStencilFuncSeparate((int)1032, (int)func, (int)ref, (int)readMask);
        }
    }

    public static void _stencilFuncFront(int func, int ref, int readMask) {
        RenderSystem.assertOnRenderThread();
        if (func != GlStateManager.STENCIL.frontFunc || ref != GlStateManager.STENCIL.frontRef || readMask != GlStateManager.STENCIL.frontReadMask) {
            GlStateManager.STENCIL.frontFunc = func;
            GlStateManager.STENCIL.frontRef = ref;
            GlStateManager.STENCIL.frontReadMask = readMask;
            GL32.glStencilFuncSeparate((int)1028, (int)func, (int)ref, (int)readMask);
        }
    }

    public static void _stencilFuncBack(int func, int ref, int readMask) {
        RenderSystem.assertOnRenderThread();
        if (func != GlStateManager.STENCIL.backFunc || ref != GlStateManager.STENCIL.backRef || readMask != GlStateManager.STENCIL.backReadMask) {
            GlStateManager.STENCIL.backFunc = func;
            GlStateManager.STENCIL.backRef = ref;
            GlStateManager.STENCIL.backReadMask = readMask;
            GL32.glStencilFuncSeparate((int)1029, (int)func, (int)ref, (int)readMask);
        }
    }

    public static void _stencilMask(int mask) {
        RenderSystem.assertOnRenderThread();
        if (mask != GlStateManager.STENCIL.writeMask) {
            GlStateManager.STENCIL.writeMask = mask;
            GL11.glStencilMask((int)mask);
        }
    }

    public static void _stencilOp(int stencilFail, int depthFail, int pass) {
        RenderSystem.assertOnRenderThread();
        if (stencilFail != GlStateManager.STENCIL.frontStencilFail || depthFail != GlStateManager.STENCIL.frontDepthFail || pass != GlStateManager.STENCIL.frontPass || stencilFail != GlStateManager.STENCIL.backStencilFail || depthFail != GlStateManager.STENCIL.backDepthFail || pass != GlStateManager.STENCIL.backPass) {
            GlStateManager.STENCIL.frontStencilFail = stencilFail;
            GlStateManager.STENCIL.frontDepthFail = depthFail;
            GlStateManager.STENCIL.frontPass = pass;
            GlStateManager.STENCIL.backStencilFail = stencilFail;
            GlStateManager.STENCIL.backDepthFail = depthFail;
            GlStateManager.STENCIL.backPass = pass;
            GL32.glStencilOpSeparate((int)1032, (int)stencilFail, (int)depthFail, (int)pass);
        }
    }

    public static void _stencilOpFront(int stencilFail, int depthFail, int pass) {
        RenderSystem.assertOnRenderThread();
        if (stencilFail != GlStateManager.STENCIL.frontStencilFail || depthFail != GlStateManager.STENCIL.frontDepthFail || pass != GlStateManager.STENCIL.frontPass) {
            GlStateManager.STENCIL.frontStencilFail = stencilFail;
            GlStateManager.STENCIL.frontDepthFail = depthFail;
            GlStateManager.STENCIL.frontPass = pass;
            GL32.glStencilOpSeparate((int)1028, (int)stencilFail, (int)depthFail, (int)pass);
        }
    }

    public static void _stencilOpBack(int stencilFail, int depthFail, int pass) {
        RenderSystem.assertOnRenderThread();
        if (stencilFail != GlStateManager.STENCIL.backStencilFail || depthFail != GlStateManager.STENCIL.backDepthFail || pass != GlStateManager.STENCIL.backPass) {
            GlStateManager.STENCIL.backStencilFail = stencilFail;
            GlStateManager.STENCIL.backDepthFail = depthFail;
            GlStateManager.STENCIL.backPass = pass;
            GL32.glStencilOpSeparate((int)1029, (int)stencilFail, (int)depthFail, (int)pass);
        }
    }

    static {
        TEXTURES = (TextureState[])IntStream.range(0, 12).mapToObj(p_412448_ -> new TextureState()).toArray(TextureState[]::new);
        COLOR_MASK = new ColorMask();
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ScissorState {
        public final BooleanState mode = new BooleanState(3089);

        ScissorState() {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class BooleanState {
        private final int state;
        private boolean enabled;

        public BooleanState(int p_412087_) {
            this.state = p_412087_;
        }

        public void disable() {
            this.setEnabled(false);
        }

        public void enable() {
            this.setEnabled(true);
        }

        public void setEnabled(boolean p_412132_) {
            RenderSystem.assertOnRenderThread();
            if (p_412132_ != this.enabled) {
                this.enabled = p_412132_;
                if (p_412132_) {
                    GL11.glEnable((int)this.state);
                } else {
                    GL11.glDisable((int)this.state);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class DepthState {
        public final BooleanState mode = new BooleanState(2929);
        public boolean mask = true;
        public int func = 513;

        DepthState() {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class BlendState {
        public final BooleanState mode = new BooleanState(3042);
        public int srcRgb = 1;
        public int dstRgb = 0;
        public int srcAlpha = 1;
        public int dstAlpha = 0;

        BlendState() {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class CullState {
        public final BooleanState enable = new BooleanState(2884);

        CullState() {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class PolygonOffsetState {
        public final BooleanState fill = new BooleanState(32823);
        public float factor;
        public float units;

        PolygonOffsetState() {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ColorLogicState {
        public final BooleanState enable = new BooleanState(3058);
        public int op = 5379;

        ColorLogicState() {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class TextureState {
        public int binding;

        TextureState() {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ColorMask {
        public boolean red = true;
        public boolean green = true;
        public boolean blue = true;
        public boolean alpha = true;

        ColorMask() {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class StencilState {
        public final BooleanState mode = new BooleanState(2960);
        public int frontFunc = 519;
        public int frontRef;
        public int frontReadMask = -1;
        public int backFunc = 519;
        public int backRef;
        public int backReadMask = -1;
        public int writeMask = -1;
        public int frontStencilFail = 7680;
        public int frontDepthFail = 7680;
        public int frontPass = 7680;
        public int backStencilFail = 7680;
        public int backDepthFail = 7680;
        public int backPass = 7680;

        StencilState() {
        }
    }
}

