/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.opengl;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.opengl.GlShaderModule;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.Uniform;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.shaders.UniformType;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ShaderManager;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.VisibleForTesting;
import org.lwjgl.opengl.GL31;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class GlProgram
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static Set<String> BUILT_IN_UNIFORMS = Sets.newHashSet((Object[])new String[]{"Projection", "Lighting", "Fog", "Globals"});
    public static GlProgram INVALID_PROGRAM = new GlProgram(-1, "invalid");
    private final Map<String, Uniform> uniformsByName = new HashMap<String, Uniform>();
    private final int programId;
    private final String debugLabel;

    private GlProgram(int p_409955_, String p_410322_) {
        this.programId = p_409955_;
        this.debugLabel = p_410322_;
    }

    public static GlProgram link(GlShaderModule p_410427_, GlShaderModule p_409637_, VertexFormat p_410009_, String p_410384_) throws ShaderManager.CompilationException {
        int i = GlStateManager.glCreateProgram();
        if (i <= 0) {
            throw new ShaderManager.CompilationException("Could not create shader program (returned program ID " + i + ")");
        }
        int j = 0;
        for (String s : p_410009_.getElementAttributeNames()) {
            GlStateManager._glBindAttribLocation(i, j, s);
            ++j;
        }
        GlStateManager.glAttachShader(i, p_410427_.getShaderId());
        GlStateManager.glAttachShader(i, p_409637_.getShaderId());
        GlStateManager.glLinkProgram(i);
        int k = GlStateManager.glGetProgrami(i, 35714);
        String s1 = GlStateManager.glGetProgramInfoLog(i, 32768);
        if (k != 0 && !s1.contains("Failed for unknown reason")) {
            if (!s1.isEmpty()) {
                LOGGER.info("Info log when linking program containing VS {} and FS {}. Log output: {}", new Object[]{p_410427_.getId(), p_409637_.getId(), s1});
            }
            return new GlProgram(i, p_410384_);
        }
        throw new ShaderManager.CompilationException("Error encountered when linking program containing VS " + String.valueOf(p_410427_.getId()) + " and FS " + String.valueOf(p_409637_.getId()) + ". Log output: " + s1);
    }

    public void setupUniforms(List<RenderPipeline.UniformDescription> p_410553_, List<String> p_410038_) {
        int i = 0;
        int j = 0;
        for (RenderPipeline.UniformDescription renderpipeline$uniformdescription : p_410553_) {
            Uniform.Utb object;
            Uniform uniform;
            String s = renderpipeline$uniformdescription.name();
            if ((uniform = (Uniform)(object = (switch (renderpipeline$uniformdescription.type()) {
                default -> throw new MatchException(null, null);
                case UniformType.UNIFORM_BUFFER -> {
                    int j2 = GL31.glGetUniformBlockIndex((int)this.programId, (CharSequence)s);
                    if (j2 == -1) {
                        yield null;
                    }
                    int k2 = i++;
                    GL31.glUniformBlockBinding((int)this.programId, (int)j2, (int)k2);
                    yield new Uniform.Ubo(k2);
                }
                case UniformType.TEXEL_BUFFER -> {
                    int k = GlStateManager._glGetUniformLocation(this.programId, s);
                    if (k == -1) {
                        LOGGER.warn("{} shader program does not use utb {} defined in the pipeline. This might be a bug.", (Object)this.debugLabel, (Object)s);
                        yield null;
                    }
                    int l = j++;
                    yield new Uniform.Utb(k, l, Objects.requireNonNull(renderpipeline$uniformdescription.textureFormat()));
                }
            }))) == null) continue;
            this.uniformsByName.put(s, uniform);
        }
        for (String s1 : p_410038_) {
            int k1 = GlStateManager._glGetUniformLocation(this.programId, s1);
            if (k1 == -1) {
                LOGGER.warn("{} shader program does not use sampler {} defined in the pipeline. This might be a bug.", (Object)this.debugLabel, (Object)s1);
                continue;
            }
            int l1 = j++;
            this.uniformsByName.put(s1, new Uniform.Sampler(k1, l1));
        }
        int i1 = GlStateManager.glGetProgrami(this.programId, 35382);
        for (int j1 = 0; j1 < i1; ++j1) {
            String s2 = GL31.glGetActiveUniformBlockName((int)this.programId, (int)j1);
            if (this.uniformsByName.containsKey(s2)) continue;
            if (!p_410038_.contains(s2) && BUILT_IN_UNIFORMS.contains(s2)) {
                int i2 = i++;
                GL31.glUniformBlockBinding((int)this.programId, (int)j1, (int)i2);
                this.uniformsByName.put(s2, new Uniform.Ubo(i2));
                continue;
            }
            LOGGER.warn("Found unknown and unsupported uniform {} in {}", (Object)s2, (Object)this.debugLabel);
        }
    }

    @Override
    public void close() {
        this.uniformsByName.values().forEach(Uniform::close);
        GlStateManager.glDeleteProgram(this.programId);
    }

    @Nullable
    public Uniform getUniform(String p_410422_) {
        RenderSystem.assertOnRenderThread();
        return this.uniformsByName.get(p_410422_);
    }

    @VisibleForTesting
    public int getProgramId() {
        return this.programId;
    }

    public String toString() {
        return this.debugLabel;
    }

    public String getDebugLabel() {
        return this.debugLabel;
    }

    public Map<String, Uniform> getUniforms() {
        return this.uniformsByName;
    }
}

