/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.opengl;

import com.mojang.blaze3d.opengl.DirectStateAccess;
import com.mojang.blaze3d.opengl.GlBuffer;
import com.mojang.blaze3d.opengl.GlConst;
import com.mojang.blaze3d.opengl.GlDevice;
import com.mojang.blaze3d.opengl.GlStateManager;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.MemoryUtil;

@OnlyIn(value=Dist.CLIENT)
public abstract class BufferStorage {
    public static BufferStorage create(GLCapabilities p_418175_, Set<String> p_418491_) {
        if (p_418175_.GL_ARB_buffer_storage && GlDevice.USE_GL_ARB_buffer_storage) {
            p_418491_.add("GL_ARB_buffer_storage");
            return new Immutable();
        }
        return new Mutable();
    }

    public abstract GlBuffer createBuffer(DirectStateAccess var1, @Nullable Supplier<String> var2, int var3, int var4);

    public abstract GlBuffer createBuffer(DirectStateAccess var1, @Nullable Supplier<String> var2, int var3, ByteBuffer var4);

    public abstract GlBuffer.GlMappedView mapBuffer(DirectStateAccess var1, GlBuffer var2, int var3, int var4, int var5);

    @OnlyIn(value=Dist.CLIENT)
    static class Immutable
    extends BufferStorage {
        Immutable() {
        }

        @Override
        public GlBuffer createBuffer(DirectStateAccess p_418138_, @Nullable Supplier<String> p_418472_, int p_418304_, int p_418442_) {
            int i = p_418138_.createBuffer();
            p_418138_.bufferStorage(i, p_418442_, GlConst.bufferUsageToGlFlag(p_418304_));
            ByteBuffer bytebuffer = this.tryMapBufferPersistent(p_418138_, p_418304_, i, p_418442_);
            return new GlBuffer(p_418472_, p_418138_, p_418304_, p_418442_, i, bytebuffer);
        }

        @Override
        public GlBuffer createBuffer(DirectStateAccess p_418437_, @Nullable Supplier<String> p_418106_, int p_418386_, ByteBuffer p_418383_) {
            int i = p_418437_.createBuffer();
            int j = p_418383_.remaining();
            p_418437_.bufferStorage(i, p_418383_, GlConst.bufferUsageToGlFlag(p_418386_));
            ByteBuffer bytebuffer = this.tryMapBufferPersistent(p_418437_, p_418386_, i, j);
            return new GlBuffer(p_418106_, p_418437_, p_418386_, j, i, bytebuffer);
        }

        @Nullable
        private ByteBuffer tryMapBufferPersistent(DirectStateAccess p_418410_, int p_418039_, int p_418147_, int p_418508_) {
            ByteBuffer bytebuffer;
            int i = 0;
            if ((p_418039_ & 1) != 0) {
                i |= 1;
            }
            if ((p_418039_ & 2) != 0) {
                i |= 0x12;
            }
            if (i != 0) {
                GlStateManager.clearGlErrors();
                bytebuffer = p_418410_.mapBufferRange(p_418147_, 0, p_418508_, i | 0x40);
                if (bytebuffer == null) {
                    throw new IllegalStateException("Can't persistently map buffer, opengl error " + GlStateManager._getError());
                }
            } else {
                bytebuffer = null;
            }
            return bytebuffer;
        }

        @Override
        public GlBuffer.GlMappedView mapBuffer(DirectStateAccess p_418435_, GlBuffer p_418399_, int p_418357_, int p_418353_, int p_418237_) {
            if (p_418399_.persistentBuffer == null) {
                throw new IllegalStateException("Somehow trying to map an unmappable buffer");
            }
            return new GlBuffer.GlMappedView(() -> {
                if ((p_418237_ & 2) != 0) {
                    p_418435_.flushMappedBufferRange(p_418399_.handle, p_418357_, p_418353_);
                }
            }, p_418399_, MemoryUtil.memSlice((ByteBuffer)p_418399_.persistentBuffer, (int)p_418357_, (int)p_418353_));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Mutable
    extends BufferStorage {
        Mutable() {
        }

        @Override
        public GlBuffer createBuffer(DirectStateAccess p_418247_, @Nullable Supplier<String> p_418177_, int p_418191_, int p_418309_) {
            int i = p_418247_.createBuffer();
            p_418247_.bufferData(i, p_418309_, GlConst.bufferUsageToGlEnum(p_418191_));
            return new GlBuffer(p_418177_, p_418247_, p_418191_, p_418309_, i, null);
        }

        @Override
        public GlBuffer createBuffer(DirectStateAccess p_418102_, @Nullable Supplier<String> p_418521_, int p_418167_, ByteBuffer p_418232_) {
            int i = p_418102_.createBuffer();
            int j = p_418232_.remaining();
            p_418102_.bufferData(i, p_418232_, GlConst.bufferUsageToGlEnum(p_418167_));
            return new GlBuffer(p_418521_, p_418102_, p_418167_, j, i, null);
        }

        @Override
        public GlBuffer.GlMappedView mapBuffer(DirectStateAccess p_418209_, GlBuffer p_418012_, int p_418273_, int p_418050_, int p_418422_) {
            GlStateManager.clearGlErrors();
            ByteBuffer bytebuffer = p_418209_.mapBufferRange(p_418012_.handle, p_418273_, p_418050_, p_418422_);
            if (bytebuffer == null) {
                throw new IllegalStateException("Can't map buffer, opengl error " + GlStateManager._getError());
            }
            return new GlBuffer.GlMappedView(() -> p_418209_.unmapBuffer(p_418012_.handle), p_418012_, bytebuffer);
        }
    }
}

