/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.framegraph;

import com.mojang.blaze3d.framegraph.FramePass;
import com.mojang.blaze3d.resource.GraphicsResourceAllocator;
import com.mojang.blaze3d.resource.ResourceDescriptor;
import com.mojang.blaze3d.resource.ResourceHandle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FrameGraphBuilder {
    private final List<InternalVirtualResource<?>> internalResources = new ArrayList();
    private final List<ExternalResource<?>> externalResources = new ArrayList();
    private final List<Pass> passes = new ArrayList<Pass>();

    public FramePass addPass(String p_362000_) {
        Pass framegraphbuilder$pass = new Pass(this.passes.size(), p_362000_);
        this.passes.add(framegraphbuilder$pass);
        return framegraphbuilder$pass;
    }

    public <T> ResourceHandle<T> importExternal(String p_363653_, T p_363574_) {
        ExternalResource<T> externalresource = new ExternalResource<T>(p_363653_, null, p_363574_);
        this.externalResources.add(externalresource);
        return externalresource.handle;
    }

    public <T> ResourceHandle<T> createInternal(String p_364379_, ResourceDescriptor<T> p_360666_) {
        return this.createInternalResource((String)p_364379_, p_360666_, null).handle;
    }

    <T> InternalVirtualResource<T> createInternalResource(String p_362189_, ResourceDescriptor<T> p_361484_, @Nullable Pass p_363038_) {
        int i = this.internalResources.size();
        InternalVirtualResource<T> internalvirtualresource = new InternalVirtualResource<T>(i, p_362189_, p_363038_, p_361484_);
        this.internalResources.add(internalvirtualresource);
        return internalvirtualresource;
    }

    public void execute(GraphicsResourceAllocator p_361151_) {
        this.execute(p_361151_, Inspector.NONE);
    }

    public void execute(GraphicsResourceAllocator p_362990_, Inspector p_363758_) {
        BitSet bitset = this.identifyPassesToKeep();
        ArrayList<Pass> list = new ArrayList<Pass>(bitset.cardinality());
        BitSet bitset1 = new BitSet(this.passes.size());
        for (Pass framegraphbuilder$pass : this.passes) {
            this.resolvePassOrder(framegraphbuilder$pass, bitset, bitset1, list);
        }
        this.assignResourceLifetimes(list);
        for (Pass framegraphbuilder$pass1 : list) {
            for (InternalVirtualResource<?> internalvirtualresource : framegraphbuilder$pass1.resourcesToAcquire) {
                p_363758_.acquireResource(internalvirtualresource.name);
                internalvirtualresource.acquire(p_362990_);
            }
            p_363758_.beforeExecutePass(framegraphbuilder$pass1.name);
            framegraphbuilder$pass1.task.run();
            p_363758_.afterExecutePass(framegraphbuilder$pass1.name);
            int i = framegraphbuilder$pass1.resourcesToRelease.nextSetBit(0);
            while (i >= 0) {
                InternalVirtualResource<?> internalvirtualresource1 = this.internalResources.get(i);
                p_363758_.releaseResource(internalvirtualresource1.name);
                internalvirtualresource1.release(p_362990_);
                i = framegraphbuilder$pass1.resourcesToRelease.nextSetBit(i + 1);
            }
        }
    }

    private BitSet identifyPassesToKeep() {
        ArrayDeque<Pass> deque = new ArrayDeque<Pass>(this.passes.size());
        BitSet bitset = new BitSet(this.passes.size());
        for (VirtualResource virtualResource : this.externalResources) {
            Pass framegraphbuilder$pass = virtualResource.handle.createdBy;
            if (framegraphbuilder$pass == null) continue;
            this.discoverAllRequiredPasses(framegraphbuilder$pass, bitset, deque);
        }
        for (Pass pass : this.passes) {
            if (!pass.disableCulling) continue;
            this.discoverAllRequiredPasses(pass, bitset, deque);
        }
        return bitset;
    }

    private void discoverAllRequiredPasses(Pass p_362135_, BitSet p_361672_, Deque<Pass> p_363875_) {
        p_363875_.add(p_362135_);
        while (!p_363875_.isEmpty()) {
            Pass framegraphbuilder$pass = p_363875_.poll();
            if (p_361672_.get(framegraphbuilder$pass.id)) continue;
            p_361672_.set(framegraphbuilder$pass.id);
            int i = framegraphbuilder$pass.requiredPassIds.nextSetBit(0);
            while (i >= 0) {
                p_363875_.add(this.passes.get(i));
                i = framegraphbuilder$pass.requiredPassIds.nextSetBit(i + 1);
            }
        }
    }

    private void resolvePassOrder(Pass p_361359_, BitSet p_362755_, BitSet p_362866_, List<Pass> p_365482_) {
        if (p_362866_.get(p_361359_.id)) {
            String s = p_362866_.stream().mapToObj(p_361748_ -> this.passes.get((int)p_361748_).name).collect(Collectors.joining(", "));
            throw new IllegalStateException("Frame graph cycle detected between " + s);
        }
        if (p_362755_.get(p_361359_.id)) {
            p_362866_.set(p_361359_.id);
            p_362755_.clear(p_361359_.id);
            int i = p_361359_.requiredPassIds.nextSetBit(0);
            while (i >= 0) {
                this.resolvePassOrder(this.passes.get(i), p_362755_, p_362866_, p_365482_);
                i = p_361359_.requiredPassIds.nextSetBit(i + 1);
            }
            for (Handle<?> handle : p_361359_.writesFrom) {
                int j = handle.readBy.nextSetBit(0);
                while (j >= 0) {
                    if (j != p_361359_.id) {
                        this.resolvePassOrder(this.passes.get(j), p_362755_, p_362866_, p_365482_);
                    }
                    j = handle.readBy.nextSetBit(j + 1);
                }
            }
            p_365482_.add(p_361359_);
            p_362866_.clear(p_361359_.id);
        }
    }

    private void assignResourceLifetimes(Collection<Pass> p_365083_) {
        Pass[] aframegraphbuilder$pass = new Pass[this.internalResources.size()];
        for (Pass framegraphbuilder$pass : p_365083_) {
            int i = framegraphbuilder$pass.requiredResourceIds.nextSetBit(0);
            while (i >= 0) {
                InternalVirtualResource<?> internalvirtualresource = this.internalResources.get(i);
                Pass framegraphbuilder$pass1 = aframegraphbuilder$pass[i];
                aframegraphbuilder$pass[i] = framegraphbuilder$pass;
                if (framegraphbuilder$pass1 == null) {
                    framegraphbuilder$pass.resourcesToAcquire.add(internalvirtualresource);
                } else {
                    framegraphbuilder$pass1.resourcesToRelease.clear(i);
                }
                framegraphbuilder$pass.resourcesToRelease.set(i);
                i = framegraphbuilder$pass.requiredResourceIds.nextSetBit(i + 1);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class Pass
    implements FramePass {
        final int id;
        final String name;
        final List<Handle<?>> writesFrom = new ArrayList();
        final BitSet requiredResourceIds = new BitSet();
        final BitSet requiredPassIds = new BitSet();
        Runnable task = () -> {};
        final List<InternalVirtualResource<?>> resourcesToAcquire = new ArrayList();
        final BitSet resourcesToRelease = new BitSet();
        boolean disableCulling;

        public Pass(int p_363679_, String p_362279_) {
            this.id = p_363679_;
            this.name = p_362279_;
        }

        private <T> void markResourceRequired(Handle<T> p_362265_) {
            VirtualResource virtualResource = p_362265_.holder;
            if (virtualResource instanceof InternalVirtualResource) {
                InternalVirtualResource internalvirtualresource = (InternalVirtualResource)virtualResource;
                this.requiredResourceIds.set(internalvirtualresource.id);
            }
        }

        private void markPassRequired(Pass p_361707_) {
            this.requiredPassIds.set(p_361707_.id);
        }

        @Override
        public <T> ResourceHandle<T> createsInternal(String p_363278_, ResourceDescriptor<T> p_363531_) {
            InternalVirtualResource<T> internalvirtualresource = FrameGraphBuilder.this.createInternalResource(p_363278_, p_363531_, this);
            this.requiredResourceIds.set(internalvirtualresource.id);
            return internalvirtualresource.handle;
        }

        @Override
        public <T> void reads(ResourceHandle<T> p_363844_) {
            this._reads((Handle)p_363844_);
        }

        private <T> void _reads(Handle<T> p_360431_) {
            this.markResourceRequired(p_360431_);
            if (p_360431_.createdBy != null) {
                this.markPassRequired(p_360431_.createdBy);
            }
            p_360431_.readBy.set(this.id);
        }

        @Override
        public <T> ResourceHandle<T> readsAndWrites(ResourceHandle<T> p_363371_) {
            return this._readsAndWrites((Handle)p_363371_);
        }

        @Override
        public void requires(FramePass p_365196_) {
            this.requiredPassIds.set(((Pass)p_365196_).id);
        }

        @Override
        public void disableCulling() {
            this.disableCulling = true;
        }

        private <T> Handle<T> _readsAndWrites(Handle<T> p_364070_) {
            this.writesFrom.add(p_364070_);
            this._reads(p_364070_);
            return p_364070_.writeAndAlias(this);
        }

        @Override
        public void executes(Runnable p_360375_) {
            this.task = p_360375_;
        }

        public String toString() {
            return this.name;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ExternalResource<T>
    extends VirtualResource<T> {
        private final T resource;

        public ExternalResource(String p_362541_, @Nullable Pass p_363193_, T p_360991_) {
            super(p_362541_, p_363193_);
            this.resource = p_360991_;
        }

        @Override
        public T get() {
            return this.resource;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Handle<T>
    implements ResourceHandle<T> {
        final VirtualResource<T> holder;
        private final int version;
        @Nullable
        final Pass createdBy;
        final BitSet readBy = new BitSet();
        @Nullable
        private Handle<T> aliasedBy;

        Handle(VirtualResource<T> p_361124_, int p_362902_, @Nullable Pass p_361683_) {
            this.holder = p_361124_;
            this.version = p_362902_;
            this.createdBy = p_361683_;
        }

        @Override
        public T get() {
            return this.holder.get();
        }

        Handle<T> writeAndAlias(Pass p_365456_) {
            if (this.holder.handle != this) {
                throw new IllegalStateException("Handle " + String.valueOf(this) + " is no longer valid, as its contents were moved into " + String.valueOf(this.aliasedBy));
            }
            Handle<T> handle = new Handle<T>(this.holder, this.version + 1, p_365456_);
            this.holder.handle = handle;
            this.aliasedBy = handle;
            return handle;
        }

        public String toString() {
            return this.createdBy != null ? String.valueOf(this.holder) + "#" + this.version + " (from " + String.valueOf(this.createdBy) + ")" : String.valueOf(this.holder) + "#" + this.version;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class InternalVirtualResource<T>
    extends VirtualResource<T> {
        final int id;
        private final ResourceDescriptor<T> descriptor;
        @Nullable
        private T physicalResource;

        public InternalVirtualResource(int p_364397_, String p_361829_, @Nullable Pass p_364005_, ResourceDescriptor<T> p_364356_) {
            super(p_361829_, p_364005_);
            this.id = p_364397_;
            this.descriptor = p_364356_;
        }

        @Override
        public T get() {
            return Objects.requireNonNull(this.physicalResource, "Resource is not currently available");
        }

        public void acquire(GraphicsResourceAllocator p_363728_) {
            if (this.physicalResource != null) {
                throw new IllegalStateException("Tried to acquire physical resource, but it was already assigned");
            }
            this.physicalResource = p_363728_.acquire(this.descriptor);
        }

        public void release(GraphicsResourceAllocator p_362252_) {
            if (this.physicalResource == null) {
                throw new IllegalStateException("Tried to release physical resource that was not allocated");
            }
            p_362252_.release(this.descriptor, this.physicalResource);
            this.physicalResource = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface Inspector {
        public static final Inspector NONE = new Inspector(){};

        default public void acquireResource(String p_361310_) {
        }

        default public void releaseResource(String p_361496_) {
        }

        default public void beforeExecutePass(String p_362930_) {
        }

        default public void afterExecutePass(String p_363153_) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static abstract class VirtualResource<T> {
        public final String name;
        public Handle<T> handle;

        public VirtualResource(String p_361601_, @Nullable Pass p_361693_) {
            this.name = p_361601_;
            this.handle = new Handle(this, 0, p_361693_);
        }

        public abstract T get();

        public String toString() {
            return this.name;
        }
    }
}

