/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.font;

import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.blaze3d.font.SheetGlyphInfo;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.gui.font.CodepointMap;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.gui.font.providers.FreeTypeUtil;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.freetype.FT_Bitmap;
import org.lwjgl.util.freetype.FT_Face;
import org.lwjgl.util.freetype.FT_GlyphSlot;
import org.lwjgl.util.freetype.FT_Vector;
import org.lwjgl.util.freetype.FreeType;

@OnlyIn(value=Dist.CLIENT)
public class TrueTypeGlyphProvider
implements GlyphProvider {
    @Nullable
    private ByteBuffer fontMemory;
    @Nullable
    private FT_Face face;
    final float oversample;
    private final CodepointMap<GlyphEntry> glyphs = new CodepointMap(GlyphEntry[]::new, x$0 -> new GlyphEntry[x$0][]);

    public TrueTypeGlyphProvider(ByteBuffer p_83846_, FT_Face p_320481_, float p_83848_, float p_83849_, float p_83850_, float p_83851_, String p_83852_) {
        this.fontMemory = p_83846_;
        this.face = p_320481_;
        this.oversample = p_83849_;
        IntArraySet intset = new IntArraySet();
        p_83852_.codePoints().forEach(arg_0 -> ((IntSet)intset).add(arg_0));
        int i = Math.round(p_83848_ * p_83849_);
        FreeType.FT_Set_Pixel_Sizes((FT_Face)p_320481_, (int)i, (int)i);
        float f = p_83850_ * p_83849_;
        float f1 = -p_83851_ * p_83849_;
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            FT_Vector ft_vector = FreeTypeUtil.setVector(FT_Vector.malloc((MemoryStack)memorystack), f, f1);
            FreeType.FT_Set_Transform((FT_Face)p_320481_, null, (FT_Vector)ft_vector);
            IntBuffer intbuffer = memorystack.mallocInt(1);
            int j = (int)FreeType.FT_Get_First_Char((FT_Face)p_320481_, (IntBuffer)intbuffer);
            while (true) {
                int k;
                if ((k = intbuffer.get(0)) == 0) {
                    return;
                }
                if (!intset.contains(j)) {
                    this.glyphs.put(j, new GlyphEntry(k));
                }
                j = (int)FreeType.FT_Get_Next_Char((FT_Face)p_320481_, (long)j, (IntBuffer)intbuffer);
            }
        }
    }

    @Override
    @Nullable
    public GlyphInfo getGlyph(int p_231116_) {
        GlyphEntry truetypeglyphprovider$glyphentry = this.glyphs.get(p_231116_);
        return truetypeglyphprovider$glyphentry != null ? this.getOrLoadGlyphInfo(p_231116_, truetypeglyphprovider$glyphentry) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GlyphInfo getOrLoadGlyphInfo(int p_365358_, GlyphEntry p_360879_) {
        GlyphInfo glyphinfo = p_360879_.glyph;
        if (glyphinfo == null) {
            FT_Face ft_face;
            FT_Face fT_Face = ft_face = this.validateFontOpen();
            synchronized (fT_Face) {
                glyphinfo = p_360879_.glyph;
                if (glyphinfo == null) {
                    p_360879_.glyph = glyphinfo = this.loadGlyph(p_365358_, ft_face, p_360879_.index);
                }
            }
        }
        return glyphinfo;
    }

    private GlyphInfo loadGlyph(int p_361822_, FT_Face p_360350_, int p_362748_) {
        FT_GlyphSlot ft_glyphslot;
        int i = FreeType.FT_Load_Glyph((FT_Face)p_360350_, (int)p_362748_, (int)0x400008);
        if (i != 0) {
            FreeTypeUtil.assertError(i, String.format(Locale.ROOT, "Loading glyph U+%06X", p_361822_));
        }
        if ((ft_glyphslot = p_360350_.glyph()) == null) {
            throw new NullPointerException(String.format(Locale.ROOT, "Glyph U+%06X not initialized", p_361822_));
        }
        float f = FreeTypeUtil.x(ft_glyphslot.advance());
        FT_Bitmap ft_bitmap = ft_glyphslot.bitmap();
        int j = ft_glyphslot.bitmap_left();
        int k = ft_glyphslot.bitmap_top();
        int l = ft_bitmap.width();
        int i1 = ft_bitmap.rows();
        return l > 0 && i1 > 0 ? new Glyph(j, k, l, i1, f, p_362748_) : () -> f / this.oversample;
    }

    FT_Face validateFontOpen() {
        if (this.fontMemory != null && this.face != null) {
            return this.face;
        }
        throw new IllegalStateException("Provider already closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.face != null) {
            Object object = FreeTypeUtil.LIBRARY_LOCK;
            synchronized (object) {
                FreeTypeUtil.checkError(FreeType.FT_Done_Face((FT_Face)this.face), "Deleting face");
            }
            this.face = null;
        }
        MemoryUtil.memFree((Buffer)this.fontMemory);
        this.fontMemory = null;
    }

    @Override
    public IntSet getSupportedGlyphs() {
        return this.glyphs.keySet();
    }

    @OnlyIn(value=Dist.CLIENT)
    static class GlyphEntry {
        final int index;
        @Nullable
        volatile GlyphInfo glyph;

        GlyphEntry(int p_360519_) {
            this.index = p_360519_;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class Glyph
    implements GlyphInfo {
        final int width;
        final int height;
        final float bearingX;
        final float bearingY;
        private final float advance;
        final int index;

        Glyph(float p_83886_, float p_83887_, int p_83882_, int p_83883_, float p_320408_, int p_83884_) {
            this.width = p_83882_;
            this.height = p_83883_;
            this.advance = p_320408_ / TrueTypeGlyphProvider.this.oversample;
            this.bearingX = p_83886_ / TrueTypeGlyphProvider.this.oversample;
            this.bearingY = p_83887_ / TrueTypeGlyphProvider.this.oversample;
            this.index = p_83884_;
        }

        @Override
        public float getAdvance() {
            return this.advance;
        }

        @Override
        public BakedGlyph bake(Function<SheetGlyphInfo, BakedGlyph> p_231120_) {
            return p_231120_.apply(new SheetGlyphInfo(){

                @Override
                public int getPixelWidth() {
                    return Glyph.this.width;
                }

                @Override
                public int getPixelHeight() {
                    return Glyph.this.height;
                }

                @Override
                public float getOversample() {
                    return TrueTypeGlyphProvider.this.oversample;
                }

                @Override
                public float getBearingLeft() {
                    return Glyph.this.bearingX;
                }

                @Override
                public float getBearingTop() {
                    return Glyph.this.bearingY;
                }

                @Override
                public void upload(int p_231126_, int p_231127_, GpuTexture p_405861_) {
                    FT_Face ft_face = TrueTypeGlyphProvider.this.validateFontOpen();
                    try (NativeImage nativeimage = new NativeImage(NativeImage.Format.LUMINANCE, Glyph.this.width, Glyph.this.height, false);){
                        if (nativeimage.copyFromFont(ft_face, Glyph.this.index)) {
                            RenderSystem.getDevice().createCommandEncoder().writeToTexture(p_405861_, nativeimage, 0, 0, p_231126_, p_231127_, Glyph.this.width, Glyph.this.height, 0, 0);
                        }
                    }
                }

                @Override
                public boolean isColored() {
                    return false;
                }
            });
        }
    }
}

