/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.jarhandling.impl;

import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.LazyJarMetadata;
import cpw.mods.jarhandling.impl.ModuleDescriptorFactory;
import java.lang.module.ModuleDescriptor;
import org.jetbrains.annotations.Nullable;

public class SimpleJarMetadata
extends LazyJarMetadata
implements JarMetadata {
    private final String name;
    private final String version;
    private final JarContents jar;

    public SimpleJarMetadata(String name, String version, JarContents jar) {
        this.name = name;
        this.version = version;
        this.jar = jar;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public String version() {
        return this.version;
    }

    @Override
    public ModuleDescriptor computeDescriptor() {
        ModuleDescriptor.Builder bld = ModuleDescriptor.newAutomaticModule(this.name());
        if (this.version() != null) {
            bld.version(this.version());
        }
        ModuleDescriptorFactory.scanAutomaticModule(this.jar, bld, new String[0]);
        return bld.build();
    }
}

