/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.FileUtils;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.MavenCoordinateResolver;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class ModListHandler {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static List<String> processModLists(List<String> modListPaths, List<Path> mavenRootPaths) {
        List modCoordinates = modListPaths.stream().map(ModListHandler::transformPathToList).flatMap(Collection::stream).toList();
        List<Pair> localModCoords = modCoordinates.stream().map(mc -> Pair.of((Object)MavenCoordinateResolver.get(mc), (Object)mc)).toList();
        List foundCoordinates = localModCoords.stream().map(mc -> mavenRootPaths.stream().map(root -> Pair.of((Object)root.resolve((Path)mc.getLeft()), (Object)((String)mc.getRight()))).filter(path -> Files.exists((Path)path.getLeft(), new LinkOption[0])).findFirst().orElseGet(() -> {
            LOGGER.warn(LogMarkers.CORE, "Failed to find coordinate {}", mc);
            return null;
        })).filter(Objects::nonNull).collect(Collectors.toList());
        List<String> found = foundCoordinates.stream().map(Pair::getRight).collect(Collectors.toList());
        LOGGER.debug(LogMarkers.CORE, "Found mod coordinates from lists: {}", found);
        return found;
    }

    private static List<String> transformPathToList(String path) {
        LOGGER.debug(LogMarkers.CORE, "Reading mod list {}", (Object)path);
        Path filePath = FMLPaths.GAMEDIR.get().resolve(path);
        if (!Files.exists(filePath, new LinkOption[0])) {
            LOGGER.warn(LogMarkers.CORE, "Failed to find modlist file at {}", (Object)filePath);
            return Collections.emptyList();
        }
        String extension = FileUtils.fileExtension(filePath);
        if (Objects.equals("list", extension)) {
            return ModListHandler.readListFile(filePath).stream().filter(s -> !s.isEmpty()).collect(Collectors.toList());
        }
        LOGGER.warn(LogMarkers.CORE, "Failed to read unknown file list type {} for file {}", (Object)extension, (Object)filePath);
        return Collections.emptyList();
    }

    private static List<String> readListFile(Path filePath) {
        try {
            return Files.readAllLines(filePath);
        }
        catch (IOException e) {
            LOGGER.warn(LogMarkers.CORE, "Failed to read file list {}", (Object)filePath, (Object)e);
            return Collections.emptyList();
        }
    }
}

