/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.concurrent.ConcurrentConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.mojang.logging.LogUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.fml.loading.moddiscovery.NightConfigWrapper;
import net.neoforged.neoforgespi.language.IConfigurable;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.InvalidModFileException;
import net.neoforged.neoforgespi.locating.ModFileInfoParser;
import org.slf4j.Logger;

public class ModFileParser {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static IModFileInfo readModList(ModFile modFile, ModFileInfoParser parser) {
        return parser.build(modFile);
    }

    public static IModFileInfo modsTomlParser(IModFile imodFile) {
        ModFile modFile = (ModFile)imodFile;
        LOGGER.debug(LogMarkers.LOADING, "Considering mod file candidate {}", (Object)modFile.getFilePath());
        Path modsjson = modFile.findResource("META-INF/neoforge.mods.toml");
        if (!Files.exists(modsjson, new LinkOption[0])) {
            LOGGER.warn(LogMarkers.LOADING, "Mod file {} is missing {} file", (Object)modFile.getFilePath(), (Object)"META-INF/neoforge.mods.toml");
            return null;
        }
        FileConfig fileConfig = FileConfig.builder((Path)modsjson).build();
        fileConfig.load();
        fileConfig.close();
        NightConfigWrapper configWrapper = new NightConfigWrapper(ModFileParser.copyConfig((ConcurrentConfig)fileConfig));
        return new ModFileInfo(modFile, configWrapper, configWrapper::setFile);
    }

    private static UnmodifiableConfig copyConfig(ConcurrentConfig config) {
        TomlFormat format = TomlFormat.instance();
        return ((CommentedConfig)format.createParser().parse(format.createWriter().writeToString((UnmodifiableConfig)config))).unmodifiable();
    }

    protected static List<MixinConfig> getMixinConfigs(IModFileInfo modFileInfo) {
        try {
            IConfigurable config = modFileInfo.getConfig();
            List<? extends IConfigurable> mixinsEntries = config.getConfigList("mixins");
            ArrayList<MixinConfig> potentialMixins = new ArrayList<MixinConfig>();
            for (IConfigurable iConfigurable : mixinsEntries) {
                String name = (String)iConfigurable.getConfigElement("config").orElseThrow(() -> new InvalidModFileException("Missing \"config\" in [[mixins]] entry", modFileInfo));
                List<String> requiredModIds = iConfigurable.getConfigElement("requiredMods").orElse(List.of());
                potentialMixins.add(new MixinConfig(name, requiredModIds));
            }
            return potentialMixins;
        }
        catch (Exception exception) {
            LOGGER.error("Failed to load mixin configs from mod file", (Throwable)exception);
            return List.of();
        }
    }

    protected static Optional<List<String>> getAccessTransformers(IModFileInfo modFileInfo) {
        try {
            IConfigurable config = modFileInfo.getConfig();
            List<? extends IConfigurable> atEntries = config.getConfigList("accessTransformers");
            if (atEntries.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(atEntries.stream().map(entry -> (String)entry.getConfigElement("file").orElseThrow(() -> new InvalidModFileException("Missing \"file\" in [[accessTransformers]] entry", modFileInfo))).toList());
        }
        catch (Exception exception) {
            LOGGER.error("Failed to load access transformers from mod file", (Throwable)exception);
            return Optional.of(List.of());
        }
    }

    public record MixinConfig(String config, List<String> requiredMods) {
    }
}

