/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.theme;

import java.awt.Color;

public record ThemeColor(float r, float g, float b, float a) {
    public static final ThemeColor WHITE = new ThemeColor(1.0f, 1.0f, 1.0f, 1.0f);

    public static ThemeColor ofBytes(int r, int g, int b, int a) {
        return new ThemeColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public static ThemeColor ofBytes(int r, int g, int b) {
        return ThemeColor.ofBytes(r, g, b, 255);
    }

    public static ThemeColor ofArgb(int color) {
        int aByte = color >> 24 & 0xFF;
        int rByte = color >> 16 & 0xFF;
        int gByte = color >> 8 & 0xFF;
        int bByte = color & 0xFF;
        return ThemeColor.ofBytes(rByte, gByte, bByte, aByte);
    }

    public static ThemeColor ofRgb(int color) {
        int rByte = color >> 16 & 0xFF;
        int gByte = color >> 8 & 0xFF;
        int bByte = color & 0xFF;
        return ThemeColor.ofBytes(rByte, gByte, bByte);
    }

    public ThemeColor withAlpha(float alpha) {
        return new ThemeColor(this.r, this.g, this.b, alpha);
    }

    public int toArgb() {
        return ((int)(this.a * 255.0f) & 0xFF) << 24 | ((int)(this.r * 255.0f) & 0xFF) << 16 | ((int)(this.g * 255.0f) & 0xFF) << 8 | (int)(this.b * 255.0f) & 0xFF;
    }

    public int rByte() {
        return (int)(this.r * 255.0f);
    }

    public int gByte() {
        return (int)(this.g * 255.0f);
    }

    public int bByte() {
        return (int)(this.b * 255.0f);
    }

    public int aByte() {
        return (int)(this.a * 255.0f);
    }

    public static ThemeColor lerp(ThemeColor a, ThemeColor b, float f) {
        float[] hsbA = a.toHsb();
        float[] hsbB = b.toHsb();
        return ThemeColor.ofHsb(hsbA[0] + (hsbB[0] - hsbA[0]) * f, hsbA[1] + (hsbB[1] - hsbA[1]) * f, hsbA[2] + (hsbB[2] - hsbA[2]) * f);
    }

    public float[] toHsb() {
        return Color.RGBtoHSB(this.rByte(), this.gByte(), this.bByte(), null);
    }

    public static ThemeColor ofHsb(float h, float s, float b) {
        return ThemeColor.ofRgb(Color.HSBtoRGB(h, s, Math.clamp(b, 0.0f, 1.0f)));
    }
}

