/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.accesstransformer;

import java.util.Set;
import net.neoforged.accesstransformer.AccessTransformer;
import net.neoforged.accesstransformer.TargetType;
import net.neoforged.accesstransformer.parser.Target;
import net.neoforged.accesstransformer.parser.Transformation;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class WildcardAccessTransformer
extends AccessTransformer<ClassNode> {
    private final TargetType type;

    public WildcardAccessTransformer(Target.WildcardFieldTarget target, Transformation transformation) {
        super((Target)target, transformation);
        this.type = TargetType.FIELD;
    }

    public WildcardAccessTransformer(Target.WildcardMethodTarget target, Transformation transformation) {
        super((Target)target, transformation);
        this.type = TargetType.METHOD;
    }

    @Override
    public TargetType getType() {
        return TargetType.CLASS;
    }

    @Override
    public String targetName() {
        return "*" + String.valueOf((Object)this.type) + "*";
    }

    @Override
    protected void apply(ClassNode node, Set<String> privateChanged) {
        block3: {
            block2: {
                if (this.type != TargetType.FIELD) break block2;
                for (FieldNode fn : node.fields) {
                    fn.access = WildcardAccessTransformer.mergeWith(fn.access, this.getTransformation().modifier(), this.getTransformation().finalState());
                }
                break block3;
            }
            if (this.type != TargetType.METHOD) break block3;
            for (MethodNode mn : node.methods) {
                boolean wasPrivate = (mn.access & 2) == 2;
                mn.access = WildcardAccessTransformer.mergeWith(mn.access, this.getTransformation().modifier(), this.getTransformation().finalState());
                if (!wasPrivate || "<init>".equals(mn.name) || (mn.access & 2) == 2) continue;
                privateChanged.add(mn.name + mn.desc);
            }
        }
    }
}

