/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.accesstransformer;

import java.util.Set;
import net.neoforged.accesstransformer.AccessTransformer;
import net.neoforged.accesstransformer.parser.Target;
import net.neoforged.accesstransformer.parser.Transformation;
import org.objectweb.asm.tree.ClassNode;

public class ClassAccessTransformer
extends AccessTransformer<ClassNode> {
    public ClassAccessTransformer(Target.ClassTarget target, Transformation transformation) {
        super((Target)target, transformation);
    }

    @Override
    public String targetName() {
        return this.getClassName();
    }

    @Override
    protected void apply(ClassNode node, Set<String> privateChanged) {
        node.access = ClassAccessTransformer.mergeWith(node.access, this.getTransformation().modifier(), this.getTransformation().finalState());
        node.innerClasses.stream().filter(c -> c.name.equals(node.name)).forEach(inner -> {
            inner.access = ClassAccessTransformer.mergeWith(inner.access, this.getTransformation().modifier(), this.getTransformation().finalState());
        });
    }
}

