/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.accesstransformer;

import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import net.neoforged.accesstransformer.ClassAccessTransformer;
import net.neoforged.accesstransformer.FieldAccessTransformer;
import net.neoforged.accesstransformer.InnerClassAccessTransformer;
import net.neoforged.accesstransformer.MethodAccessTransformer;
import net.neoforged.accesstransformer.TargetType;
import net.neoforged.accesstransformer.WildcardAccessTransformer;
import net.neoforged.accesstransformer.parser.Target;
import net.neoforged.accesstransformer.parser.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract class AccessTransformer<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessTransformer.class);
    private static final Marker AXFORM_MARKER = MarkerFactory.getMarker((String)"AXFORM");
    private final Transformation transformation;
    private final Target target;
    private static final Transformation.Modifier[] lookup = new Transformation.Modifier[4];

    public AccessTransformer(Target target, Transformation transformation) {
        this.transformation = transformation;
        this.target = target;
    }

    public static AccessTransformer<?> of(Target target, Transformation transformation) {
        Target target2 = target;
        Objects.requireNonNull(target2);
        Target target3 = target2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Target.MethodTarget.class, Target.FieldTarget.class, Target.ClassTarget.class, Target.InnerClassTarget.class, Target.WildcardFieldTarget.class, Target.WildcardMethodTarget.class}, (Object)target3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Target.MethodTarget methodTarget = (Target.MethodTarget)target3;
                yield new MethodAccessTransformer(methodTarget, transformation);
            }
            case 1 -> {
                Target.FieldTarget fieldTarget = (Target.FieldTarget)target3;
                yield new FieldAccessTransformer(fieldTarget, transformation);
            }
            case 2 -> {
                Target.ClassTarget classTarget = (Target.ClassTarget)target3;
                yield new ClassAccessTransformer(classTarget, transformation);
            }
            case 3 -> {
                Target.InnerClassTarget innerClassTarget = (Target.InnerClassTarget)target3;
                yield new InnerClassAccessTransformer(innerClassTarget, transformation);
            }
            case 4 -> {
                Target.WildcardFieldTarget wildcardFieldTarget = (Target.WildcardFieldTarget)target3;
                yield new WildcardAccessTransformer(wildcardFieldTarget, transformation);
            }
            case 5 -> {
                Target.WildcardMethodTarget wildcardMethodTarget = (Target.WildcardMethodTarget)target3;
                yield new WildcardAccessTransformer(wildcardMethodTarget, transformation);
            }
        };
    }

    public TargetType getType() {
        return TargetType.CLASS;
    }

    public String getClassName() {
        return this.target.className();
    }

    public final Transformation getTransformation() {
        return this.transformation;
    }

    public String toString() {
        return String.valueOf(this.target) + " " + String.valueOf(this.transformation);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AccessTransformer)) {
            return false;
        }
        AccessTransformer at2 = (AccessTransformer)obj;
        return Objects.equals(this.target, at2.target) && Objects.equals(this.transformation, at2.transformation);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.transformation);
    }

    private static int accFlag(Transformation.Modifier modifier) {
        return switch (modifier) {
            default -> throw new MatchException(null, null);
            case Transformation.Modifier.PUBLIC -> 1;
            case Transformation.Modifier.PROTECTED -> 4;
            case Transformation.Modifier.PRIVATE -> 2;
            case Transformation.Modifier.DEFAULT -> 0;
        };
    }

    private static int firstBit(int flags) {
        return flags == 0 ? 0 : AccessTransformer.firstBit(flags >>> 1) + 1;
    }

    private static int mergeWith(int access, Transformation.Modifier modifier) {
        Transformation.Modifier floor = lookup[AccessTransformer.firstBit(access & 7)];
        return access & 0xFFFFFFF8 | AccessTransformer.accFlag(Transformation.Modifier.values()[Math.min(floor.ordinal(), modifier.ordinal())]);
    }

    private static int mergeWith(int access, Transformation.FinalState finalState) {
        return switch (finalState) {
            default -> throw new MatchException(null, null);
            case Transformation.FinalState.LEAVE, Transformation.FinalState.CONFLICT -> access;
            case Transformation.FinalState.MAKEFINAL -> access | 0x10;
            case Transformation.FinalState.REMOVEFINAL -> access & 0xFFFFFFEF;
        };
    }

    public static int mergeWith(int access, Transformation.Modifier modifier, Transformation.FinalState finalState) {
        return AccessTransformer.mergeWith(AccessTransformer.mergeWith(access, modifier), finalState);
    }

    public abstract String targetName();

    protected abstract void apply(T var1, Set<String> var2);

    public static <T> void applyTransform(AccessTransformer<?> accessTransformer, T node, Set<String> privateChanged) {
        LOGGER.debug(AXFORM_MARKER, "Transforming {} to access {} and {}", new Object[]{accessTransformer, accessTransformer.transformation.modifier(), accessTransformer.transformation.finalState()});
        accessTransformer.apply(node, privateChanged);
    }

    static {
        Arrays.stream(Transformation.Modifier.values()).forEach(m -> {
            AccessTransformer.lookup[AccessTransformer.firstBit((int)AccessTransformer.accFlag((Transformation.Modifier)m))] = m;
        });
    }
}

