/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.waypoints;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.waypoints.Waypoint;
import org.apache.commons.lang3.function.TriFunction;
import org.slf4j.Logger;

public abstract class TrackedWaypoint
implements Waypoint {
    static final Logger LOGGER = LogUtils.getLogger();
    public static StreamCodec<ByteBuf, TrackedWaypoint> STREAM_CODEC = StreamCodec.ofMember(TrackedWaypoint::write, TrackedWaypoint::read);
    protected final Either<UUID, String> identifier;
    private final Waypoint.Icon icon;
    private final Type type;

    TrackedWaypoint(Either<UUID, String> p_416104_, Waypoint.Icon p_416164_, Type p_415645_) {
        this.identifier = p_416104_;
        this.icon = p_416164_;
        this.type = p_415645_;
    }

    public Either<UUID, String> id() {
        return this.identifier;
    }

    public abstract void update(TrackedWaypoint var1);

    public void write(ByteBuf p_416238_) {
        FriendlyByteBuf $$1 = new FriendlyByteBuf(p_416238_);
        $$1.writeEither(this.identifier, UUIDUtil.STREAM_CODEC, FriendlyByteBuf::writeUtf);
        Waypoint.Icon.STREAM_CODEC.encode($$1, this.icon);
        $$1.writeEnum(this.type);
        this.writeContents(p_416238_);
    }

    public abstract void writeContents(ByteBuf var1);

    private static TrackedWaypoint read(ByteBuf p_415861_) {
        FriendlyByteBuf $$1 = new FriendlyByteBuf(p_415861_);
        Either<UUID, String> $$2 = $$1.readEither(UUIDUtil.STREAM_CODEC, FriendlyByteBuf::readUtf);
        Waypoint.Icon $$3 = (Waypoint.Icon)Waypoint.Icon.STREAM_CODEC.decode($$1);
        Type $$4 = $$1.readEnum(Type.class);
        return (TrackedWaypoint)$$4.constructor.apply($$2, (Object)$$3, (Object)$$1);
    }

    public static TrackedWaypoint setPosition(UUID p_415858_, Waypoint.Icon p_416632_, Vec3i p_415947_) {
        return new Vec3iWaypoint(p_415858_, p_416632_, p_415947_);
    }

    public static TrackedWaypoint setChunk(UUID p_416640_, Waypoint.Icon p_415916_, ChunkPos p_416044_) {
        return new ChunkWaypoint(p_416640_, p_415916_, p_416044_);
    }

    public static TrackedWaypoint setAzimuth(UUID p_415851_, Waypoint.Icon p_416296_, float p_416696_) {
        return new AzimuthWaypoint(p_415851_, p_416296_, p_416696_);
    }

    public static TrackedWaypoint empty(UUID p_416251_) {
        return new EmptyWaypoint(p_416251_);
    }

    public abstract double yawAngleToCamera(Level var1, Camera var2);

    public abstract PitchDirection pitchDirectionToCamera(Level var1, Projector var2);

    public abstract double distanceSquared(Entity var1);

    public Waypoint.Icon icon() {
        return this.icon;
    }

    static enum Type {
        EMPTY((TriFunction<Either<UUID, String>, Waypoint.Icon, FriendlyByteBuf, TrackedWaypoint>)((TriFunction)EmptyWaypoint::new)),
        VEC3I((TriFunction<Either<UUID, String>, Waypoint.Icon, FriendlyByteBuf, TrackedWaypoint>)((TriFunction)Vec3iWaypoint::new)),
        CHUNK((TriFunction<Either<UUID, String>, Waypoint.Icon, FriendlyByteBuf, TrackedWaypoint>)((TriFunction)ChunkWaypoint::new)),
        AZIMUTH((TriFunction<Either<UUID, String>, Waypoint.Icon, FriendlyByteBuf, TrackedWaypoint>)((TriFunction)AzimuthWaypoint::new));

        final TriFunction<Either<UUID, String>, Waypoint.Icon, FriendlyByteBuf, TrackedWaypoint> constructor;

        private Type(TriFunction<Either<UUID, String>, Waypoint.Icon, FriendlyByteBuf, TrackedWaypoint> p_416626_) {
            this.constructor = p_416626_;
        }
    }

    static class Vec3iWaypoint
    extends TrackedWaypoint {
        private Vec3i vector;

        public Vec3iWaypoint(UUID p_416462_, Waypoint.Icon p_416478_, Vec3i p_416594_) {
            super((Either<UUID, String>)Either.left((Object)p_416462_), p_416478_, Type.VEC3I);
            this.vector = p_416594_;
        }

        public Vec3iWaypoint(Either<UUID, String> p_416300_, Waypoint.Icon p_415893_, FriendlyByteBuf p_416679_) {
            super(p_416300_, p_415893_, Type.VEC3I);
            this.vector = new Vec3i(p_416679_.readVarInt(), p_416679_.readVarInt(), p_416679_.readVarInt());
        }

        @Override
        public void update(TrackedWaypoint p_416312_) {
            if (p_416312_ instanceof Vec3iWaypoint) {
                Vec3iWaypoint $$1 = (Vec3iWaypoint)p_416312_;
                this.vector = $$1.vector;
            } else {
                LOGGER.warn("Unsupported Waypoint update operation: {}", p_416312_.getClass());
            }
        }

        @Override
        public void writeContents(ByteBuf p_416442_) {
            VarInt.write(p_416442_, this.vector.getX());
            VarInt.write(p_416442_, this.vector.getY());
            VarInt.write(p_416442_, this.vector.getZ());
        }

        private Vec3 position(Level p_416641_) {
            return this.identifier.left().map(p_416641_::getEntity).map(p_415868_ -> {
                if (p_415868_.blockPosition().distManhattan(this.vector) > 3) {
                    return null;
                }
                return p_415868_.getEyePosition();
            }).orElseGet(() -> Vec3.atCenterOf(this.vector));
        }

        @Override
        public double yawAngleToCamera(Level p_419799_, Camera p_419893_) {
            Vec3 $$2 = p_419893_.position().subtract(this.position(p_419799_)).rotateClockwise90();
            float $$3 = (float)Mth.atan2($$2.z(), $$2.x()) * 57.295776f;
            return Mth.degreesDifference(p_419893_.yaw(), $$3);
        }

        @Override
        public PitchDirection pitchDirectionToCamera(Level p_419459_, Projector p_419783_) {
            double $$4;
            Vec3 $$2 = p_419783_.projectPointToScreen(this.position(p_419459_));
            boolean $$3 = $$2.z > 1.0;
            double d = $$4 = $$3 ? -$$2.y : $$2.y;
            if ($$4 < -1.0) {
                return PitchDirection.DOWN;
            }
            if ($$4 > 1.0) {
                return PitchDirection.UP;
            }
            if ($$3) {
                if ($$2.y > 0.0) {
                    return PitchDirection.UP;
                }
                if ($$2.y < 0.0) {
                    return PitchDirection.DOWN;
                }
            }
            return PitchDirection.NONE;
        }

        @Override
        public double distanceSquared(Entity p_416747_) {
            return p_416747_.distanceToSqr(Vec3.atCenterOf(this.vector));
        }
    }

    static class ChunkWaypoint
    extends TrackedWaypoint {
        private ChunkPos chunkPos;

        public ChunkWaypoint(UUID p_415927_, Waypoint.Icon p_416553_, ChunkPos p_416069_) {
            super((Either<UUID, String>)Either.left((Object)p_415927_), p_416553_, Type.CHUNK);
            this.chunkPos = p_416069_;
        }

        public ChunkWaypoint(Either<UUID, String> p_415787_, Waypoint.Icon p_415737_, FriendlyByteBuf p_416433_) {
            super(p_415787_, p_415737_, Type.CHUNK);
            this.chunkPos = new ChunkPos(p_416433_.readVarInt(), p_416433_.readVarInt());
        }

        @Override
        public void update(TrackedWaypoint p_416415_) {
            if (p_416415_ instanceof ChunkWaypoint) {
                ChunkWaypoint $$1 = (ChunkWaypoint)p_416415_;
                this.chunkPos = $$1.chunkPos;
            } else {
                LOGGER.warn("Unsupported Waypoint update operation: {}", p_416415_.getClass());
            }
        }

        @Override
        public void writeContents(ByteBuf p_416369_) {
            VarInt.write(p_416369_, this.chunkPos.x);
            VarInt.write(p_416369_, this.chunkPos.z);
        }

        private Vec3 position(double p_419928_) {
            return Vec3.atCenterOf(this.chunkPos.getMiddleBlockPosition((int)p_419928_));
        }

        @Override
        public double yawAngleToCamera(Level p_420006_, Camera p_419530_) {
            Vec3 $$2 = p_419530_.position();
            Vec3 $$3 = $$2.subtract(this.position($$2.y())).rotateClockwise90();
            float $$4 = (float)Mth.atan2($$3.z(), $$3.x()) * 57.295776f;
            return Mth.degreesDifference(p_419530_.yaw(), $$4);
        }

        @Override
        public PitchDirection pitchDirectionToCamera(Level p_419513_, Projector p_416711_) {
            double $$2 = p_416711_.projectHorizonToScreen();
            if ($$2 < -1.0) {
                return PitchDirection.DOWN;
            }
            if ($$2 > 1.0) {
                return PitchDirection.UP;
            }
            return PitchDirection.NONE;
        }

        @Override
        public double distanceSquared(Entity p_415648_) {
            return p_415648_.distanceToSqr(Vec3.atCenterOf(this.chunkPos.getMiddleBlockPosition(p_415648_.getBlockY())));
        }
    }

    static class AzimuthWaypoint
    extends TrackedWaypoint {
        private float angle;

        public AzimuthWaypoint(UUID p_416086_, Waypoint.Icon p_416213_, float p_416138_) {
            super((Either<UUID, String>)Either.left((Object)p_416086_), p_416213_, Type.AZIMUTH);
            this.angle = p_416138_;
        }

        public AzimuthWaypoint(Either<UUID, String> p_416692_, Waypoint.Icon p_415806_, FriendlyByteBuf p_415614_) {
            super(p_416692_, p_415806_, Type.AZIMUTH);
            this.angle = p_415614_.readFloat();
        }

        @Override
        public void update(TrackedWaypoint p_416744_) {
            if (p_416744_ instanceof AzimuthWaypoint) {
                AzimuthWaypoint $$1 = (AzimuthWaypoint)p_416744_;
                this.angle = $$1.angle;
            } else {
                LOGGER.warn("Unsupported Waypoint update operation: {}", p_416744_.getClass());
            }
        }

        @Override
        public void writeContents(ByteBuf p_416592_) {
            p_416592_.writeFloat(this.angle);
        }

        @Override
        public double yawAngleToCamera(Level p_419593_, Camera p_419977_) {
            return Mth.degreesDifference(p_419977_.yaw(), this.angle * 57.295776f);
        }

        @Override
        public PitchDirection pitchDirectionToCamera(Level p_419920_, Projector p_416265_) {
            double $$2 = p_416265_.projectHorizonToScreen();
            if ($$2 < -1.0) {
                return PitchDirection.DOWN;
            }
            if ($$2 > 1.0) {
                return PitchDirection.UP;
            }
            return PitchDirection.NONE;
        }

        @Override
        public double distanceSquared(Entity p_415870_) {
            return Double.POSITIVE_INFINITY;
        }
    }

    static class EmptyWaypoint
    extends TrackedWaypoint {
        private EmptyWaypoint(Either<UUID, String> p_416008_, Waypoint.Icon p_416267_, FriendlyByteBuf p_415647_) {
            super(p_416008_, p_416267_, Type.EMPTY);
        }

        EmptyWaypoint(UUID p_416299_) {
            super((Either<UUID, String>)Either.left((Object)p_416299_), Waypoint.Icon.NULL, Type.EMPTY);
        }

        @Override
        public void update(TrackedWaypoint p_416695_) {
        }

        @Override
        public void writeContents(ByteBuf p_415596_) {
        }

        @Override
        public double yawAngleToCamera(Level p_419897_, Camera p_419457_) {
            return Double.NaN;
        }

        @Override
        public PitchDirection pitchDirectionToCamera(Level p_419455_, Projector p_416651_) {
            return PitchDirection.NONE;
        }

        @Override
        public double distanceSquared(Entity p_415940_) {
            return Double.POSITIVE_INFINITY;
        }
    }

    public static interface Camera {
        public float yaw();

        public Vec3 position();
    }

    public static interface Projector {
        public Vec3 projectPointToScreen(Vec3 var1);

        public double projectHorizonToScreen();
    }

    public static enum PitchDirection {
        NONE,
        UP,
        DOWN;

    }
}

