/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.number;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public record StorageValue(ResourceLocation storage, NbtPathArgument.NbtPath path) implements NumberProvider
{
    public static final MapCodec<StorageValue> CODEC = RecordCodecBuilder.mapCodec(p_335586_ -> p_335586_.group((App)ResourceLocation.CODEC.fieldOf("storage").forGetter(StorageValue::storage), (App)NbtPathArgument.NbtPath.CODEC.fieldOf("path").forGetter(StorageValue::path)).apply((Applicative)p_335586_, StorageValue::new));

    @Override
    public LootNumberProviderType getType() {
        return NumberProviders.STORAGE;
    }

    private Number getNumericTag(LootContext p_336045_, Number p_410369_) {
        CompoundTag $$2 = p_336045_.getLevel().getServer().getCommandStorage().get(this.storage);
        try {
            Tag tag;
            List<Tag> $$3 = this.path.get($$2);
            if ($$3.size() == 1 && (tag = $$3.getFirst()) instanceof NumericTag) {
                NumericTag $$4 = (NumericTag)tag;
                return $$4.box();
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return p_410369_;
    }

    @Override
    public float getFloat(LootContext p_335884_) {
        return this.getNumericTag(p_335884_, Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public int getInt(LootContext p_335703_) {
        return this.getNumericTag(p_335703_, 0).intValue();
    }
}

