/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.nbt;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.StorageNbtProvider;

public class NbtProviders {
    private static final Codec<NbtProvider> TYPED_CODEC = BuiltInRegistries.LOOT_NBT_PROVIDER_TYPE.byNameCodec().dispatch(NbtProvider::getType, LootNbtProviderType::codec);
    public static final Codec<NbtProvider> CODEC = Codec.lazyInitialized(() -> Codec.either(ContextNbtProvider.INLINE_CODEC, TYPED_CODEC).xmap(Either::unwrap, p_299257_ -> {
        Either either;
        if (p_299257_ instanceof ContextNbtProvider) {
            ContextNbtProvider $$1 = (ContextNbtProvider)p_299257_;
            either = Either.left((Object)$$1);
        } else {
            either = Either.right((Object)p_299257_);
        }
        return either;
    }));
    public static final LootNbtProviderType STORAGE = NbtProviders.register("storage", StorageNbtProvider.CODEC);
    public static final LootNbtProviderType CONTEXT = NbtProviders.register("context", ContextNbtProvider.CODEC);

    private static LootNbtProviderType register(String p_165629_, MapCodec<? extends NbtProvider> p_338777_) {
        return Registry.register(BuiltInRegistries.LOOT_NBT_PROVIDER_TYPE, ResourceLocation.withDefaultNamespace(p_165629_), new LootNbtProviderType(p_338777_));
    }
}

