/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public record LootItemRandomChanceWithEnchantedBonusCondition(float unenchantedChance, LevelBasedValue enchantedChance, Holder<Enchantment> enchantment) implements LootItemCondition
{
    public static final MapCodec<LootItemRandomChanceWithEnchantedBonusCondition> CODEC = RecordCodecBuilder.mapCodec(p_352054_ -> p_352054_.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("unenchanted_chance").forGetter(LootItemRandomChanceWithEnchantedBonusCondition::unenchantedChance), (App)LevelBasedValue.CODEC.fieldOf("enchanted_chance").forGetter(LootItemRandomChanceWithEnchantedBonusCondition::enchantedChance), (App)Enchantment.CODEC.fieldOf("enchantment").forGetter(LootItemRandomChanceWithEnchantedBonusCondition::enchantment)).apply((Applicative)p_352054_, LootItemRandomChanceWithEnchantedBonusCondition::new));

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.RANDOM_CHANCE_WITH_ENCHANTED_BONUS;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.ATTACKING_ENTITY);
    }

    @Override
    public boolean test(LootContext p_345165_) {
        int n;
        Entity $$1 = p_345165_.getOptionalParameter(LootContextParams.ATTACKING_ENTITY);
        if ($$1 instanceof LivingEntity) {
            LivingEntity $$2 = (LivingEntity)$$1;
            n = EnchantmentHelper.getEnchantmentLevel(this.enchantment, $$2);
        } else {
            n = 0;
        }
        int $$3 = n;
        float $$4 = $$3 > 0 ? this.enchantedChance.calculate($$3) : this.unenchantedChance;
        return p_345165_.getRandom().nextFloat() < $$4;
    }

    public static LootItemCondition.Builder randomChanceAndLootingBoost(HolderLookup.Provider p_346115_, float p_345739_, float p_345989_) {
        HolderGetter $$3 = p_346115_.lookupOrThrow(Registries.ENCHANTMENT);
        return () -> LootItemRandomChanceWithEnchantedBonusCondition.lambda$randomChanceAndLootingBoost$1(p_345739_, p_345989_, (HolderLookup.RegistryLookup)$$3);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootContext)object);
    }

    private static /* synthetic */ LootItemCondition lambda$randomChanceAndLootingBoost$1(float p_352051_, float p_352052_, HolderLookup.RegistryLookup p_352053_) {
        return new LootItemRandomChanceWithEnchantedBonusCondition(p_352051_, new LevelBasedValue.Linear(p_352051_ + p_352052_, p_352052_), p_352053_.getOrThrow(Enchantments.LOOTING));
    }
}

