/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;

public class ExplorationMapFunction
extends LootItemConditionalFunction {
    public static final TagKey<Structure> DEFAULT_DESTINATION = StructureTags.ON_TREASURE_MAPS;
    public static final Holder<MapDecorationType> DEFAULT_DECORATION = MapDecorationTypes.WOODLAND_MANSION;
    public static final byte DEFAULT_ZOOM = 2;
    public static final int DEFAULT_SEARCH_RADIUS = 50;
    public static final boolean DEFAULT_SKIP_EXISTING = true;
    public static final MapCodec<ExplorationMapFunction> CODEC = RecordCodecBuilder.mapCodec(p_298641_ -> ExplorationMapFunction.commonFields(p_298641_).and(p_298641_.group((App)TagKey.codec(Registries.STRUCTURE).optionalFieldOf("destination", DEFAULT_DESTINATION).forGetter(p_299251_ -> p_299251_.destination), (App)MapDecorationType.CODEC.optionalFieldOf("decoration", DEFAULT_DECORATION).forGetter(p_335334_ -> p_335334_.mapDecoration), (App)Codec.BYTE.optionalFieldOf("zoom", (Object)2).forGetter(p_298446_ -> p_298446_.zoom), (App)Codec.INT.optionalFieldOf("search_radius", (Object)50).forGetter(p_298263_ -> p_298263_.searchRadius), (App)Codec.BOOL.optionalFieldOf("skip_existing_chunks", (Object)true).forGetter(p_299182_ -> p_299182_.skipKnownStructures))).apply((Applicative)p_298641_, ExplorationMapFunction::new));
    private final TagKey<Structure> destination;
    private final Holder<MapDecorationType> mapDecoration;
    private final byte zoom;
    private final int searchRadius;
    private final boolean skipKnownStructures;

    ExplorationMapFunction(List<LootItemCondition> p_298451_, TagKey<Structure> p_210653_, Holder<MapDecorationType> p_336106_, byte p_210655_, int p_210656_, boolean p_210657_) {
        super(p_298451_);
        this.destination = p_210653_;
        this.mapDecoration = p_336106_;
        this.zoom = p_210655_;
        this.searchRadius = p_210656_;
        this.skipKnownStructures = p_210657_;
    }

    public LootItemFunctionType<ExplorationMapFunction> getType() {
        return LootItemFunctions.EXPLORATION_MAP;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.ORIGIN);
    }

    @Override
    public ItemStack run(ItemStack p_80547_, LootContext p_80548_) {
        ServerLevel $$3;
        BlockPos $$4;
        if (!p_80547_.is(Items.MAP)) {
            return p_80547_;
        }
        Vec3 $$2 = p_80548_.getOptionalParameter(LootContextParams.ORIGIN);
        if ($$2 != null && ($$4 = ($$3 = p_80548_.getLevel()).findNearestMapStructure(this.destination, BlockPos.containing($$2), this.searchRadius, this.skipKnownStructures)) != null) {
            ItemStack $$5 = MapItem.create($$3, $$4.getX(), $$4.getZ(), this.zoom, true, true);
            MapItem.renderBiomePreviewMap($$3, $$5);
            MapItemSavedData.addTargetDecoration($$5, $$4, "+", this.mapDecoration);
            return $$5;
        }
        return p_80547_;
    }

    public static Builder makeExplorationMap() {
        return new Builder();
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private TagKey<Structure> destination = DEFAULT_DESTINATION;
        private Holder<MapDecorationType> mapDecoration = DEFAULT_DECORATION;
        private byte zoom = (byte)2;
        private int searchRadius = 50;
        private boolean skipKnownStructures = true;

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder setDestination(TagKey<Structure> p_210659_) {
            this.destination = p_210659_;
            return this;
        }

        public Builder setMapDecoration(Holder<MapDecorationType> p_335871_) {
            this.mapDecoration = p_335871_;
            return this;
        }

        public Builder setZoom(byte p_80570_) {
            this.zoom = p_80570_;
            return this;
        }

        public Builder setSearchRadius(int p_165206_) {
            this.searchRadius = p_165206_;
            return this;
        }

        public Builder setSkipKnownStructures(boolean p_80576_) {
            this.skipKnownStructures = p_80576_;
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new ExplorationMapFunction(this.getConditions(), this.destination, this.mapDecoration, this.zoom, this.searchRadius, this.skipKnownStructures);
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }
}

