/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class CopyComponentsFunction
extends LootItemConditionalFunction {
    public static final MapCodec<CopyComponentsFunction> CODEC = RecordCodecBuilder.mapCodec(p_338127_ -> CopyComponentsFunction.commonFields(p_338127_).and(p_338127_.group((App)Source.CODEC.fieldOf("source").forGetter(p_331312_ -> p_331312_.source), (App)DataComponentType.CODEC.listOf().optionalFieldOf("include").forGetter(p_338132_ -> p_338132_.include), (App)DataComponentType.CODEC.listOf().optionalFieldOf("exclude").forGetter(p_338126_ -> p_338126_.exclude))).apply((Applicative)p_338127_, CopyComponentsFunction::new));
    private final Source source;
    private final Optional<List<DataComponentType<?>>> include;
    private final Optional<List<DataComponentType<?>>> exclude;
    private final Predicate<DataComponentType<?>> bakedPredicate;

    CopyComponentsFunction(List<LootItemCondition> p_330806_, Source p_330881_, Optional<List<DataComponentType<?>>> p_338636_, Optional<List<DataComponentType<?>>> p_338680_) {
        super(p_330806_);
        this.source = p_330881_;
        this.include = p_338636_.map(List::copyOf);
        this.exclude = p_338680_.map(List::copyOf);
        ArrayList $$4 = new ArrayList(2);
        p_338680_.ifPresent(p_338129_ -> $$4.add(p_338134_ -> !p_338129_.contains(p_338134_)));
        p_338636_.ifPresent(p_338131_ -> $$4.add(p_338131_::contains));
        this.bakedPredicate = Util.allOf($$4);
    }

    public LootItemFunctionType<CopyComponentsFunction> getType() {
        return LootItemFunctions.COPY_COMPONENTS;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.source.getReferencedContextParams();
    }

    @Override
    public ItemStack run(ItemStack p_330563_, LootContext p_331220_) {
        DataComponentMap $$2 = this.source.get(p_331220_);
        p_330563_.applyComponents($$2.filter(this.bakedPredicate));
        return p_330563_;
    }

    public static Builder copyComponents(Source p_331133_) {
        return new Builder(p_331133_);
    }

    public static enum Source implements StringRepresentable
    {
        BLOCK_ENTITY("block_entity");

        public static final Codec<Source> CODEC;
        private final String name;

        private Source(String p_330561_) {
            this.name = p_330561_;
        }

        public DataComponentMap get(LootContext p_331014_) {
            switch (this.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: 
            }
            BlockEntity $$1 = p_331014_.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
            return $$1 != null ? $$1.collectComponents() : DataComponentMap.EMPTY;
        }

        public Set<ContextKey<?>> getReferencedContextParams() {
            switch (this.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: 
            }
            return Set.of(LootContextParams.BLOCK_ENTITY);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromValues(Source::values);
        }
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final Source source;
        private Optional<ImmutableList.Builder<DataComponentType<?>>> include = Optional.empty();
        private Optional<ImmutableList.Builder<DataComponentType<?>>> exclude = Optional.empty();

        Builder(Source p_331304_) {
            this.source = p_331304_;
        }

        public Builder include(DataComponentType<?> p_338267_) {
            if (this.include.isEmpty()) {
                this.include = Optional.of(ImmutableList.builder());
            }
            this.include.get().add(p_338267_);
            return this;
        }

        public Builder exclude(DataComponentType<?> p_338302_) {
            if (this.exclude.isEmpty()) {
                this.exclude = Optional.of(ImmutableList.builder());
            }
            this.exclude.get().add(p_338302_);
            return this;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new CopyComponentsFunction(this.getConditions(), this.source, this.include.map(ImmutableList.Builder::build), this.exclude.map(ImmutableList.Builder::build));
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }
}

