/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.phys.Vec3;

public record TeleportTransition(ServerLevel newLevel, Vec3 position, Vec3 deltaMovement, float yRot, float xRot, boolean missingRespawnBlock, boolean asPassenger, Set<Relative> relatives, PostTeleportTransition postTeleportTransition) {
    public static final PostTeleportTransition DO_NOTHING = p_379662_ -> {};
    public static final PostTeleportTransition PLAY_PORTAL_SOUND = TeleportTransition::playPortalSound;
    public static final PostTeleportTransition PLACE_PORTAL_TICKET = TeleportTransition::placePortalTicket;

    public TeleportTransition(ServerLevel p_379776_, Vec3 p_379412_, Vec3 p_379320_, float p_380257_, float p_379610_, PostTeleportTransition p_380303_) {
        this(p_379776_, p_379412_, p_379320_, p_380257_, p_379610_, Set.of(), p_380303_);
    }

    public TeleportTransition(ServerLevel p_380133_, Vec3 p_379861_, Vec3 p_380308_, float p_379941_, float p_380119_, Set<Relative> p_379959_, PostTeleportTransition p_379425_) {
        this(p_380133_, p_379861_, p_380308_, p_379941_, p_380119_, false, false, p_379959_, p_379425_);
    }

    public TeleportTransition(ServerLevel p_379938_, Entity p_379604_, PostTeleportTransition p_379683_) {
        this(p_379938_, TeleportTransition.findAdjustedSharedSpawnPos(p_379938_, p_379604_), Vec3.ZERO, p_379938_.getSharedSpawnAngle(), 0.0f, false, false, Set.of(), p_379683_);
    }

    private static void playPortalSound(Entity p_380322_) {
        if (p_380322_ instanceof ServerPlayer) {
            ServerPlayer $$1 = (ServerPlayer)p_380322_;
            $$1.connection.send(new ClientboundLevelEventPacket(1032, BlockPos.ZERO, 0, false));
        }
    }

    private static void placePortalTicket(Entity p_379684_) {
        p_379684_.placePortalTicket(BlockPos.containing(p_379684_.position()));
    }

    public static TeleportTransition missingRespawnBlock(ServerLevel p_380117_, Entity p_380173_, PostTeleportTransition p_380370_) {
        return new TeleportTransition(p_380117_, TeleportTransition.findAdjustedSharedSpawnPos(p_380117_, p_380173_), Vec3.ZERO, p_380117_.getSharedSpawnAngle(), 0.0f, true, false, Set.of(), p_380370_);
    }

    private static Vec3 findAdjustedSharedSpawnPos(ServerLevel p_379295_, Entity p_379825_) {
        return p_379825_.adjustSpawnLocation(p_379295_, p_379295_.getSharedSpawnPos()).getBottomCenter();
    }

    public TeleportTransition withRotation(float p_380177_, float p_379582_) {
        return new TeleportTransition(this.newLevel(), this.position(), this.deltaMovement(), p_380177_, p_379582_, this.missingRespawnBlock(), this.asPassenger(), this.relatives(), this.postTeleportTransition());
    }

    public TeleportTransition withPosition(Vec3 p_379914_) {
        return new TeleportTransition(this.newLevel(), p_379914_, this.deltaMovement(), this.yRot(), this.xRot(), this.missingRespawnBlock(), this.asPassenger(), this.relatives(), this.postTeleportTransition());
    }

    public TeleportTransition transitionAsPassenger() {
        return new TeleportTransition(this.newLevel(), this.position(), this.deltaMovement(), this.yRot(), this.xRot(), this.missingRespawnBlock(), true, this.relatives(), this.postTeleportTransition());
    }

    @FunctionalInterface
    public static interface PostTeleportTransition {
        public void onTransition(Entity var1);

        default public PostTeleportTransition then(PostTeleportTransition p_380353_) {
            return p_380407_ -> {
                this.onTransition(p_380407_);
                p_380353_.onTransition(p_380407_);
            };
        }
    }
}

