/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class FlowingFluid
extends Fluid {
    public static final BooleanProperty FALLING = BlockStateProperties.FALLING;
    public static final IntegerProperty LEVEL = BlockStateProperties.LEVEL_FLOWING;
    private static final int CACHE_SIZE = 200;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<BlockStatePairKey>> OCCLUSION_CACHE = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<BlockStatePairKey> $$0 = new Object2ByteLinkedOpenHashMap<BlockStatePairKey>(200){

            protected void rehash(int p_76102_) {
            }
        };
        $$0.defaultReturnValue((byte)127);
        return $$0;
    });
    private final Map<FluidState, VoxelShape> shapes = Maps.newIdentityHashMap();

    @Override
    protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> p_76046_) {
        p_76046_.add(FALLING);
    }

    @Override
    public Vec3 getFlow(BlockGetter p_75987_, BlockPos p_75988_, FluidState p_75989_) {
        double $$3 = 0.0;
        double $$4 = 0.0;
        BlockPos.MutableBlockPos $$5 = new BlockPos.MutableBlockPos();
        for (Direction $$6 : Direction.Plane.HORIZONTAL) {
            $$5.setWithOffset((Vec3i)p_75988_, $$6);
            FluidState $$7 = p_75987_.getFluidState($$5);
            if (!this.affectsFlow($$7)) continue;
            float $$8 = $$7.getOwnHeight();
            float $$9 = 0.0f;
            if ($$8 == 0.0f) {
                Vec3i $$10;
                FluidState $$11;
                if (!p_75987_.getBlockState($$5).blocksMotion() && this.affectsFlow($$11 = p_75987_.getFluidState((BlockPos)($$10 = $$5.below()))) && ($$8 = $$11.getOwnHeight()) > 0.0f) {
                    $$9 = p_75989_.getOwnHeight() - ($$8 - 0.8888889f);
                }
            } else if ($$8 > 0.0f) {
                $$9 = p_75989_.getOwnHeight() - $$8;
            }
            if ($$9 == 0.0f) continue;
            $$3 += (double)((float)$$6.getStepX() * $$9);
            $$4 += (double)((float)$$6.getStepZ() * $$9);
        }
        Vec3 $$12 = new Vec3($$3, 0.0, $$4);
        if (p_75989_.getValue(FALLING).booleanValue()) {
            for (Direction $$13 : Direction.Plane.HORIZONTAL) {
                $$5.setWithOffset((Vec3i)p_75988_, $$13);
                if (!this.isSolidFace(p_75987_, $$5, $$13) && !this.isSolidFace(p_75987_, (BlockPos)$$5.above(), $$13)) continue;
                $$12 = $$12.normalize().add(0.0, -6.0, 0.0);
                break;
            }
        }
        return $$12.normalize();
    }

    private boolean affectsFlow(FluidState p_76095_) {
        return p_76095_.isEmpty() || p_76095_.getType().isSame(this);
    }

    protected boolean isSolidFace(BlockGetter p_75991_, BlockPos p_75992_, Direction p_75993_) {
        BlockState $$3 = p_75991_.getBlockState(p_75992_);
        FluidState $$4 = p_75991_.getFluidState(p_75992_);
        if ($$4.getType().isSame(this)) {
            return false;
        }
        if (p_75993_ == Direction.UP) {
            return true;
        }
        if ($$3.getBlock() instanceof IceBlock) {
            return false;
        }
        return $$3.isFaceSturdy(p_75991_, p_75992_, p_75993_);
    }

    protected void spread(ServerLevel p_376507_, BlockPos p_76012_, BlockState p_361407_, FluidState p_76013_) {
        FluidState $$7;
        Fluid $$8;
        FluidState $$6;
        BlockState $$5;
        if (p_76013_.isEmpty()) {
            return;
        }
        BlockPos $$4 = p_76012_.below();
        if (this.canMaybePassThrough(p_376507_, p_76012_, p_361407_, Direction.DOWN, $$4, $$5 = p_376507_.getBlockState($$4), $$6 = $$5.getFluidState()) && $$6.canBeReplacedWith(p_376507_, $$4, $$8 = ($$7 = this.getNewLiquid(p_376507_, $$4, $$5)).getType(), Direction.DOWN) && FlowingFluid.canHoldSpecificFluid(p_376507_, $$4, $$5, $$8)) {
            this.spreadTo(p_376507_, $$4, $$5, Direction.DOWN, $$7);
            if (this.sourceNeighborCount(p_376507_, p_76012_) >= 3) {
                this.spreadToSides(p_376507_, p_76012_, p_76013_, p_361407_);
            }
            return;
        }
        if (p_76013_.isSource() || !this.isWaterHole(p_376507_, p_76012_, p_361407_, $$4, $$5)) {
            this.spreadToSides(p_376507_, p_76012_, p_76013_, p_361407_);
        }
    }

    private void spreadToSides(ServerLevel p_376224_, BlockPos p_76016_, FluidState p_76017_, BlockState p_76018_) {
        int $$4 = p_76017_.getAmount() - this.getDropOff(p_376224_);
        if (p_76017_.getValue(FALLING).booleanValue()) {
            $$4 = 7;
        }
        if ($$4 <= 0) {
            return;
        }
        Map<Direction, FluidState> $$5 = this.getSpread(p_376224_, p_76016_, p_76018_);
        for (Map.Entry<Direction, FluidState> $$6 : $$5.entrySet()) {
            Direction $$7 = $$6.getKey();
            FluidState $$8 = $$6.getValue();
            BlockPos $$9 = p_76016_.relative($$7);
            this.spreadTo(p_376224_, $$9, p_376224_.getBlockState($$9), $$7, $$8);
        }
    }

    protected FluidState getNewLiquid(ServerLevel p_376839_, BlockPos p_76037_, BlockState p_76038_) {
        BlockPos.MutableBlockPos $$12;
        BlockState $$13;
        FluidState $$14;
        int $$3 = 0;
        int $$4 = 0;
        BlockPos.MutableBlockPos $$5 = new BlockPos.MutableBlockPos();
        for (Direction $$6 : Direction.Plane.HORIZONTAL) {
            BlockPos.MutableBlockPos $$7 = $$5.setWithOffset((Vec3i)p_76037_, $$6);
            BlockState $$8 = p_376839_.getBlockState($$7);
            FluidState $$9 = $$8.getFluidState();
            if (!$$9.getType().isSame(this) || !FlowingFluid.canPassThroughWall($$6, p_376839_, p_76037_, p_76038_, $$7, $$8)) continue;
            if ($$9.isSource()) {
                ++$$4;
            }
            $$3 = Math.max($$3, $$9.getAmount());
        }
        if ($$4 >= 2 && this.canConvertToSource(p_376839_)) {
            BlockState $$10 = p_376839_.getBlockState($$5.setWithOffset((Vec3i)p_76037_, Direction.DOWN));
            FluidState $$11 = $$10.getFluidState();
            if ($$10.isSolid() || this.isSourceBlockOfThisType($$11)) {
                return this.getSource(false);
            }
        }
        if (!($$14 = ($$13 = p_376839_.getBlockState($$12 = $$5.setWithOffset((Vec3i)p_76037_, Direction.UP))).getFluidState()).isEmpty() && $$14.getType().isSame(this) && FlowingFluid.canPassThroughWall(Direction.UP, p_376839_, p_76037_, p_76038_, $$12, $$13)) {
            return this.getFlowing(8, true);
        }
        int $$15 = $$3 - this.getDropOff(p_376839_);
        if ($$15 <= 0) {
            return Fluids.EMPTY.defaultFluidState();
        }
        return this.getFlowing($$15, false);
    }

    private static boolean canPassThroughWall(Direction p_76062_, BlockGetter p_76063_, BlockPos p_76064_, BlockState p_76065_, BlockPos p_76066_, BlockState p_76067_) {
        boolean $$13;
        Object $$12;
        Object2ByteLinkedOpenHashMap<BlockStatePairKey> $$9;
        VoxelShape $$6 = p_76067_.getCollisionShape(p_76063_, p_76066_);
        if ($$6 == Shapes.block()) {
            return false;
        }
        VoxelShape $$7 = p_76065_.getCollisionShape(p_76063_, p_76064_);
        if ($$7 == Shapes.block()) {
            return false;
        }
        if ($$7 == Shapes.empty() && $$6 == Shapes.empty()) {
            return true;
        }
        if (p_76065_.getBlock().hasDynamicShape() || p_76067_.getBlock().hasDynamicShape()) {
            Object $$8 = null;
        } else {
            $$9 = OCCLUSION_CACHE.get();
        }
        if ($$9 != null) {
            BlockStatePairKey $$10 = new BlockStatePairKey(p_76065_, p_76067_, p_76062_);
            byte $$11 = $$9.getAndMoveToFirst((Object)$$10);
            if ($$11 != 127) {
                return $$11 != 0;
            }
        } else {
            $$12 = null;
        }
        boolean bl = $$13 = !Shapes.mergedFaceOccludes($$7, $$6, p_76062_);
        if ($$9 != null) {
            if ($$9.size() == 200) {
                $$9.removeLastByte();
            }
            $$9.putAndMoveToFirst($$12, (byte)($$13 ? 1 : 0));
        }
        return $$13;
    }

    public abstract Fluid getFlowing();

    public FluidState getFlowing(int p_75954_, boolean p_75955_) {
        return (FluidState)((FluidState)this.getFlowing().defaultFluidState().setValue(LEVEL, p_75954_)).setValue(FALLING, p_75955_);
    }

    public abstract Fluid getSource();

    public FluidState getSource(boolean p_76069_) {
        return (FluidState)this.getSource().defaultFluidState().setValue(FALLING, p_76069_);
    }

    protected abstract boolean canConvertToSource(ServerLevel var1);

    protected void spreadTo(LevelAccessor p_76005_, BlockPos p_76006_, BlockState p_76007_, Direction p_76008_, FluidState p_76009_) {
        Block block = p_76007_.getBlock();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer $$5 = (LiquidBlockContainer)((Object)block);
            $$5.placeLiquid(p_76005_, p_76006_, p_76007_, p_76009_);
        } else {
            if (!p_76007_.isAir()) {
                this.beforeDestroyingBlock(p_76005_, p_76006_, p_76007_);
            }
            p_76005_.setBlock(p_76006_, p_76009_.createLegacyBlock(), 3);
        }
    }

    protected abstract void beforeDestroyingBlock(LevelAccessor var1, BlockPos var2, BlockState var3);

    protected int getSlopeDistance(LevelReader p_76027_, BlockPos p_76028_, int p_76029_, Direction p_76030_, BlockState p_76031_, SpreadContext p_364491_) {
        int $$6 = 1000;
        for (Direction $$7 : Direction.Plane.HORIZONTAL) {
            int $$11;
            if ($$7 == p_76030_) continue;
            BlockPos $$8 = p_76028_.relative($$7);
            BlockState $$9 = p_364491_.getBlockState($$8);
            FluidState $$10 = $$9.getFluidState();
            if (!this.canPassThrough(p_76027_, this.getFlowing(), p_76028_, p_76031_, $$7, $$8, $$9, $$10)) continue;
            if (p_364491_.isHole($$8)) {
                return p_76029_;
            }
            if (p_76029_ >= this.getSlopeFindDistance(p_76027_) || ($$11 = this.getSlopeDistance(p_76027_, $$8, p_76029_ + 1, $$7.getOpposite(), $$9, p_364491_)) >= $$6) continue;
            $$6 = $$11;
        }
        return $$6;
    }

    boolean isWaterHole(BlockGetter p_75957_, BlockPos p_75959_, BlockState p_75960_, BlockPos p_75961_, BlockState p_75962_) {
        if (!FlowingFluid.canPassThroughWall(Direction.DOWN, p_75957_, p_75959_, p_75960_, p_75961_, p_75962_)) {
            return false;
        }
        if (p_75962_.getFluidState().getType().isSame(this)) {
            return true;
        }
        return FlowingFluid.canHoldFluid(p_75957_, p_75961_, p_75962_, this.getFlowing());
    }

    private boolean canPassThrough(BlockGetter p_75964_, Fluid p_75965_, BlockPos p_75966_, BlockState p_75967_, Direction p_75968_, BlockPos p_75969_, BlockState p_75970_, FluidState p_75971_) {
        return this.canMaybePassThrough(p_75964_, p_75966_, p_75967_, p_75968_, p_75969_, p_75970_, p_75971_) && FlowingFluid.canHoldSpecificFluid(p_75964_, p_75969_, p_75970_, p_75965_);
    }

    private boolean canMaybePassThrough(BlockGetter p_361039_, BlockPos p_364099_, BlockState p_363055_, Direction p_361101_, BlockPos p_362307_, BlockState p_363139_, FluidState p_362538_) {
        return !this.isSourceBlockOfThisType(p_362538_) && FlowingFluid.canHoldAnyFluid(p_363139_) && FlowingFluid.canPassThroughWall(p_361101_, p_361039_, p_364099_, p_363055_, p_362307_, p_363139_);
    }

    private boolean isSourceBlockOfThisType(FluidState p_76097_) {
        return p_76097_.getType().isSame(this) && p_76097_.isSource();
    }

    protected abstract int getSlopeFindDistance(LevelReader var1);

    private int sourceNeighborCount(LevelReader p_76020_, BlockPos p_76021_) {
        int $$2 = 0;
        for (Direction $$3 : Direction.Plane.HORIZONTAL) {
            BlockPos $$4 = p_76021_.relative($$3);
            FluidState $$5 = p_76020_.getFluidState($$4);
            if (!this.isSourceBlockOfThisType($$5)) continue;
            ++$$2;
        }
        return $$2;
    }

    protected Map<Direction, FluidState> getSpread(ServerLevel p_376283_, BlockPos p_76081_, BlockState p_76082_) {
        int $$3 = 1000;
        EnumMap $$4 = Maps.newEnumMap(Direction.class);
        SpreadContext $$5 = null;
        for (Direction $$6 : Direction.Plane.HORIZONTAL) {
            int $$12;
            FluidState $$10;
            FluidState $$9;
            BlockState $$8;
            BlockPos $$7;
            if (!this.canMaybePassThrough(p_376283_, p_76081_, p_76082_, $$6, $$7 = p_76081_.relative($$6), $$8 = p_376283_.getBlockState($$7), $$9 = $$8.getFluidState()) || !FlowingFluid.canHoldSpecificFluid(p_376283_, $$7, $$8, ($$10 = this.getNewLiquid(p_376283_, $$7, $$8)).getType())) continue;
            if ($$5 == null) {
                $$5 = new SpreadContext(p_376283_, p_76081_);
            }
            if ($$5.isHole($$7)) {
                boolean $$11 = false;
            } else {
                $$12 = this.getSlopeDistance(p_376283_, $$7, 1, $$6.getOpposite(), $$8, $$5);
            }
            if ($$12 < $$3) {
                $$4.clear();
            }
            if ($$12 > $$3) continue;
            if ($$9.canBeReplacedWith(p_376283_, $$7, $$10.getType(), $$6)) {
                $$4.put($$6, $$10);
            }
            $$3 = $$12;
        }
        return $$4;
    }

    private static boolean canHoldAnyFluid(BlockState p_362073_) {
        Block $$1 = p_362073_.getBlock();
        if ($$1 instanceof LiquidBlockContainer) {
            return true;
        }
        if (p_362073_.blocksMotion()) {
            return false;
        }
        return !($$1 instanceof DoorBlock) && !p_362073_.is(BlockTags.SIGNS) && !p_362073_.is(Blocks.LADDER) && !p_362073_.is(Blocks.SUGAR_CANE) && !p_362073_.is(Blocks.BUBBLE_COLUMN) && !p_362073_.is(Blocks.NETHER_PORTAL) && !p_362073_.is(Blocks.END_PORTAL) && !p_362073_.is(Blocks.END_GATEWAY) && !p_362073_.is(Blocks.STRUCTURE_VOID);
    }

    private static boolean canHoldFluid(BlockGetter p_75973_, BlockPos p_75974_, BlockState p_75975_, Fluid p_75976_) {
        return FlowingFluid.canHoldAnyFluid(p_75975_) && FlowingFluid.canHoldSpecificFluid(p_75973_, p_75974_, p_75975_, p_75976_);
    }

    private static boolean canHoldSpecificFluid(BlockGetter p_361904_, BlockPos p_360557_, BlockState p_365254_, Fluid p_365308_) {
        Block $$4 = p_365254_.getBlock();
        if ($$4 instanceof LiquidBlockContainer) {
            LiquidBlockContainer $$5 = (LiquidBlockContainer)((Object)$$4);
            return $$5.canPlaceLiquid(null, p_361904_, p_360557_, p_365254_, p_365308_);
        }
        return true;
    }

    protected abstract int getDropOff(LevelReader var1);

    protected int getSpreadDelay(Level p_75998_, BlockPos p_75999_, FluidState p_76000_, FluidState p_76001_) {
        return this.getTickDelay(p_75998_);
    }

    @Override
    public void tick(ServerLevel p_376710_, BlockPos p_75996_, BlockState p_360412_, FluidState p_75997_) {
        if (!p_75997_.isSource()) {
            FluidState $$4 = this.getNewLiquid(p_376710_, p_75996_, p_376710_.getBlockState(p_75996_));
            int $$5 = this.getSpreadDelay(p_376710_, p_75996_, p_75997_, $$4);
            if ($$4.isEmpty()) {
                p_75997_ = $$4;
                p_360412_ = Blocks.AIR.defaultBlockState();
                p_376710_.setBlock(p_75996_, p_360412_, 3);
            } else if ($$4 != p_75997_) {
                p_75997_ = $$4;
                p_360412_ = p_75997_.createLegacyBlock();
                p_376710_.setBlock(p_75996_, p_360412_, 3);
                p_376710_.scheduleTick(p_75996_, p_75997_.getType(), $$5);
            }
        }
        this.spread(p_376710_, p_75996_, p_360412_, p_75997_);
    }

    protected static int getLegacyLevel(FluidState p_76093_) {
        if (p_76093_.isSource()) {
            return 0;
        }
        return 8 - Math.min(p_76093_.getAmount(), 8) + (p_76093_.getValue(FALLING) != false ? 8 : 0);
    }

    private static boolean hasSameAbove(FluidState p_76089_, BlockGetter p_76090_, BlockPos p_76091_) {
        return p_76089_.getType().isSame(p_76090_.getFluidState(p_76091_.above()).getType());
    }

    @Override
    public float getHeight(FluidState p_76050_, BlockGetter p_76051_, BlockPos p_76052_) {
        if (FlowingFluid.hasSameAbove(p_76050_, p_76051_, p_76052_)) {
            return 1.0f;
        }
        return p_76050_.getOwnHeight();
    }

    @Override
    public float getOwnHeight(FluidState p_76048_) {
        return (float)p_76048_.getAmount() / 9.0f;
    }

    @Override
    public abstract int getAmount(FluidState var1);

    @Override
    public VoxelShape getShape(FluidState p_76084_, BlockGetter p_76085_, BlockPos p_76086_) {
        if (p_76084_.getAmount() == 9 && FlowingFluid.hasSameAbove(p_76084_, p_76085_, p_76086_)) {
            return Shapes.block();
        }
        return this.shapes.computeIfAbsent(p_76084_, p_76073_ -> Shapes.box(0.0, 0.0, 0.0, 1.0, p_76073_.getHeight(p_76085_, p_76086_), 1.0));
    }

    record BlockStatePairKey(BlockState first, BlockState second, Direction direction) {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object p_368747_) {
            if (!(p_368747_ instanceof BlockStatePairKey)) return false;
            BlockStatePairKey $$1 = (BlockStatePairKey)p_368747_;
            if (this.first != $$1.first) return false;
            if (this.second != $$1.second) return false;
            if (this.direction != $$1.direction) return false;
            return true;
        }

        @Override
        public int hashCode() {
            int $$0 = System.identityHashCode(this.first);
            $$0 = 31 * $$0 + System.identityHashCode(this.second);
            $$0 = 31 * $$0 + this.direction.hashCode();
            return $$0;
        }
    }

    protected class SpreadContext {
        private final BlockGetter level;
        private final BlockPos origin;
        private final Short2ObjectMap<BlockState> stateCache = new Short2ObjectOpenHashMap();
        private final Short2BooleanMap holeCache = new Short2BooleanOpenHashMap();

        SpreadContext(BlockGetter p_364617_, BlockPos p_361136_) {
            this.level = p_364617_;
            this.origin = p_361136_;
        }

        public BlockState getBlockState(BlockPos p_361206_) {
            return this.getBlockState(p_361206_, this.getCacheKey(p_361206_));
        }

        private BlockState getBlockState(BlockPos p_360376_, short p_364307_) {
            return (BlockState)this.stateCache.computeIfAbsent(p_364307_, p_361149_ -> this.level.getBlockState(p_360376_));
        }

        public boolean isHole(BlockPos p_362369_) {
            return this.holeCache.computeIfAbsent(this.getCacheKey(p_362369_), p_363178_ -> {
                BlockState $$2 = this.getBlockState(p_362369_, p_363178_);
                BlockPos $$3 = p_362369_.below();
                BlockState $$4 = this.level.getBlockState($$3);
                return FlowingFluid.this.isWaterHole(this.level, p_362369_, $$2, $$3, $$4);
            });
        }

        private short getCacheKey(BlockPos p_362251_) {
            int $$1 = p_362251_.getX() - this.origin.getX();
            int $$2 = p_362251_.getZ() - this.origin.getZ();
            return (short)(($$1 + 128 & 0xFF) << 8 | $$2 + 128 & 0xFF);
        }
    }
}

