/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.logging.LogUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentStructure;
import org.slf4j.Logger;

public final class StructureStart {
    public static final String INVALID_START_ID = "INVALID";
    public static final StructureStart INVALID_START = new StructureStart(null, new ChunkPos(0, 0), 0, new PiecesContainer(List.of()));
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Structure structure;
    private final PiecesContainer pieceContainer;
    private final ChunkPos chunkPos;
    private int references;
    @Nullable
    private volatile BoundingBox cachedBoundingBox;

    public StructureStart(Structure p_226846_, ChunkPos p_226847_, int p_226848_, PiecesContainer p_226849_) {
        this.structure = p_226846_;
        this.chunkPos = p_226847_;
        this.references = p_226848_;
        this.pieceContainer = p_226849_;
    }

    @Nullable
    public static StructureStart loadStaticStart(StructurePieceSerializationContext p_226858_, CompoundTag p_226859_, long p_226860_) {
        String $$3 = p_226859_.getStringOr("id", "");
        if (INVALID_START_ID.equals($$3)) {
            return INVALID_START;
        }
        HolderLookup.RegistryLookup $$4 = p_226858_.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        Structure $$5 = (Structure)$$4.getValue(ResourceLocation.parse($$3));
        if ($$5 == null) {
            LOGGER.error("Unknown stucture id: {}", (Object)$$3);
            return null;
        }
        ChunkPos $$6 = new ChunkPos(p_226859_.getIntOr("ChunkX", 0), p_226859_.getIntOr("ChunkZ", 0));
        int $$7 = p_226859_.getIntOr("references", 0);
        ListTag $$8 = p_226859_.getListOrEmpty("Children");
        try {
            PiecesContainer $$9 = PiecesContainer.load($$8, p_226858_);
            if ($$5 instanceof OceanMonumentStructure) {
                $$9 = OceanMonumentStructure.regeneratePiecesAfterLoad($$6, p_226860_, $$9);
            }
            return new StructureStart($$5, $$6, $$7, $$9);
        }
        catch (Exception $$10) {
            LOGGER.error("Failed Start with id {}", (Object)$$3, (Object)$$10);
            return null;
        }
    }

    public BoundingBox getBoundingBox() {
        BoundingBox $$0 = this.cachedBoundingBox;
        if ($$0 == null) {
            this.cachedBoundingBox = $$0 = this.structure.adjustBoundingBox(this.pieceContainer.calculateBoundingBox());
        }
        return $$0;
    }

    public void placeInChunk(WorldGenLevel p_226851_, StructureManager p_226852_, ChunkGenerator p_226853_, RandomSource p_226854_, BoundingBox p_226855_, ChunkPos p_226856_) {
        List<StructurePiece> $$6 = this.pieceContainer.pieces();
        if ($$6.isEmpty()) {
            return;
        }
        BoundingBox $$7 = $$6.get((int)0).boundingBox;
        BlockPos $$8 = $$7.getCenter();
        BlockPos $$9 = new BlockPos($$8.getX(), $$7.minY(), $$8.getZ());
        for (StructurePiece $$10 : $$6) {
            if (!$$10.getBoundingBox().intersects(p_226855_)) continue;
            $$10.postProcess(p_226851_, p_226852_, p_226853_, p_226854_, p_226855_, p_226856_, $$9);
        }
        this.structure.afterPlace(p_226851_, p_226852_, p_226853_, p_226854_, p_226855_, p_226856_, this.pieceContainer);
    }

    public CompoundTag createTag(StructurePieceSerializationContext p_192661_, ChunkPos p_192662_) {
        CompoundTag $$2 = new CompoundTag();
        if (!this.isValid()) {
            $$2.putString("id", INVALID_START_ID);
            return $$2;
        }
        $$2.putString("id", p_192661_.registryAccess().lookupOrThrow(Registries.STRUCTURE).getKey(this.structure).toString());
        $$2.putInt("ChunkX", p_192662_.x);
        $$2.putInt("ChunkZ", p_192662_.z);
        $$2.putInt("references", this.references);
        $$2.put("Children", this.pieceContainer.save(p_192661_));
        return $$2;
    }

    public boolean isValid() {
        return !this.pieceContainer.isEmpty();
    }

    public ChunkPos getChunkPos() {
        return this.chunkPos;
    }

    public boolean canBeReferenced() {
        return this.references < this.getMaxReferences();
    }

    public void addReference() {
        ++this.references;
    }

    public int getReferences() {
        return this.references;
    }

    protected int getMaxReferences() {
        return 1;
    }

    public Structure getStructure() {
        return this.structure;
    }

    public List<StructurePiece> getPieces() {
        return this.pieceContainer.pieces();
    }
}

